/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download.core.breakpoint;

import android.util.SparseArray;
import com.taptap.sdk.update.download.DownloadTask;
import java.util.HashMap;

public class KeyToIdMap {
    private final HashMap<String, Integer> keyToIdMap;
    private final SparseArray<String> idToKeyMap;

    KeyToIdMap() {
        this(new HashMap<String, Integer>(), (SparseArray<String>)new SparseArray());
    }

    KeyToIdMap(HashMap<String, Integer> keyToIdMap, SparseArray<String> idToKeyMap) {
        this.keyToIdMap = keyToIdMap;
        this.idToKeyMap = idToKeyMap;
    }

    public Integer get(DownloadTask task) {
        Integer candidate = this.keyToIdMap.get(this.generateKey(task));
        if (candidate != null) {
            return candidate;
        }
        return null;
    }

    public void remove(int id2) {
        String key = (String)this.idToKeyMap.get(id2);
        if (key != null) {
            this.keyToIdMap.remove(key);
            this.idToKeyMap.remove(id2);
        }
    }

    public void add(DownloadTask task, int id2) {
        String key = this.generateKey(task);
        this.keyToIdMap.put(key, id2);
        this.idToKeyMap.put(id2, (Object)key);
    }

    String generateKey(DownloadTask task) {
        String tag = task.getTag() == null ? "" : (String)task.getTag();
        return tag + task.getFilename();
    }
}

