/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download.core.breakpoint;

import android.database.sqlite.SQLiteDatabase;
import com.taptap.sdk.update.download.DownloadTask;
import com.taptap.sdk.update.download.OkDownload;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointInfo;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointSQLiteHelper;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointStore;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointStoreOnSQLite;
import com.taptap.sdk.update.download.core.breakpoint.DownloadStore;
import com.taptap.sdk.update.download.core.breakpoint.RemitSyncExecutor;
import com.taptap.sdk.update.download.core.breakpoint.RemitSyncToDBHelper;
import com.taptap.sdk.update.download.core.cause.EndCause;
import java.io.IOException;
import java.util.List;

public class RemitStoreOnSQLite
implements RemitSyncExecutor.RemitAgent,
DownloadStore {
    private static final String TAG = "RemitStoreOnSQLite";
    private final RemitSyncToDBHelper remitHelper;
    private final BreakpointStoreOnSQLite onSQLiteWrapper;
    private final BreakpointSQLiteHelper sqLiteHelper;
    private final DownloadStore sqliteCache;

    RemitStoreOnSQLite(BreakpointStoreOnSQLite sqlite) {
        this.remitHelper = new RemitSyncToDBHelper(this);
        this.onSQLiteWrapper = sqlite;
        this.sqliteCache = this.onSQLiteWrapper.onCache;
        this.sqLiteHelper = this.onSQLiteWrapper.helper;
    }

    RemitStoreOnSQLite(RemitSyncToDBHelper helper, BreakpointStoreOnSQLite sqlite, DownloadStore sqliteCache, BreakpointSQLiteHelper sqLiteHelper) {
        this.remitHelper = helper;
        this.onSQLiteWrapper = sqlite;
        this.sqliteCache = sqliteCache;
        this.sqLiteHelper = sqLiteHelper;
    }

    @Override
    public BreakpointInfo get(int id2) {
        return this.onSQLiteWrapper.get(id2);
    }

    @Override
    public BreakpointInfo createAndInsert(DownloadTask task) throws IOException {
        if (this.remitHelper.isNotFreeToDatabase(task.getId())) {
            return this.sqliteCache.createAndInsert(task);
        }
        return this.onSQLiteWrapper.createAndInsert(task);
    }

    @Override
    public void onTaskStart(int id2) {
        this.onSQLiteWrapper.onTaskStart(id2);
        this.remitHelper.onTaskStart(id2);
    }

    @Override
    public void onSyncToFilesystemSuccess(BreakpointInfo info, int blockIndex, long increaseLength) throws IOException {
        if (this.remitHelper.isNotFreeToDatabase(info.getId())) {
            this.sqliteCache.onSyncToFilesystemSuccess(info, blockIndex, increaseLength);
            return;
        }
        this.onSQLiteWrapper.onSyncToFilesystemSuccess(info, blockIndex, increaseLength);
    }

    @Override
    public boolean update(BreakpointInfo info) throws IOException {
        if (this.remitHelper.isNotFreeToDatabase(info.getId())) {
            return this.sqliteCache.update(info);
        }
        return this.onSQLiteWrapper.update(info);
    }

    @Override
    public void onTaskEnd(int id2, EndCause cause, Exception exception) {
        this.sqliteCache.onTaskEnd(id2, cause, exception);
        if (cause == EndCause.COMPLETED) {
            this.remitHelper.discard(id2);
        } else {
            this.remitHelper.endAndEnsureToDB(id2);
        }
    }

    @Override
    public BreakpointInfo getAfterCompleted(int id2) {
        return null;
    }

    @Override
    public boolean markFileDirty(int id2) {
        return this.onSQLiteWrapper.markFileDirty(id2);
    }

    @Override
    public boolean markFileClear(int id2) {
        return this.onSQLiteWrapper.markFileClear(id2);
    }

    @Override
    public void remove(int id2) {
        this.sqliteCache.remove(id2);
        this.remitHelper.discard(id2);
    }

    @Override
    public int findOrCreateId(DownloadTask task) {
        return this.onSQLiteWrapper.findOrCreateId(task);
    }

    @Override
    public BreakpointInfo findAnotherInfoFromCompare(DownloadTask task, BreakpointInfo ignored) {
        return this.onSQLiteWrapper.findAnotherInfoFromCompare(task, ignored);
    }

    @Override
    public boolean isOnlyMemoryCache() {
        return false;
    }

    @Override
    public boolean isFileDirty(int id2) {
        return this.onSQLiteWrapper.isFileDirty(id2);
    }

    @Override
    public String getResponseFilename(String url) {
        return this.onSQLiteWrapper.getResponseFilename(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncCacheToDB(List<Integer> idList) throws IOException {
        SQLiteDatabase database = this.sqLiteHelper.getWritableDatabase();
        database.beginTransaction();
        try {
            for (Integer id2 : idList) {
                this.syncCacheToDB(id2);
            }
            database.setTransactionSuccessful();
        }
        finally {
            database.endTransaction();
        }
    }

    @Override
    public void syncCacheToDB(int id2) throws IOException {
        this.sqLiteHelper.removeInfo(id2);
        BreakpointInfo info = this.sqliteCache.get(id2);
        if (info == null || info.getFilename() == null || info.getTotalOffset() <= 0L) {
            return;
        }
        this.sqLiteHelper.insert(info);
    }

    @Override
    public void removeInfo(int id2) {
        this.sqLiteHelper.removeInfo(id2);
    }

    public static void setRemitToDBDelayMillis(int delayMillis) {
        BreakpointStore store = OkDownload.with().breakpointStore();
        if (!(store instanceof RemitStoreOnSQLite)) {
            throw new IllegalStateException("The current store is " + store + " not RemitStoreOnSQLite!");
        }
        delayMillis = Math.max(0, delayMillis);
        ((RemitStoreOnSQLite)store).remitHelper.delayMillis = delayMillis;
    }
}

