/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download.core.dispatcher;

import android.os.SystemClock;
import com.taptap.sdk.update.download.DownloadTask;
import com.taptap.sdk.update.download.OkDownload;
import com.taptap.sdk.update.download.StatusUtil;
import com.taptap.sdk.update.download.core.IdentifiedTask;
import com.taptap.sdk.update.download.core.Util;
import com.taptap.sdk.update.download.core.breakpoint.DownloadStore;
import com.taptap.sdk.update.download.core.cause.EndCause;
import com.taptap.sdk.update.download.core.dispatcher.CallbackDispatcher;
import com.taptap.sdk.update.download.core.download.DownloadCall;
import java.io.File;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class DownloadDispatcher {
    private static final String TAG = "DownloadDispatcher";
    int maxParallelRunningCount = 5;
    private final List<DownloadCall> readyAsyncCalls;
    private final List<DownloadCall> runningAsyncCalls;
    private final List<DownloadCall> runningSyncCalls;
    private final List<DownloadCall> finishingCalls;
    private final AtomicInteger flyingCanceledAsyncCallCount = new AtomicInteger();
    private volatile ExecutorService executorService;
    private final AtomicInteger skipProceedCallCount = new AtomicInteger();
    private DownloadStore store;

    public DownloadDispatcher() {
        this(new ArrayList<DownloadCall>(), new ArrayList<DownloadCall>(), new ArrayList<DownloadCall>(), new ArrayList<DownloadCall>());
    }

    DownloadDispatcher(List<DownloadCall> readyAsyncCalls, List<DownloadCall> runningAsyncCalls, List<DownloadCall> runningSyncCalls, List<DownloadCall> finishingCalls) {
        this.readyAsyncCalls = readyAsyncCalls;
        this.runningAsyncCalls = runningAsyncCalls;
        this.runningSyncCalls = runningSyncCalls;
        this.finishingCalls = finishingCalls;
    }

    public void setDownloadStore(DownloadStore store) {
        this.store = store;
    }

    synchronized ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkDownload Download", false));
        }
        return this.executorService;
    }

    public void enqueue(DownloadTask[] tasks) {
        this.skipProceedCallCount.incrementAndGet();
        this.enqueueLocked(tasks);
        this.skipProceedCallCount.decrementAndGet();
    }

    public void enqueue(DownloadTask task) {
        this.skipProceedCallCount.incrementAndGet();
        this.enqueueLocked(task);
        this.skipProceedCallCount.decrementAndGet();
    }

    private synchronized void enqueueLocked(DownloadTask[] tasks) {
        long startTime = SystemClock.uptimeMillis();
        Util.d(TAG, "start enqueueLocked for bunch task: " + tasks.length);
        ArrayList taskList = new ArrayList();
        Collections.addAll(taskList, tasks);
        if (taskList.size() > 1) {
            Collections.sort(taskList);
        }
        int originReadyAsyncCallSize = this.readyAsyncCalls.size();
        try {
            OkDownload.with().downloadStrategy().inspectNetworkAvailable();
            ArrayList<DownloadTask> completedTaskList = new ArrayList<DownloadTask>();
            ArrayList<DownloadTask> sameTaskConflictList = new ArrayList<DownloadTask>();
            ArrayList<DownloadTask> fileBusyList = new ArrayList<DownloadTask>();
            for (DownloadTask task : taskList) {
                if (this.inspectCompleted(task, completedTaskList) || this.inspectForConflict(task, sameTaskConflictList, fileBusyList)) continue;
                this.enqueueIgnorePriority(task);
            }
            OkDownload.with().callbackDispatcher().endTasks(completedTaskList, sameTaskConflictList, fileBusyList);
        }
        catch (UnknownHostException e) {
            ArrayList<DownloadTask> errorList = new ArrayList<DownloadTask>(taskList);
            OkDownload.with().callbackDispatcher().endTasksWithError(errorList, e);
        }
        if (originReadyAsyncCallSize != this.readyAsyncCalls.size()) {
            Collections.sort(this.readyAsyncCalls);
        }
        Util.d(TAG, "end enqueueLocked for bunch task: " + tasks.length + " consume " + (SystemClock.uptimeMillis() - startTime) + "ms");
    }

    private synchronized void enqueueLocked(DownloadTask task) {
        Util.d(TAG, "enqueueLocked for single task: " + task);
        if (this.inspectCompleted(task)) {
            return;
        }
        if (this.inspectForConflict(task)) {
            return;
        }
        int originReadyAsyncCallSize = this.readyAsyncCalls.size();
        this.enqueueIgnorePriority(task);
        if (originReadyAsyncCallSize != this.readyAsyncCalls.size()) {
            Collections.sort(this.readyAsyncCalls);
        }
    }

    private synchronized void enqueueIgnorePriority(DownloadTask task) {
        DownloadCall call = DownloadCall.create(task, true, this.store);
        if (this.runningAsyncSize() < this.maxParallelRunningCount) {
            this.runningAsyncCalls.add(call);
            this.getExecutorService().execute(call);
        } else {
            this.readyAsyncCalls.add(call);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DownloadTask task) {
        DownloadCall call;
        Util.d(TAG, "execute: " + task);
        DownloadDispatcher downloadDispatcher = this;
        synchronized (downloadDispatcher) {
            if (this.inspectCompleted(task)) {
                return;
            }
            if (this.inspectForConflict(task)) {
                return;
            }
            call = DownloadCall.create(task, false, this.store);
            this.runningSyncCalls.add(call);
        }
        this.syncRunCall(call);
    }

    public void cancelAll() {
        this.skipProceedCallCount.incrementAndGet();
        ArrayList<DownloadTask> taskList = new ArrayList<DownloadTask>();
        for (DownloadCall call : this.readyAsyncCalls) {
            taskList.add(call.task);
        }
        for (DownloadCall call : this.runningAsyncCalls) {
            taskList.add(call.task);
        }
        for (DownloadCall call : this.runningSyncCalls) {
            taskList.add(call.task);
        }
        if (!taskList.isEmpty()) {
            DownloadTask[] tasks = new DownloadTask[taskList.size()];
            this.cancelLocked(taskList.toArray(tasks));
        }
        this.skipProceedCallCount.decrementAndGet();
    }

    public void cancel(IdentifiedTask[] tasks) {
        this.skipProceedCallCount.incrementAndGet();
        this.cancelLocked(tasks);
        this.skipProceedCallCount.decrementAndGet();
        this.processCalls();
    }

    public boolean cancel(IdentifiedTask task) {
        this.skipProceedCallCount.incrementAndGet();
        boolean result = this.cancelLocked(task);
        this.skipProceedCallCount.decrementAndGet();
        this.processCalls();
        return result;
    }

    public boolean cancel(int id2) {
        this.skipProceedCallCount.incrementAndGet();
        boolean result = this.cancelLocked(DownloadTask.mockTaskForCompare(id2));
        this.skipProceedCallCount.decrementAndGet();
        this.processCalls();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cancelLocked(IdentifiedTask[] tasks) {
        long startCancelTime = SystemClock.uptimeMillis();
        Util.d(TAG, "start cancel bunch task manually: " + tasks.length);
        ArrayList<DownloadCall> needCallbackCalls = new ArrayList<DownloadCall>();
        ArrayList<DownloadCall> needCancelCalls = new ArrayList<DownloadCall>();
        try {
            for (IdentifiedTask task : tasks) {
                this.filterCanceledCalls(task, needCallbackCalls, needCancelCalls);
            }
        }
        finally {
            this.handleCanceledCalls(needCallbackCalls, needCancelCalls);
            Util.d(TAG, "finish cancel bunch task manually: " + tasks.length + " consume " + (SystemClock.uptimeMillis() - startCancelTime) + "ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean cancelLocked(IdentifiedTask task) {
        Util.d(TAG, "cancel manually: " + task.getId());
        ArrayList<DownloadCall> needCallbackCalls = new ArrayList<DownloadCall>();
        ArrayList<DownloadCall> needCancelCalls = new ArrayList<DownloadCall>();
        try {
            this.filterCanceledCalls(task, needCallbackCalls, needCancelCalls);
        }
        finally {
            this.handleCanceledCalls(needCallbackCalls, needCancelCalls);
        }
        return needCallbackCalls.size() > 0 || needCancelCalls.size() > 0;
    }

    private synchronized void filterCanceledCalls(IdentifiedTask task, List<DownloadCall> needCallbackCalls, List<DownloadCall> needCancelCalls) {
        Iterator<DownloadCall> i = this.readyAsyncCalls.iterator();
        while (i.hasNext()) {
            DownloadCall call = i.next();
            if (call.task != task && call.task.getId() != task.getId()) continue;
            if (call.isCanceled() || call.isFinishing()) {
                return;
            }
            i.remove();
            needCallbackCalls.add(call);
            return;
        }
        for (DownloadCall call : this.runningAsyncCalls) {
            if (call.task != task && call.task.getId() != task.getId()) continue;
            needCallbackCalls.add(call);
            needCancelCalls.add(call);
            return;
        }
        for (DownloadCall call : this.runningSyncCalls) {
            if (call.task != task && call.task.getId() != task.getId()) continue;
            needCallbackCalls.add(call);
            needCancelCalls.add(call);
            return;
        }
    }

    private synchronized void handleCanceledCalls(List<DownloadCall> needCallbackCalls, List<DownloadCall> needCancelCalls) {
        Util.d(TAG, "handle cancel calls, cancel calls: " + needCancelCalls.size());
        if (!needCancelCalls.isEmpty()) {
            for (DownloadCall call : needCancelCalls) {
                if (call.cancel()) continue;
                needCallbackCalls.remove(call);
            }
        }
        Util.d(TAG, "handle cancel calls, callback cancel event: " + needCallbackCalls.size());
        if (!needCallbackCalls.isEmpty()) {
            if (needCallbackCalls.size() <= 1) {
                DownloadCall call = needCallbackCalls.get(0);
                OkDownload.with().callbackDispatcher().dispatch().taskEnd(call.task, EndCause.CANCELED, null);
            } else {
                ArrayList<DownloadTask> callbackCanceledTasks = new ArrayList<DownloadTask>();
                for (DownloadCall call : needCallbackCalls) {
                    callbackCanceledTasks.add(call.task);
                }
                OkDownload.with().callbackDispatcher().endTasksWithCanceled(callbackCanceledTasks);
            }
        }
    }

    public synchronized DownloadTask findSameTask(DownloadTask task) {
        Util.d(TAG, "findSameTask: " + task.getId());
        for (DownloadCall call : this.readyAsyncCalls) {
            if (call.isCanceled() || !call.equalsTask(task)) continue;
            return call.task;
        }
        for (DownloadCall call : this.runningAsyncCalls) {
            if (call.isCanceled() || !call.equalsTask(task)) continue;
            return call.task;
        }
        for (DownloadCall call : this.runningSyncCalls) {
            if (call.isCanceled() || !call.equalsTask(task)) continue;
            return call.task;
        }
        return null;
    }

    public synchronized boolean isRunning(DownloadTask task) {
        Util.d(TAG, "isRunning: " + task.getId());
        for (DownloadCall call : this.runningSyncCalls) {
            if (call.isCanceled() || !call.equalsTask(task)) continue;
            return true;
        }
        for (DownloadCall call : this.runningAsyncCalls) {
            if (call.isCanceled() || !call.equalsTask(task)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isPending(DownloadTask task) {
        Util.d(TAG, "isPending: " + task.getId());
        for (DownloadCall call : this.readyAsyncCalls) {
            if (call.isCanceled() || !call.equalsTask(task)) continue;
            return true;
        }
        return false;
    }

    void syncRunCall(DownloadCall call) {
        call.run();
    }

    public synchronized void flyingCanceled(DownloadCall call) {
        Util.d(TAG, "flying canceled: " + call.task.getId());
        if (call.asyncExecuted) {
            this.flyingCanceledAsyncCallCount.incrementAndGet();
        }
    }

    public synchronized void finish(DownloadCall call) {
        boolean asyncExecuted = call.asyncExecuted;
        List<DownloadCall> calls = this.finishingCalls.contains(call) ? this.finishingCalls : (asyncExecuted ? this.runningAsyncCalls : this.runningSyncCalls);
        if (!calls.remove(call)) {
            throw new AssertionError((Object)"Call wasn't in-flight!");
        }
        if (asyncExecuted && call.isCanceled()) {
            this.flyingCanceledAsyncCallCount.decrementAndGet();
        }
        if (asyncExecuted) {
            this.processCalls();
        }
    }

    public synchronized boolean isFileConflictAfterRun(DownloadTask task) {
        File otherFile;
        Util.d(TAG, "is file conflict after run: " + task.getId());
        File file = task.getFile();
        if (file == null) {
            return false;
        }
        for (DownloadCall syncCall : this.runningSyncCalls) {
            if (syncCall.isCanceled() || syncCall.task == task || (otherFile = syncCall.task.getFile()) == null || !file.equals(otherFile)) continue;
            return true;
        }
        for (DownloadCall asyncCall : this.runningAsyncCalls) {
            if (asyncCall.isCanceled() || asyncCall.task == task || (otherFile = asyncCall.task.getFile()) == null || !file.equals(otherFile)) continue;
            return true;
        }
        return false;
    }

    private boolean inspectForConflict(DownloadTask task) {
        return this.inspectForConflict(task, null, null);
    }

    private boolean inspectForConflict(DownloadTask task, Collection<DownloadTask> sameTaskList, Collection<DownloadTask> fileBusyList) {
        return this.inspectForConflict(task, this.readyAsyncCalls, sameTaskList, fileBusyList) || this.inspectForConflict(task, this.runningAsyncCalls, sameTaskList, fileBusyList) || this.inspectForConflict(task, this.runningSyncCalls, sameTaskList, fileBusyList);
    }

    boolean inspectCompleted(DownloadTask task) {
        return this.inspectCompleted(task, null);
    }

    boolean inspectCompleted(DownloadTask task, Collection<DownloadTask> completedCollection) {
        if (task.isPassIfAlreadyCompleted() && StatusUtil.isCompleted(task)) {
            if (task.getFilename() == null && !OkDownload.with().downloadStrategy().validFilenameFromStore(task)) {
                return false;
            }
            OkDownload.with().downloadStrategy().validInfoOnCompleted(task, this.store);
            if (completedCollection != null) {
                completedCollection.add(task);
            } else {
                OkDownload.with().callbackDispatcher().dispatch().taskEnd(task, EndCause.COMPLETED, null);
            }
            return true;
        }
        return false;
    }

    boolean inspectForConflict(DownloadTask task, Collection<DownloadCall> calls, Collection<DownloadTask> sameTaskList, Collection<DownloadTask> fileBusyList) {
        CallbackDispatcher callbackDispatcher = OkDownload.with().callbackDispatcher();
        Iterator<DownloadCall> iterator = calls.iterator();
        while (iterator.hasNext()) {
            DownloadCall call = iterator.next();
            if (call.isCanceled()) continue;
            if (call.equalsTask(task)) {
                if (call.isFinishing()) {
                    Util.d(TAG, "task: " + task.getId() + " is finishing, move it to finishing list");
                    this.finishingCalls.add(call);
                    iterator.remove();
                    return false;
                }
                if (sameTaskList != null) {
                    sameTaskList.add(task);
                } else {
                    callbackDispatcher.dispatch().taskEnd(task, EndCause.SAME_TASK_BUSY, null);
                }
                return true;
            }
            File file = call.getFile();
            File taskFile = task.getFile();
            if (file == null || taskFile == null || !file.equals(taskFile)) continue;
            if (fileBusyList != null) {
                fileBusyList.add(task);
            } else {
                callbackDispatcher.dispatch().taskEnd(task, EndCause.FILE_BUSY, null);
            }
            return true;
        }
        return false;
    }

    private synchronized void processCalls() {
        if (this.skipProceedCallCount.get() > 0) {
            return;
        }
        if (this.runningAsyncSize() >= this.maxParallelRunningCount) {
            return;
        }
        if (this.readyAsyncCalls.isEmpty()) {
            return;
        }
        Iterator<DownloadCall> i = this.readyAsyncCalls.iterator();
        while (i.hasNext()) {
            DownloadCall call = i.next();
            i.remove();
            DownloadTask task = call.task;
            if (this.isFileConflictAfterRun(task)) {
                OkDownload.with().callbackDispatcher().dispatch().taskEnd(task, EndCause.FILE_BUSY, null);
                continue;
            }
            this.runningAsyncCalls.add(call);
            this.getExecutorService().execute(call);
            if (this.runningAsyncSize() < this.maxParallelRunningCount) continue;
            return;
        }
    }

    private int runningAsyncSize() {
        return this.runningAsyncCalls.size() - this.flyingCanceledAsyncCallCount.get();
    }

    public static void setMaxParallelRunningCount(int maxParallelRunningCount) {
        DownloadDispatcher dispatcher = OkDownload.with().downloadDispatcher();
        if (dispatcher.getClass() != DownloadDispatcher.class) {
            throw new IllegalStateException("The current dispatcher is " + dispatcher + " not DownloadDispatcher exactly!");
        }
        dispatcher.maxParallelRunningCount = maxParallelRunningCount = Math.max(1, maxParallelRunningCount);
    }
}

