/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download.core.listener.assist;

import android.util.SparseArray;
import com.taptap.sdk.update.download.DownloadTask;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointInfo;
import com.taptap.sdk.update.download.core.listener.assist.ListenerAssist;

public class ListenerModelHandler<T extends ListenerModel>
implements ListenerAssist {
    volatile T singleTaskModel;
    final SparseArray<T> modelList = new SparseArray();
    private Boolean alwaysRecoverModel;
    private final ModelCreator<T> creator;

    ListenerModelHandler(ModelCreator<T> creator) {
        this.creator = creator;
    }

    @Override
    public boolean isAlwaysRecoverAssistModel() {
        return this.alwaysRecoverModel != null && this.alwaysRecoverModel != false;
    }

    @Override
    public void setAlwaysRecoverAssistModel(boolean isAlwaysRecoverModel) {
        this.alwaysRecoverModel = isAlwaysRecoverModel;
    }

    @Override
    public void setAlwaysRecoverAssistModelIfNotSet(boolean isAlwaysRecoverAssistModel) {
        if (this.alwaysRecoverModel == null) {
            this.alwaysRecoverModel = isAlwaysRecoverAssistModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T addAndGetModel(DownloadTask task, BreakpointInfo info) {
        T model = this.creator.create(task.getId());
        ListenerModelHandler listenerModelHandler = this;
        synchronized (listenerModelHandler) {
            if (this.singleTaskModel == null) {
                this.singleTaskModel = model;
            } else {
                this.modelList.put(task.getId(), model);
            }
            if (info != null) {
                model.onInfoValid(info);
            }
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T getOrRecoverModel(DownloadTask task, BreakpointInfo info) {
        int id2 = task.getId();
        ListenerModel model = null;
        ListenerModelHandler listenerModelHandler = this;
        synchronized (listenerModelHandler) {
            if (this.singleTaskModel != null && this.singleTaskModel.getId() == id2) {
                model = (ListenerModel)this.singleTaskModel;
            }
        }
        if (model == null) {
            model = (ListenerModel)this.modelList.get(id2);
        }
        if (model != null || !this.isAlwaysRecoverAssistModel()) {
            return (T)model;
        }
        model = this.addAndGetModel(task, info);
        return (T)model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T removeOrCreate(DownloadTask task, BreakpointInfo info) {
        ListenerModel model;
        int id2 = task.getId();
        ListenerModelHandler listenerModelHandler = this;
        synchronized (listenerModelHandler) {
            if (this.singleTaskModel != null && this.singleTaskModel.getId() == id2) {
                model = this.singleTaskModel;
                this.singleTaskModel = null;
            } else {
                model = (ListenerModel)this.modelList.get(id2);
                this.modelList.remove(id2);
            }
        }
        if (model == null) {
            model = this.creator.create(id2);
            if (info != null) {
                model.onInfoValid(info);
            }
        }
        return (T)model;
    }

    static interface ListenerModel {
        public int getId();

        public void onInfoValid(BreakpointInfo var1);
    }

    public static interface ModelCreator<T extends ListenerModel> {
        public T create(int var1);
    }
}

