/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.taptap.sdk.update.R;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b&\u0018\u0000 L2\u00020\u0001:\u0002LMB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ0\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0018\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007H\u0002J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$H\u0014J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010*\u001a\u00020$H\u0014J\u0010\u0010+\u001a\u00020$2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010+\u001a\u00020$2\u0006\u0010#\u001a\u00020$H\u0014J\u0010\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u0007H\u0002J\u0018\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0007H\u0002J\u0010\u00100\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u0007H\u0002J0\u00101\u001a\u00020&2\u0006\u00102\u001a\u00020\u00132\u0006\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u0007H\u0002J0\u00107\u001a\u00020&2\u0006\u00102\u001a\u00020\u00132\u0006\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u0007H\u0002J \u00108\u001a\u00020&2\u0006\u00109\u001a\u00020\u00072\u0006\u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020\u0007H\u0002J \u0010<\u001a\u00020&2\u0006\u00109\u001a\u00020\u00072\u0006\u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020\u0007H\u0002J\u0010\u0010=\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0014J0\u0010>\u001a\u00020&2\u0006\u0010?\u001a\u00020\u00132\u0006\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u0007H\u0014J\u0018\u0010@\u001a\u00020&2\u0006\u00109\u001a\u00020\u00072\u0006\u0010:\u001a\u00020\u0007H\u0014J\u000e\u0010A\u001a\u00020&2\u0006\u0010\t\u001a\u00020\u0007J\u0010\u0010B\u001a\u00020&2\b\u0010C\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010D\u001a\u00020&2\u0006\u0010\u000e\u001a\u00020\u0007J\u000e\u0010E\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010F\u001a\u00020&2\u0006\u0010\u0014\u001a\u00020\u0007J\u000e\u0010G\u001a\u00020&2\u0006\u0010\u0015\u001a\u00020\u0007J\u000e\u0010H\u001a\u00020&2\u0006\u0010\u0016\u001a\u00020\u0007J\u000e\u0010I\u001a\u00020&2\u0006\u0010J\u001a\u00020\u0007J\u000e\u0010K\u001a\u00020&2\u0006\u0010J\u001a\u00020\u0007R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/taptap/sdk/update/ui/FlexLayout;", "Landroid/view/ViewGroup;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "alignItems", "dividerDrawable", "Landroid/graphics/drawable/Drawable;", "dividerHorizontalHeight", "dividerVerticalWidth", "flexDirection", "flexLines", "", "Lcom/taptap/sdk/update/ui/FlexLayout$FlexLine;", "flexWrap", "", "itemSpacing", "justifyContent", "lineSpacing", "showDividerHorizontal", "showDividerVertical", "calculateChildCrossPosition", "lineCrossSize", "childCrossSize", "startMargin", "endMargin", "lineStartPosition", "calculateMainAxisStartPosition", "remainingSpace", "paddingStart", "checkLayoutParams", "p", "Landroid/view/ViewGroup$LayoutParams;", "drawDividersHorizontal", "", "canvas", "Landroid/graphics/Canvas;", "drawDividersVertical", "generateDefaultLayoutParams", "generateLayoutParams", "hasDividerAfterLine", "lineIndex", "hasDividerBeforeItem", "itemIndex", "hasDividerBeforeLine", "layoutColumnDirection", "isRTL", "left", "top", "right", "bottom", "layoutRowDirection", "measureColumnDirection", "widthMeasureSpec", "heightMeasureSpec", "mainAxisSize", "measureRowDirection", "onDraw", "onLayout", "changed", "onMeasure", "setAlignItems", "setDividerDrawable", "drawable", "setFlexDirection", "setFlexWrap", "setItemSpacing", "setJustifyContent", "setLineSpacing", "setShowDividerHorizontal", "showDivider", "setShowDividerVertical", "Companion", "FlexLine", "tap-update_release"})
public final class FlexLayout
extends ViewGroup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int flexDirection;
    private int justifyContent;
    private int alignItems;
    private boolean flexWrap;
    private int itemSpacing;
    private int lineSpacing;
    @Nullable
    private Drawable dividerDrawable;
    private int showDividerHorizontal;
    private int showDividerVertical;
    private int dividerHorizontalHeight;
    private int dividerVerticalWidth;
    @NotNull
    private final List<FlexLine> flexLines;
    public static final int DIRECTION_ROW = 0;
    public static final int DIRECTION_COLUMN = 1;
    public static final int ALIGN_START = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_END = 2;
    public static final int ALIGN_SPACE_BETWEEN = 3;
    public static final int ALIGN_SPACE_AROUND = 4;
    public static final int ALIGN_SPACE_EVENLY = 5;
    public static final int ALIGN_ITEMS_START = 0;
    public static final int ALIGN_ITEMS_CENTER = 1;
    public static final int ALIGN_ITEMS_END = 2;
    public static final int ALIGN_ITEMS_STRETCH = 3;
    public static final int SHOW_DIVIDER_NONE = 0;
    public static final int SHOW_DIVIDER_BEGINNING = 1;
    public static final int SHOW_DIVIDER_MIDDLE = 2;
    public static final int SHOW_DIVIDER_END = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public FlexLayout(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        TypedArray typedArray;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.alignItems = 3;
        this.flexWrap = true;
        this.flexLines = new ArrayList();
        TypedArray $this$_init__u24lambda_u240 = typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.FlexLayout, defStyleAttr, 0);
        boolean bl = false;
        try {
            this.flexDirection = $this$_init__u24lambda_u240.getInt(R.styleable.FlexLayout_flexDirection, 0);
            this.justifyContent = $this$_init__u24lambda_u240.getInt(R.styleable.FlexLayout_justifyContent, 0);
            this.alignItems = $this$_init__u24lambda_u240.getInt(R.styleable.FlexLayout_alignItems, 3);
            this.flexWrap = $this$_init__u24lambda_u240.getBoolean(R.styleable.FlexLayout_flexWrap, true);
            this.itemSpacing = $this$_init__u24lambda_u240.getDimensionPixelSize(R.styleable.FlexLayout_itemSpacing, 0);
            this.lineSpacing = $this$_init__u24lambda_u240.getDimensionPixelSize(R.styleable.FlexLayout_lineSpacing, 0);
            Drawable dividerDrawable = $this$_init__u24lambda_u240.getDrawable(R.styleable.FlexLayout_dividerDrawable);
            if (dividerDrawable != null) {
                this.dividerDrawable = dividerDrawable;
                this.dividerHorizontalHeight = dividerDrawable.getIntrinsicHeight();
                this.dividerVerticalWidth = dividerDrawable.getIntrinsicWidth();
            }
            this.showDividerHorizontal = $this$_init__u24lambda_u240.getInt(R.styleable.FlexLayout_showDividerHorizontal, 0);
            this.showDividerVertical = $this$_init__u24lambda_u240.getInt(R.styleable.FlexLayout_showDividerVertical, 0);
        }
        finally {
            $this$_init__u24lambda_u240.recycle();
        }
        this.setWillNotDraw(false);
    }

    public /* synthetic */ FlexLayout(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final void setFlexDirection(int flexDirection) {
        if (this.flexDirection != flexDirection) {
            this.flexDirection = flexDirection;
            this.requestLayout();
        }
    }

    public final void setJustifyContent(int justifyContent) {
        if (this.justifyContent != justifyContent) {
            this.justifyContent = justifyContent;
            this.requestLayout();
        }
    }

    public final void setAlignItems(int alignItems) {
        if (this.alignItems != alignItems) {
            this.alignItems = alignItems;
            this.requestLayout();
        }
    }

    public final void setFlexWrap(boolean flexWrap) {
        if (this.flexWrap != flexWrap) {
            this.flexWrap = flexWrap;
            this.requestLayout();
        }
    }

    public final void setItemSpacing(int itemSpacing) {
        if (this.itemSpacing != itemSpacing) {
            this.itemSpacing = itemSpacing;
            this.requestLayout();
        }
    }

    public final void setLineSpacing(int lineSpacing) {
        if (this.lineSpacing != lineSpacing) {
            this.lineSpacing = lineSpacing;
            this.requestLayout();
        }
    }

    public final void setDividerDrawable(@Nullable Drawable drawable) {
        if (!Intrinsics.areEqual((Object)this.dividerDrawable, (Object)drawable)) {
            this.dividerDrawable = drawable;
            if (drawable != null) {
                this.dividerHorizontalHeight = drawable.getIntrinsicHeight();
                this.dividerVerticalWidth = drawable.getIntrinsicWidth();
            } else {
                this.dividerHorizontalHeight = 0;
                this.dividerVerticalWidth = 0;
            }
            this.requestLayout();
            this.invalidate();
        }
    }

    public final void setShowDividerHorizontal(int showDivider) {
        if (this.showDividerHorizontal != showDivider) {
            this.showDividerHorizontal = showDivider;
            this.requestLayout();
            this.invalidate();
        }
    }

    public final void setShowDividerVertical(int showDivider) {
        if (this.showDividerVertical != showDivider) {
            this.showDividerVertical = showDivider;
            this.requestLayout();
            this.invalidate();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measuredWidth;
        int mainAxisSize;
        this.flexLines.clear();
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        boolean isExactWidth = widthMode == 0x40000000;
        boolean isExactHeight = heightMode == 0x40000000;
        int availableWidth = widthSize - this.getPaddingLeft() - this.getPaddingRight();
        int availableHeight = heightSize - this.getPaddingTop() - this.getPaddingBottom();
        int n = mainAxisSize = this.flexDirection == 0 ? availableWidth : availableHeight;
        if (this.flexDirection == 0) {
            this.measureRowDirection(widthMeasureSpec, heightMeasureSpec, mainAxisSize);
        } else {
            this.measureColumnDirection(widthMeasureSpec, heightMeasureSpec, mainAxisSize);
        }
        int totalMainSize = 0;
        int totalCrossSize = 0;
        int n2 = this.flexLines.size();
        for (int i = 0; i < n2; ++i) {
            FlexLine flexLine = this.flexLines.get(i);
            totalMainSize = Math.max(totalMainSize, flexLine.getMainSize());
            totalCrossSize += flexLine.getCrossSize();
            if (i >= this.flexLines.size() - 1) continue;
            if (this.flexDirection == 0 && this.hasDividerBeforeLine(i + 1)) {
                totalCrossSize += this.dividerHorizontalHeight;
                continue;
            }
            if (this.flexDirection == 1 && this.hasDividerBeforeLine(i + 1)) {
                totalCrossSize += this.dividerVerticalWidth;
                continue;
            }
            totalCrossSize += this.lineSpacing;
        }
        if (this.flexDirection == 0) {
            if ((this.showDividerHorizontal & 1) != 0) {
                totalCrossSize += this.dividerHorizontalHeight;
            }
            if ((this.showDividerHorizontal & 4) != 0) {
                totalCrossSize += this.dividerHorizontalHeight;
            }
        } else {
            if ((this.showDividerVertical & 1) != 0) {
                totalCrossSize += this.dividerVerticalWidth;
            }
            if ((this.showDividerVertical & 4) != 0) {
                totalCrossSize += this.dividerVerticalWidth;
            }
        }
        int n3 = this.flexDirection == 0 ? (isExactWidth ? widthSize : totalMainSize + this.getPaddingLeft() + this.getPaddingRight()) : (measuredWidth = isExactWidth ? widthSize : totalCrossSize + this.getPaddingLeft() + this.getPaddingRight());
        int measuredHeight = this.flexDirection == 0 ? (isExactHeight ? heightSize : totalCrossSize + this.getPaddingTop() + this.getPaddingBottom()) : (isExactHeight ? heightSize : totalMainSize + this.getPaddingTop() + this.getPaddingBottom());
        this.setMeasuredDimension(measuredWidth, measuredHeight);
    }

    private final void measureRowDirection(int widthMeasureSpec, int heightMeasureSpec, int mainAxisSize) {
        FlexLine currentLine = new FlexLine();
        this.flexLines.add(currentLine);
        int childCount = this.getChildCount();
        int remainingSpace = mainAxisSize;
        for (int i = 0; i < childCount; ++i) {
            FlexLine flexLine;
            boolean shouldWrap;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            ViewGroup.LayoutParams layoutParams = child.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)layoutParams;
            int horizontalMargins = lp.leftMargin + lp.rightMargin;
            int childWidthMeasureSpec = ViewGroup.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight() + horizontalMargins), (int)lp.width);
            int childHeightMeasureSpec = ViewGroup.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom() + lp.topMargin + lp.bottomMargin), (int)lp.height);
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            int childWidth = child.getMeasuredWidth() + horizontalMargins;
            int childHeight = child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
            boolean bl = this.flexWrap && !((Collection)currentLine.getViews()).isEmpty() && (childWidth > remainingSpace || this.hasDividerBeforeItem(currentLine.getViews().size(), this.flexLines.size() - 1)) ? true : (shouldWrap = false);
            if (shouldWrap) {
                currentLine = new FlexLine();
                this.flexLines.add(currentLine);
                remainingSpace = mainAxisSize;
            }
            List<View> list = currentLine.getViews();
            Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
            list.add(child);
            currentLine.getViewMainSizes().add(childWidth);
            currentLine.getViewCrossSizes().add(childHeight);
            if (currentLine.getViews().size() > 1) {
                flexLine = currentLine;
                flexLine.setMainSize(flexLine.getMainSize() + this.itemSpacing);
                if ((this.showDividerVertical & 2) != 0) {
                    flexLine = currentLine;
                    flexLine.setMainSize(flexLine.getMainSize() + this.dividerVerticalWidth);
                }
            }
            flexLine = currentLine;
            flexLine.setMainSize(flexLine.getMainSize() + childWidth);
            currentLine.setCrossSize(Math.max(currentLine.getCrossSize(), childHeight));
            remainingSpace -= childWidth;
            if (currentLine.getViews().size() <= 1) continue;
            remainingSpace -= this.itemSpacing;
            if ((this.showDividerVertical & 2) == 0) continue;
            remainingSpace -= this.dividerVerticalWidth;
        }
    }

    private final void measureColumnDirection(int widthMeasureSpec, int heightMeasureSpec, int mainAxisSize) {
        FlexLine currentLine = new FlexLine();
        this.flexLines.add(currentLine);
        int childCount = this.getChildCount();
        int remainingSpace = mainAxisSize;
        for (int i = 0; i < childCount; ++i) {
            FlexLine flexLine;
            boolean shouldWrap;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            ViewGroup.LayoutParams layoutParams = child.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)layoutParams;
            int verticalMargins = lp.topMargin + lp.bottomMargin;
            int childWidthMeasureSpec = ViewGroup.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin), (int)lp.width);
            int childHeightMeasureSpec = ViewGroup.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom() + verticalMargins), (int)lp.height);
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            int childWidth = child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
            int childHeight = child.getMeasuredHeight() + verticalMargins;
            boolean bl = this.flexWrap && !((Collection)currentLine.getViews()).isEmpty() && (childHeight > remainingSpace || this.hasDividerBeforeItem(currentLine.getViews().size(), this.flexLines.size() - 1)) ? true : (shouldWrap = false);
            if (shouldWrap) {
                currentLine = new FlexLine();
                this.flexLines.add(currentLine);
                remainingSpace = mainAxisSize;
            }
            List<View> list = currentLine.getViews();
            Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
            list.add(child);
            currentLine.getViewMainSizes().add(childHeight);
            currentLine.getViewCrossSizes().add(childWidth);
            if (currentLine.getViews().size() > 1) {
                flexLine = currentLine;
                flexLine.setMainSize(flexLine.getMainSize() + this.itemSpacing);
                if ((this.showDividerHorizontal & 2) != 0) {
                    flexLine = currentLine;
                    flexLine.setMainSize(flexLine.getMainSize() + this.dividerHorizontalHeight);
                }
            }
            flexLine = currentLine;
            flexLine.setMainSize(flexLine.getMainSize() + childHeight);
            currentLine.setCrossSize(Math.max(currentLine.getCrossSize(), childWidth));
            remainingSpace -= childHeight;
            if (currentLine.getViews().size() <= 1) continue;
            remainingSpace -= this.itemSpacing;
            if ((this.showDividerHorizontal & 2) == 0) continue;
            remainingSpace -= this.dividerHorizontalHeight;
        }
    }

    private final boolean hasDividerBeforeLine(int lineIndex) {
        return this.flexDirection == 0 && (this.showDividerHorizontal & 2) != 0 || this.flexDirection == 1 && (this.showDividerVertical & 2) != 0;
    }

    private final boolean hasDividerAfterLine(int lineIndex) {
        return lineIndex == this.flexLines.size() - 1 && (this.flexDirection == 0 && (this.showDividerHorizontal & 4) != 0 || this.flexDirection == 1 && (this.showDividerVertical & 4) != 0);
    }

    private final boolean hasDividerBeforeItem(int itemIndex, int lineIndex) {
        return this.flexDirection == 0 && (this.showDividerVertical & 2) != 0 && itemIndex > 0 && itemIndex < this.flexLines.get(lineIndex).getViews().size() || this.flexDirection == 1 && (this.showDividerHorizontal & 2) != 0 && itemIndex > 0 && itemIndex < this.flexLines.get(lineIndex).getViews().size();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        boolean isRTL;
        boolean bl = isRTL = this.getLayoutDirection() == 1;
        if (this.flexDirection == 0) {
            this.layoutRowDirection(isRTL, left, top, right, bottom);
        } else {
            this.layoutColumnDirection(isRTL, left, top, right, bottom);
        }
    }

    private final void layoutRowDirection(boolean isRTL, int left, int top, int right, int bottom) {
        int width = right - left;
        int paddingStart = isRTL ? this.getPaddingRight() : this.getPaddingLeft();
        int paddingEnd = isRTL ? this.getPaddingLeft() : this.getPaddingRight();
        int currentCrossPosition = this.getPaddingTop();
        if ((this.showDividerHorizontal & 1) != 0) {
            currentCrossPosition += this.dividerHorizontalHeight;
        }
        int n = this.flexLines.size();
        for (int i = 0; i < n; ++i) {
            FlexLine flexLine = this.flexLines.get(i);
            int remainingSpace = width - paddingStart - paddingEnd - flexLine.getMainSize();
            int mainAxisStartPosition = this.calculateMainAxisStartPosition(remainingSpace, paddingStart);
            flexLine.getViewMainPositions().clear();
            flexLine.getViewCrossPositions().clear();
            int n2 = flexLine.getViews().size();
            for (int j = 0; j < n2; ++j) {
                View child = flexLine.getViews().get(j);
                if (child.getVisibility() == 8) continue;
                ViewGroup.LayoutParams layoutParams = child.getLayoutParams();
                Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
                ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)layoutParams;
                int childCrossPosition = this.calculateChildCrossPosition(flexLine.getCrossSize(), child.getMeasuredHeight(), lp.topMargin, lp.bottomMargin, currentCrossPosition);
                int childMainPosition = isRTL ? width - mainAxisStartPosition - child.getMeasuredWidth() - lp.rightMargin : mainAxisStartPosition + lp.leftMargin;
                flexLine.getViewMainPositions().add(childMainPosition);
                flexLine.getViewCrossPositions().add(childCrossPosition + lp.topMargin);
                child.layout(childMainPosition, childCrossPosition + lp.topMargin, childMainPosition + child.getMeasuredWidth(), childCrossPosition + lp.topMargin + child.getMeasuredHeight());
                int nextItemSpacing = j < flexLine.getViews().size() - 1 ? this.itemSpacing : 0;
                int dividerWidth = j < flexLine.getViews().size() - 1 && (this.showDividerVertical & 2) != 0 ? this.dividerVerticalWidth : 0;
                mainAxisStartPosition += ((Number)flexLine.getViewMainSizes().get(j)).intValue() + nextItemSpacing + dividerWidth;
            }
            currentCrossPosition += flexLine.getCrossSize();
            if (i >= this.flexLines.size() - 1) continue;
            if ((this.showDividerHorizontal & 2) != 0) {
                currentCrossPosition += this.dividerHorizontalHeight;
                continue;
            }
            currentCrossPosition += this.lineSpacing;
        }
    }

    private final void layoutColumnDirection(boolean isRTL, int left, int top, int right, int bottom) {
        int currentCrossPosition;
        int width = right - left;
        int height = bottom - top;
        int n = currentCrossPosition = isRTL ? width - this.getPaddingRight() : this.getPaddingLeft();
        if ((this.showDividerVertical & 1) != 0) {
            currentCrossPosition = isRTL ? (currentCrossPosition -= this.dividerVerticalWidth) : (currentCrossPosition += this.dividerVerticalWidth);
        }
        int n2 = this.flexLines.size();
        for (int i = 0; i < n2; ++i) {
            FlexLine flexLine = this.flexLines.get(i);
            int remainingSpace = height - this.getPaddingTop() - this.getPaddingBottom() - flexLine.getMainSize();
            int mainAxisStartPosition = this.calculateMainAxisStartPosition(remainingSpace, this.getPaddingTop());
            flexLine.getViewMainPositions().clear();
            flexLine.getViewCrossPositions().clear();
            int n3 = flexLine.getViews().size();
            for (int j = 0; j < n3; ++j) {
                View child = flexLine.getViews().get(j);
                if (child.getVisibility() == 8) continue;
                ViewGroup.LayoutParams layoutParams = child.getLayoutParams();
                Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
                ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)layoutParams;
                int childCrossPosition = isRTL ? this.calculateChildCrossPosition(flexLine.getCrossSize(), child.getMeasuredWidth(), lp.rightMargin, lp.leftMargin, currentCrossPosition - flexLine.getCrossSize()) : this.calculateChildCrossPosition(flexLine.getCrossSize(), child.getMeasuredWidth(), lp.leftMargin, lp.rightMargin, currentCrossPosition);
                int childLeft = isRTL ? childCrossPosition - child.getMeasuredWidth() - lp.rightMargin : childCrossPosition + lp.leftMargin;
                int childTop = mainAxisStartPosition + lp.topMargin;
                flexLine.getViewMainPositions().add(mainAxisStartPosition);
                flexLine.getViewCrossPositions().add(childCrossPosition);
                child.layout(childLeft, childTop, childLeft + child.getMeasuredWidth(), childTop + child.getMeasuredHeight());
                int nextItemSpacing = j < flexLine.getViews().size() - 1 ? this.itemSpacing : 0;
                int dividerHeight = j < flexLine.getViews().size() - 1 && (this.showDividerHorizontal & 2) != 0 ? this.dividerHorizontalHeight : 0;
                mainAxisStartPosition += ((Number)flexLine.getViewMainSizes().get(j)).intValue() + nextItemSpacing + dividerHeight;
            }
            if (isRTL) {
                currentCrossPosition -= flexLine.getCrossSize();
                if (i >= this.flexLines.size() - 1) continue;
                if ((this.showDividerVertical & 2) != 0) {
                    currentCrossPosition -= this.dividerVerticalWidth;
                    continue;
                }
                currentCrossPosition -= this.lineSpacing;
                continue;
            }
            currentCrossPosition += flexLine.getCrossSize();
            if (i >= this.flexLines.size() - 1) continue;
            if ((this.showDividerVertical & 2) != 0) {
                currentCrossPosition += this.dividerVerticalWidth;
                continue;
            }
            currentCrossPosition += this.lineSpacing;
        }
    }

    private final int calculateMainAxisStartPosition(int remainingSpace, int paddingStart) {
        int n;
        switch (this.justifyContent) {
            case 0: {
                n = paddingStart;
                break;
            }
            case 1: {
                n = paddingStart + remainingSpace / 2;
                break;
            }
            case 2: {
                n = paddingStart + remainingSpace;
                break;
            }
            case 3: {
                if (this.flexLines.isEmpty() || ((FlexLine)CollectionsKt.last(this.flexLines)).getViews().size() <= 1) {
                    n = paddingStart;
                    break;
                }
                n = paddingStart;
                break;
            }
            case 4: 
            case 5: {
                if (this.flexLines.isEmpty() || ((FlexLine)CollectionsKt.last(this.flexLines)).getViews().size() <= 1) {
                    n = paddingStart + remainingSpace / 2;
                    break;
                }
                n = paddingStart + remainingSpace / (((FlexLine)CollectionsKt.last(this.flexLines)).getViews().size() * 2);
                break;
            }
            default: {
                n = paddingStart;
            }
        }
        return n;
    }

    private final int calculateChildCrossPosition(int lineCrossSize, int childCrossSize, int startMargin, int endMargin, int lineStartPosition) {
        int n;
        switch (this.alignItems) {
            case 0: {
                n = lineStartPosition;
                break;
            }
            case 1: {
                n = lineStartPosition + (lineCrossSize - childCrossSize - startMargin - endMargin) / 2;
                break;
            }
            case 2: {
                n = lineStartPosition + lineCrossSize - childCrossSize - endMargin;
                break;
            }
            case 3: {
                n = lineStartPosition;
                break;
            }
            default: {
                n = lineStartPosition;
            }
        }
        return n;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        Drawable drawable = this.dividerDrawable;
        if (drawable == null) {
            return;
        }
        Drawable divider = drawable;
        if (this.getChildCount() == 0) {
            return;
        }
        if (this.flexDirection == 0) {
            this.drawDividersHorizontal(canvas);
            this.drawDividersVertical(canvas);
        } else {
            this.drawDividersVertical(canvas);
            this.drawDividersHorizontal(canvas);
        }
    }

    private final void drawDividersHorizontal(Canvas canvas) {
        Drawable drawable = this.dividerDrawable;
        if (drawable == null) {
            return;
        }
        Drawable divider = drawable;
        int childCount = this.getChildCount();
        int width = this.getWidth();
        int currentTop = this.getPaddingTop();
        if ((this.showDividerHorizontal & 1) != 0) {
            divider.setBounds(this.getPaddingLeft(), 0, width - this.getPaddingRight(), this.dividerHorizontalHeight);
            divider.draw(canvas);
            currentTop += this.dividerHorizontalHeight;
        }
        int n = this.flexLines.size();
        for (int i = 0; i < n; ++i) {
            FlexLine flexLine = this.flexLines.get(i);
            currentTop += flexLine.getCrossSize();
            if (i < this.flexLines.size() - 1 && (this.showDividerHorizontal & 2) != 0) {
                divider.setBounds(this.getPaddingLeft(), currentTop, width - this.getPaddingRight(), currentTop + this.dividerHorizontalHeight);
                divider.draw(canvas);
                currentTop += this.dividerHorizontalHeight;
                continue;
            }
            currentTop += this.lineSpacing;
        }
        if ((this.showDividerHorizontal & 4) != 0) {
            divider.setBounds(this.getPaddingLeft(), this.getHeight() - this.getPaddingBottom() - this.dividerHorizontalHeight, width - this.getPaddingRight(), this.getHeight() - this.getPaddingBottom());
            divider.draw(canvas);
        }
    }

    private final void drawDividersVertical(Canvas canvas) {
        Drawable drawable = this.dividerDrawable;
        if (drawable == null) {
            return;
        }
        Drawable divider = drawable;
        boolean isRTL = this.getLayoutDirection() == 1;
        int n = this.flexLines.size();
        for (int i = 0; i < n; ++i) {
            ViewGroup.MarginLayoutParams lp;
            View child;
            int j;
            int n2;
            FlexLine flexLine = this.flexLines.get(i);
            if (flexLine.getViews().isEmpty()) continue;
            if ((this.showDividerVertical & 1) != 0) {
                n2 = flexLine.getViews().size();
                for (j = 0; j < n2; ++j) {
                    child = flexLine.getViews().get(j);
                    if (child.getVisibility() == 8) continue;
                    ViewGroup.LayoutParams layoutParams = child.getLayoutParams();
                    Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
                    lp = (ViewGroup.MarginLayoutParams)layoutParams;
                    if (j != 0) continue;
                    int left = isRTL ? child.getRight() + lp.rightMargin : child.getLeft() - lp.leftMargin - this.dividerVerticalWidth;
                    divider.setBounds(left, ((Number)flexLine.getViewCrossPositions().get(j)).intValue(), left + this.dividerVerticalWidth, ((Number)flexLine.getViewCrossPositions().get(j)).intValue() + child.getHeight());
                    divider.draw(canvas);
                }
            }
            if ((this.showDividerVertical & 2) != 0) {
                n2 = flexLine.getViews().size() - 1;
                for (j = 0; j < n2; ++j) {
                    child = flexLine.getViews().get(j);
                    View nextChild = flexLine.getViews().get(j + 1);
                    if (child.getVisibility() == 8 || nextChild.getVisibility() == 8) continue;
                    ViewGroup.LayoutParams layoutParams = child.getLayoutParams();
                    Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
                    ViewGroup.MarginLayoutParams lp2 = (ViewGroup.MarginLayoutParams)layoutParams;
                    ViewGroup.LayoutParams layoutParams2 = nextChild.getLayoutParams();
                    Intrinsics.checkNotNull((Object)layoutParams2, (String)"null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
                    ViewGroup.MarginLayoutParams nextLp = (ViewGroup.MarginLayoutParams)layoutParams2;
                    int left = isRTL ? child.getLeft() - lp2.leftMargin - this.dividerVerticalWidth / 2 : child.getRight() + lp2.rightMargin + (this.itemSpacing - this.dividerVerticalWidth) / 2;
                    divider.setBounds(left, ((Number)flexLine.getViewCrossPositions().get(j)).intValue(), left + this.dividerVerticalWidth, ((Number)flexLine.getViewCrossPositions().get(j)).intValue() + child.getHeight());
                    divider.draw(canvas);
                }
            }
            if ((this.showDividerVertical & 4) == 0) continue;
            n2 = flexLine.getViews().size();
            for (j = 0; j < n2; ++j) {
                child = flexLine.getViews().get(j);
                if (child.getVisibility() == 8) continue;
                ViewGroup.LayoutParams layoutParams = child.getLayoutParams();
                Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
                lp = (ViewGroup.MarginLayoutParams)layoutParams;
                if (j != flexLine.getViews().size() - 1) continue;
                int left = isRTL ? child.getLeft() - lp.leftMargin - this.dividerVerticalWidth : child.getRight() + lp.rightMargin;
                divider.setBounds(left, ((Number)flexLine.getViewCrossPositions().get(j)).intValue(), left + this.dividerVerticalWidth, ((Number)flexLine.getViewCrossPositions().get(j)).intValue() + child.getHeight());
                divider.draw(canvas);
            }
        }
    }

    @NotNull
    public ViewGroup.LayoutParams generateLayoutParams(@NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        return (ViewGroup.LayoutParams)new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    @NotNull
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return (ViewGroup.LayoutParams)new ViewGroup.MarginLayoutParams(-2, -2);
    }

    @NotNull
    protected ViewGroup.LayoutParams generateLayoutParams(@NotNull ViewGroup.LayoutParams p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return (ViewGroup.LayoutParams)new ViewGroup.MarginLayoutParams(p);
    }

    protected boolean checkLayoutParams(@NotNull ViewGroup.LayoutParams p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return p instanceof ViewGroup.MarginLayoutParams;
    }

    @JvmOverloads
    public FlexLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public FlexLayout(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/taptap/sdk/update/ui/FlexLayout$Companion;", "", "()V", "ALIGN_CENTER", "", "ALIGN_END", "ALIGN_ITEMS_CENTER", "ALIGN_ITEMS_END", "ALIGN_ITEMS_START", "ALIGN_ITEMS_STRETCH", "ALIGN_SPACE_AROUND", "ALIGN_SPACE_BETWEEN", "ALIGN_SPACE_EVENLY", "ALIGN_START", "DIRECTION_COLUMN", "DIRECTION_ROW", "SHOW_DIVIDER_BEGINNING", "SHOW_DIVIDER_END", "SHOW_DIVIDER_MIDDLE", "SHOW_DIVIDER_NONE", "tap-update_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/taptap/sdk/update/ui/FlexLayout$FlexLine;", "", "()V", "crossSize", "", "getCrossSize", "()I", "setCrossSize", "(I)V", "mainSize", "getMainSize", "setMainSize", "viewCrossPositions", "", "getViewCrossPositions", "()Ljava/util/List;", "viewCrossSizes", "getViewCrossSizes", "viewMainPositions", "getViewMainPositions", "viewMainSizes", "getViewMainSizes", "views", "Landroid/view/View;", "getViews", "tap-update_release"})
    private static final class FlexLine {
        private int mainSize;
        private int crossSize;
        @NotNull
        private final List<View> views = new ArrayList();
        @NotNull
        private final List<Integer> viewMainSizes = new ArrayList();
        @NotNull
        private final List<Integer> viewCrossSizes = new ArrayList();
        @NotNull
        private final List<Integer> viewMainPositions = new ArrayList();
        @NotNull
        private final List<Integer> viewCrossPositions = new ArrayList();

        public final int getMainSize() {
            return this.mainSize;
        }

        public final void setMainSize(int n) {
            this.mainSize = n;
        }

        public final int getCrossSize() {
            return this.crossSize;
        }

        public final void setCrossSize(int n) {
            this.crossSize = n;
        }

        @NotNull
        public final List<View> getViews() {
            return this.views;
        }

        @NotNull
        public final List<Integer> getViewMainSizes() {
            return this.viewMainSizes;
        }

        @NotNull
        public final List<Integer> getViewCrossSizes() {
            return this.viewCrossSizes;
        }

        @NotNull
        public final List<Integer> getViewMainPositions() {
            return this.viewMainPositions;
        }

        @NotNull
        public final List<Integer> getViewCrossPositions() {
            return this.viewCrossPositions;
        }
    }
}

