/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download;

import com.taptap.sdk.update.download.DownloadListener;
import com.taptap.sdk.update.download.DownloadTask;
import com.taptap.sdk.update.download.core.Util;
import com.taptap.sdk.update.download.core.cause.EndCause;
import com.taptap.sdk.update.download.core.listener.DownloadListener2;
import com.taptap.sdk.update.download.core.listener.DownloadListenerBunch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DownloadSerialQueue
extends DownloadListener2
implements Runnable {
    private static final Executor SERIAL_EXECUTOR = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkDownload DynamicSerial", false));
    volatile boolean shutedDown = false;
    volatile boolean looping = false;
    volatile boolean paused = false;
    volatile DownloadTask runningTask;
    private final ArrayList<DownloadTask> taskList;
    static final int ID_INVALID = 0;
    private static final String TAG = "DownloadSerialQueue";
    DownloadListenerBunch listenerBunch;

    public DownloadSerialQueue() {
        this(null);
    }

    DownloadSerialQueue(DownloadListener listener, ArrayList<DownloadTask> taskList) {
        this.listenerBunch = new DownloadListenerBunch.Builder().append(this).append(listener).build();
        this.taskList = taskList;
    }

    public DownloadSerialQueue(DownloadListener listener) {
        this(listener, new ArrayList<DownloadTask>());
    }

    public void setListener(DownloadListener listener) {
        this.listenerBunch = new DownloadListenerBunch.Builder().append(this).append(listener).build();
    }

    public synchronized void enqueue(DownloadTask task) {
        this.taskList.add(task);
        Collections.sort(this.taskList);
        if (!this.paused && !this.looping) {
            this.looping = true;
            this.startNewLooper();
        }
    }

    public synchronized void pause() {
        if (this.paused) {
            Util.w(TAG, "require pause this queue(remain " + this.taskList.size() + "), butit has already been paused");
            return;
        }
        this.paused = true;
        if (this.runningTask != null) {
            this.runningTask.cancel();
            this.taskList.add(0, this.runningTask);
            this.runningTask = null;
        }
    }

    public synchronized void resume() {
        if (!this.paused) {
            Util.w(TAG, "require resume this queue(remain " + this.taskList.size() + "), but it is still running");
            return;
        }
        this.paused = false;
        if (!this.taskList.isEmpty() && !this.looping) {
            this.looping = true;
            this.startNewLooper();
        }
    }

    public int getWorkingTaskId() {
        return this.runningTask != null ? this.runningTask.getId() : 0;
    }

    public int getWaitingTaskCount() {
        return this.taskList.size();
    }

    public synchronized DownloadTask[] shutdown() {
        this.shutedDown = true;
        if (this.runningTask != null) {
            this.runningTask.cancel();
        }
        DownloadTask[] tasks = new DownloadTask[this.taskList.size()];
        this.taskList.toArray(tasks);
        this.taskList.clear();
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.shutedDown) {
            DownloadTask nextTask;
            DownloadSerialQueue downloadSerialQueue = this;
            synchronized (downloadSerialQueue) {
                if (this.taskList.isEmpty() || this.paused) {
                    this.runningTask = null;
                    this.looping = false;
                    break;
                }
                nextTask = this.taskList.remove(0);
            }
            nextTask.execute(this.listenerBunch);
        }
    }

    void startNewLooper() {
        SERIAL_EXECUTOR.execute(this);
    }

    @Override
    public void taskStart(DownloadTask task) {
        this.runningTask = task;
    }

    @Override
    public synchronized void taskEnd(DownloadTask task, EndCause cause, Exception realCause) {
        if (cause != EndCause.CANCELED && task == this.runningTask) {
            this.runningTask = null;
        }
    }
}

