/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download;

import android.os.SystemClock;
import com.taptap.sdk.update.download.core.Util;

public class SpeedCalculator {
    long timestamp;
    long increaseBytes;
    long bytesPerSecond;
    long beginTimestamp;
    long endTimestamp;
    long allIncreaseBytes;

    public synchronized void reset() {
        this.timestamp = 0L;
        this.increaseBytes = 0L;
        this.bytesPerSecond = 0L;
        this.beginTimestamp = 0L;
        this.endTimestamp = 0L;
        this.allIncreaseBytes = 0L;
    }

    long nowMillis() {
        return SystemClock.uptimeMillis();
    }

    public synchronized void downloading(long increaseBytes) {
        if (this.timestamp == 0L) {
            this.beginTimestamp = this.timestamp = this.nowMillis();
        }
        this.increaseBytes += increaseBytes;
        this.allIncreaseBytes += increaseBytes;
    }

    public synchronized void flush() {
        long nowMillis = this.nowMillis();
        long sinceNowIncreaseBytes = this.increaseBytes;
        long durationMillis = Math.max(1L, nowMillis - this.timestamp);
        this.increaseBytes = 0L;
        this.timestamp = nowMillis;
        this.bytesPerSecond = (long)((float)sinceNowIncreaseBytes / (float)durationMillis * 1000.0f);
    }

    public long getInstantBytesPerSecondAndFlush() {
        this.flush();
        return this.bytesPerSecond;
    }

    public synchronized long getBytesPerSecondAndFlush() {
        long interval = this.nowMillis() - this.timestamp;
        if (interval < 1000L && this.bytesPerSecond != 0L) {
            return this.bytesPerSecond;
        }
        if (this.bytesPerSecond == 0L && interval < 500L) {
            return 0L;
        }
        return this.getInstantBytesPerSecondAndFlush();
    }

    public synchronized long getBytesPerSecondFromBegin() {
        long endTimestamp = this.endTimestamp == 0L ? this.nowMillis() : this.endTimestamp;
        long sinceNowIncreaseBytes = this.allIncreaseBytes;
        long durationMillis = Math.max(1L, endTimestamp - this.beginTimestamp);
        return (long)((float)sinceNowIncreaseBytes / (float)durationMillis * 1000.0f);
    }

    public synchronized void endTask() {
        this.endTimestamp = this.nowMillis();
    }

    public String instantSpeed() {
        return this.getSpeedWithSIAndFlush();
    }

    public String speed() {
        return SpeedCalculator.humanReadableSpeed(this.getBytesPerSecondAndFlush(), true);
    }

    public String lastSpeed() {
        return SpeedCalculator.humanReadableSpeed(this.bytesPerSecond, true);
    }

    public synchronized long getInstantSpeedDurationMillis() {
        return this.nowMillis() - this.timestamp;
    }

    public String getSpeedWithBinaryAndFlush() {
        return SpeedCalculator.humanReadableSpeed(this.getInstantBytesPerSecondAndFlush(), false);
    }

    public String getSpeedWithSIAndFlush() {
        return SpeedCalculator.humanReadableSpeed(this.getInstantBytesPerSecondAndFlush(), true);
    }

    public String averageSpeed() {
        return this.speedFromBegin();
    }

    public String speedFromBegin() {
        return SpeedCalculator.humanReadableSpeed(this.getBytesPerSecondFromBegin(), true);
    }

    private static String humanReadableSpeed(long bytes, boolean si) {
        return Util.humanReadableBytes(bytes, si) + "/s";
    }
}

