/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download;

import android.util.SparseArray;
import com.taptap.sdk.update.download.DownloadListener;
import com.taptap.sdk.update.download.DownloadTask;
import com.taptap.sdk.update.download.StatusUtil;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointInfo;
import com.taptap.sdk.update.download.core.cause.EndCause;
import com.taptap.sdk.update.download.core.cause.ResumeFailedCause;
import com.taptap.sdk.update.download.core.listener.assist.ListenerAssist;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UnifiedListenerManager {
    final SparseArray<ArrayList<DownloadListener>> realListenerMap;
    final List<Integer> autoRemoveListenerIdList = new ArrayList<Integer>();
    final DownloadListener hostListener = new DownloadListener(){

        @Override
        public void taskStart(DownloadTask task) {
            DownloadListener[] listeners = UnifiedListenerManager.getThreadSafeArray(task, (SparseArray<ArrayList<DownloadListener>>)UnifiedListenerManager.this.realListenerMap);
            if (listeners == null) {
                return;
            }
            for (DownloadListener realOne : listeners) {
                if (realOne == null) continue;
                realOne.taskStart(task);
            }
        }

        @Override
        public void connectTrialStart(DownloadTask task, Map<String, List<String>> requestHeaderFields) {
            DownloadListener[] listeners = UnifiedListenerManager.getThreadSafeArray(task, (SparseArray<ArrayList<DownloadListener>>)UnifiedListenerManager.this.realListenerMap);
            if (listeners == null) {
                return;
            }
            for (DownloadListener realOne : listeners) {
                if (realOne == null) continue;
                realOne.connectTrialStart(task, requestHeaderFields);
            }
        }

        @Override
        public void connectTrialEnd(DownloadTask task, int responseCode, Map<String, List<String>> responseHeaderFields) {
            DownloadListener[] listeners = UnifiedListenerManager.getThreadSafeArray(task, (SparseArray<ArrayList<DownloadListener>>)UnifiedListenerManager.this.realListenerMap);
            if (listeners == null) {
                return;
            }
            for (DownloadListener realOne : listeners) {
                if (realOne == null) continue;
                realOne.connectTrialEnd(task, responseCode, responseHeaderFields);
            }
        }

        @Override
        public void downloadFromBeginning(DownloadTask task, BreakpointInfo info, ResumeFailedCause cause) {
            DownloadListener[] listeners = UnifiedListenerManager.getThreadSafeArray(task, (SparseArray<ArrayList<DownloadListener>>)UnifiedListenerManager.this.realListenerMap);
            if (listeners == null) {
                return;
            }
            for (DownloadListener realOne : listeners) {
                if (realOne == null) continue;
                realOne.downloadFromBeginning(task, info, cause);
            }
        }

        @Override
        public void downloadFromBreakpoint(DownloadTask task, BreakpointInfo info) {
            DownloadListener[] listeners = UnifiedListenerManager.getThreadSafeArray(task, (SparseArray<ArrayList<DownloadListener>>)UnifiedListenerManager.this.realListenerMap);
            if (listeners == null) {
                return;
            }
            for (DownloadListener realOne : listeners) {
                if (realOne == null) continue;
                realOne.downloadFromBreakpoint(task, info);
            }
        }

        @Override
        public void connectStart(DownloadTask task, int blockIndex, Map<String, List<String>> requestHeaderFields) {
            DownloadListener[] listeners = UnifiedListenerManager.getThreadSafeArray(task, (SparseArray<ArrayList<DownloadListener>>)UnifiedListenerManager.this.realListenerMap);
            if (listeners == null) {
                return;
            }
            for (DownloadListener realOne : listeners) {
                if (realOne == null) continue;
                realOne.connectStart(task, blockIndex, requestHeaderFields);
            }
        }

        @Override
        public void connectEnd(DownloadTask task, int blockIndex, int responseCode, Map<String, List<String>> responseHeaderFields) {
            DownloadListener[] listeners = UnifiedListenerManager.getThreadSafeArray(task, (SparseArray<ArrayList<DownloadListener>>)UnifiedListenerManager.this.realListenerMap);
            if (listeners == null) {
                return;
            }
            for (DownloadListener realOne : listeners) {
                if (realOne == null) continue;
                realOne.connectEnd(task, blockIndex, responseCode, responseHeaderFields);
            }
        }

        @Override
        public void fetchStart(DownloadTask task, int blockIndex, long contentLength) {
            DownloadListener[] listeners = UnifiedListenerManager.getThreadSafeArray(task, (SparseArray<ArrayList<DownloadListener>>)UnifiedListenerManager.this.realListenerMap);
            if (listeners == null) {
                return;
            }
            for (DownloadListener realOne : listeners) {
                if (realOne == null) continue;
                realOne.fetchStart(task, blockIndex, contentLength);
            }
        }

        @Override
        public void fetchProgress(DownloadTask task, int blockIndex, long increaseBytes) {
            DownloadListener[] listeners = UnifiedListenerManager.getThreadSafeArray(task, (SparseArray<ArrayList<DownloadListener>>)UnifiedListenerManager.this.realListenerMap);
            if (listeners == null) {
                return;
            }
            for (DownloadListener realOne : listeners) {
                if (realOne == null) continue;
                realOne.fetchProgress(task, blockIndex, increaseBytes);
            }
        }

        @Override
        public void fetchEnd(DownloadTask task, int blockIndex, long contentLength) {
            DownloadListener[] listeners = UnifiedListenerManager.getThreadSafeArray(task, (SparseArray<ArrayList<DownloadListener>>)UnifiedListenerManager.this.realListenerMap);
            if (listeners == null) {
                return;
            }
            for (DownloadListener realOne : listeners) {
                if (realOne == null) continue;
                realOne.fetchEnd(task, blockIndex, contentLength);
            }
        }

        @Override
        public void taskEnd(DownloadTask task, EndCause cause, Exception realCause) {
            DownloadListener[] listeners = UnifiedListenerManager.getThreadSafeArray(task, (SparseArray<ArrayList<DownloadListener>>)UnifiedListenerManager.this.realListenerMap);
            if (listeners == null) {
                return;
            }
            for (DownloadListener realOne : listeners) {
                if (realOne == null) continue;
                realOne.taskEnd(task, cause, realCause);
            }
            if (UnifiedListenerManager.this.autoRemoveListenerIdList.contains(task.getId())) {
                UnifiedListenerManager.this.detachListener(task.getId());
            }
        }
    };

    public UnifiedListenerManager() {
        this.realListenerMap = new SparseArray();
    }

    public synchronized void detachListener(int id2) {
        this.realListenerMap.remove(id2);
    }

    public synchronized void addAutoRemoveListenersWhenTaskEnd(int id2) {
        if (this.autoRemoveListenerIdList.contains(id2)) {
            return;
        }
        this.autoRemoveListenerIdList.add(id2);
    }

    public synchronized void removeAutoRemoveListenersWhenTaskEnd(int id2) {
        this.autoRemoveListenerIdList.remove((Object)id2);
    }

    public synchronized void detachListener(DownloadListener listener) {
        int count = this.realListenerMap.size();
        ArrayList<Integer> needRemoveKeyList = new ArrayList<Integer>();
        for (int i = 0; i < count; ++i) {
            List listenerList = (List)this.realListenerMap.valueAt(i);
            if (listenerList == null) continue;
            listenerList.remove(listener);
            if (!listenerList.isEmpty()) continue;
            needRemoveKeyList.add(this.realListenerMap.keyAt(i));
        }
        Iterator iterator = needRemoveKeyList.iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            this.realListenerMap.remove(key);
        }
    }

    public synchronized boolean detachListener(DownloadTask task, DownloadListener listener) {
        int id2 = task.getId();
        List listenerList = (List)this.realListenerMap.get(id2);
        if (listenerList == null) {
            return false;
        }
        boolean result = listenerList.remove(listener);
        if (listenerList.isEmpty()) {
            this.realListenerMap.remove(id2);
        }
        return result;
    }

    public synchronized void attachListener(DownloadTask task, DownloadListener listener) {
        int id2 = task.getId();
        ArrayList<DownloadListener> listenerList = (ArrayList<DownloadListener>)this.realListenerMap.get(id2);
        if (listenerList == null) {
            listenerList = new ArrayList<DownloadListener>();
            this.realListenerMap.put(id2, listenerList);
        }
        if (!listenerList.contains(listener)) {
            listenerList.add(listener);
            if (listener instanceof ListenerAssist) {
                ((ListenerAssist)((Object)listener)).setAlwaysRecoverAssistModelIfNotSet(true);
            }
        }
    }

    public synchronized void attachAndEnqueueIfNotRun(DownloadTask task, DownloadListener listener) {
        this.attachListener(task, listener);
        if (!this.isTaskPendingOrRunning(task)) {
            task.enqueue(this.hostListener);
        }
    }

    public synchronized void replaceListener(DownloadTask task, DownloadListener listener) {
        int id2 = task.getId();
        ArrayList<DownloadListener> listenerList = (ArrayList<DownloadListener>)this.realListenerMap.get(id2);
        if (listenerList == null) {
            listenerList = new ArrayList<DownloadListener>();
            this.realListenerMap.put(id2, listenerList);
        }
        String className = listener.getClass().getName();
        DownloadListener oldListener = null;
        for (DownloadListener downloadListener : listenerList) {
            if (!downloadListener.getClass().getName().equals(className)) continue;
            oldListener = downloadListener;
        }
        if (oldListener != null) {
            listenerList.remove(oldListener);
        }
        if (!listenerList.contains(listener)) {
            listenerList.add(listener);
            if (listener instanceof ListenerAssist) {
                ((ListenerAssist)((Object)listener)).setAlwaysRecoverAssistModelIfNotSet(true);
            }
        }
    }

    public synchronized boolean isListenerAttached(DownloadTask task, DownloadListener listener) {
        int id2 = task.getId();
        ArrayList listenerList = (ArrayList)this.realListenerMap.get(id2);
        if (listenerList == null) {
            return false;
        }
        return listenerList.contains(listener);
    }

    public DownloadListener getDownloadListener(DownloadTask task, String className) {
        int id2 = task.getId();
        ArrayList listenerList = (ArrayList)this.realListenerMap.get(id2);
        if (listenerList == null) {
            return null;
        }
        DownloadListener dest = null;
        for (DownloadListener listener : listenerList) {
            if (!listener.getClass().getName().equals(className)) continue;
            dest = listener;
        }
        return dest;
    }

    public synchronized void enqueueTaskWithUnifiedListener(DownloadTask task, DownloadListener listener) {
        this.attachListener(task, listener);
        task.enqueue(this.hostListener);
    }

    public synchronized void executeTaskWithUnifiedListener(DownloadTask task, DownloadListener listener) {
        this.attachListener(task, listener);
        task.execute(this.hostListener);
    }

    public DownloadListener getHostListener() {
        return this.hostListener;
    }

    boolean isTaskPendingOrRunning(DownloadTask task) {
        return StatusUtil.isSameTaskPendingOrRunning(task);
    }

    private static DownloadListener[] getThreadSafeArray(DownloadTask task, SparseArray<ArrayList<DownloadListener>> realListenerMap) {
        ArrayList listenerList = (ArrayList)realListenerMap.get(task.getId());
        if (listenerList == null || listenerList.size() <= 0) {
            return null;
        }
        DownloadListener[] copyList = new DownloadListener[listenerList.size()];
        listenerList.toArray(copyList);
        return copyList;
    }
}

