/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download.core.breakpoint;

import android.content.Context;
import com.taptap.sdk.update.download.DownloadTask;
import com.taptap.sdk.update.download.core.Util;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointInfo;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointSQLiteHelper;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointStoreOnCache;
import com.taptap.sdk.update.download.core.breakpoint.DownloadStore;
import com.taptap.sdk.update.download.core.breakpoint.RemitStoreOnSQLite;
import com.taptap.sdk.update.download.core.cause.EndCause;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class BreakpointStoreOnSQLite
implements DownloadStore {
    private static final String TAG = "BreakpointStoreOnSQLite";
    protected final BreakpointSQLiteHelper helper;
    protected final BreakpointStoreOnCache onCache;

    BreakpointStoreOnSQLite(BreakpointSQLiteHelper helper, BreakpointStoreOnCache onCache) {
        this.helper = helper;
        this.onCache = onCache;
    }

    public BreakpointStoreOnSQLite(Context context) {
        this.helper = new BreakpointSQLiteHelper(context.getApplicationContext());
        this.onCache = new BreakpointStoreOnCache(this.helper.loadToCache(), this.helper.loadDirtyFileList(), this.helper.loadResponseFilenameToMap());
    }

    @Override
    public BreakpointInfo get(int id2) {
        return this.onCache.get(id2);
    }

    @Override
    public BreakpointInfo createAndInsert(DownloadTask task) throws IOException {
        BreakpointInfo info = this.onCache.createAndInsert(task);
        this.helper.insert(info);
        return info;
    }

    @Override
    public void onTaskStart(int id2) {
        this.onCache.onTaskStart(id2);
    }

    @Override
    public void onSyncToFilesystemSuccess(BreakpointInfo info, int blockIndex, long increaseLength) throws IOException {
        this.onCache.onSyncToFilesystemSuccess(info, blockIndex, increaseLength);
        long newCurrentOffset = info.getBlock(blockIndex).getCurrentOffset();
        this.helper.updateBlockIncrease(info, blockIndex, newCurrentOffset);
    }

    @Override
    public boolean update(BreakpointInfo breakpointInfo) throws IOException {
        boolean result = this.onCache.update(breakpointInfo);
        this.helper.updateInfo(breakpointInfo);
        String filename = breakpointInfo.getFilename();
        Util.d(TAG, "update " + breakpointInfo);
        if (breakpointInfo.isTaskOnlyProvidedParentPath() && filename != null) {
            this.helper.updateFilename(breakpointInfo.getUrl(), filename);
        }
        return result;
    }

    @Override
    public void onTaskEnd(int id2, @NotNull EndCause cause, Exception exception) {
        this.onCache.onTaskEnd(id2, cause, exception);
        if (cause == EndCause.COMPLETED) {
            this.helper.removeInfo(id2);
        }
    }

    @Override
    public BreakpointInfo getAfterCompleted(int id2) {
        return null;
    }

    @Override
    public boolean markFileDirty(int id2) {
        if (this.onCache.markFileDirty(id2)) {
            this.helper.markFileDirty(id2);
            return true;
        }
        return false;
    }

    @Override
    public boolean markFileClear(int id2) {
        if (this.onCache.markFileClear(id2)) {
            this.helper.markFileClear(id2);
            return true;
        }
        return false;
    }

    @Override
    public void remove(int id2) {
        this.onCache.remove(id2);
        this.helper.removeInfo(id2);
    }

    @Override
    public int findOrCreateId(DownloadTask task) {
        int id2 = this.onCache.findOrCreateId(task);
        try {
            BreakpointInfo breakpointInfo = this.onCache.get(id2);
            if (breakpointInfo != null && !breakpointInfo.getUrl().equals(task.getUrl())) {
                breakpointInfo.setUrl(task.getUrl());
                this.update(breakpointInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id2;
    }

    @Override
    public BreakpointInfo findAnotherInfoFromCompare(DownloadTask task, BreakpointInfo ignored) {
        return this.onCache.findAnotherInfoFromCompare(task, ignored);
    }

    @Override
    public boolean isOnlyMemoryCache() {
        return false;
    }

    @Override
    public boolean isFileDirty(int id2) {
        return this.onCache.isFileDirty(id2);
    }

    @Override
    public String getResponseFilename(String url) {
        return this.onCache.getResponseFilename(url);
    }

    void close() {
        this.helper.close();
    }

    public DownloadStore createRemitSelf() {
        return new RemitStoreOnSQLite(this);
    }
}

