/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download.core.dispatcher;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import com.taptap.sdk.update.download.DownloadListener;
import com.taptap.sdk.update.download.DownloadMonitor;
import com.taptap.sdk.update.download.DownloadTask;
import com.taptap.sdk.update.download.OkDownload;
import com.taptap.sdk.update.download.core.Util;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointInfo;
import com.taptap.sdk.update.download.core.cause.EndCause;
import com.taptap.sdk.update.download.core.cause.ResumeFailedCause;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CallbackDispatcher {
    private static final String TAG = "CallbackDispatcher";
    private final DownloadListener transmit;
    private final Handler uiHandler;

    CallbackDispatcher(Handler handler, DownloadListener transmit) {
        this.uiHandler = handler;
        this.transmit = transmit;
    }

    public CallbackDispatcher() {
        this.uiHandler = new Handler(Looper.getMainLooper());
        this.transmit = new DefaultTransmitListener(this.uiHandler);
    }

    public boolean isFetchProcessMoment(DownloadTask task) {
        long minInterval = task.getMinIntervalMillisCallbackProcess();
        long now = SystemClock.uptimeMillis();
        return minInterval <= 0L || now - DownloadTask.TaskHideWrapper.getLastCallbackProcessTs(task) >= minInterval;
    }

    public void endTasksWithError(final Collection<DownloadTask> errorCollection, final Exception realCause) {
        if (errorCollection.size() <= 0) {
            return;
        }
        Util.d(TAG, "endTasksWithError error[" + errorCollection.size() + "] realCause: " + realCause);
        Iterator<DownloadTask> iterator = errorCollection.iterator();
        while (iterator.hasNext()) {
            DownloadTask task = iterator.next();
            if (task.isAutoCallbackToUIThread()) continue;
            task.getListener().taskEnd(task, EndCause.ERROR, realCause);
            iterator.remove();
        }
        this.uiHandler.post(new Runnable(){

            @Override
            public void run() {
                for (DownloadTask task : errorCollection) {
                    task.getListener().taskEnd(task, EndCause.ERROR, realCause);
                }
            }
        });
    }

    public void endTasks(final Collection<DownloadTask> completedTaskCollection, final Collection<DownloadTask> sameTaskConflictCollection, final Collection<DownloadTask> fileBusyCollection) {
        DownloadTask task;
        Iterator<DownloadTask> iterator;
        if (completedTaskCollection.size() == 0 && sameTaskConflictCollection.size() == 0 && fileBusyCollection.size() == 0) {
            return;
        }
        Util.d(TAG, "endTasks completed[" + completedTaskCollection.size() + "] sameTask[" + sameTaskConflictCollection.size() + "] fileBusy[" + fileBusyCollection.size() + "]");
        if (completedTaskCollection.size() > 0) {
            iterator = completedTaskCollection.iterator();
            while (iterator.hasNext()) {
                task = iterator.next();
                if (task.isAutoCallbackToUIThread()) continue;
                task.getListener().taskEnd(task, EndCause.COMPLETED, null);
                iterator.remove();
            }
        }
        if (sameTaskConflictCollection.size() > 0) {
            iterator = sameTaskConflictCollection.iterator();
            while (iterator.hasNext()) {
                task = iterator.next();
                if (task.isAutoCallbackToUIThread()) continue;
                task.getListener().taskEnd(task, EndCause.SAME_TASK_BUSY, null);
                iterator.remove();
            }
        }
        if (fileBusyCollection.size() > 0) {
            iterator = fileBusyCollection.iterator();
            while (iterator.hasNext()) {
                task = iterator.next();
                if (task.isAutoCallbackToUIThread()) continue;
                task.getListener().taskEnd(task, EndCause.FILE_BUSY, null);
                iterator.remove();
            }
        }
        if (completedTaskCollection.size() == 0 && sameTaskConflictCollection.size() == 0 && fileBusyCollection.size() == 0) {
            return;
        }
        this.uiHandler.post(new Runnable(){

            @Override
            public void run() {
                for (DownloadTask task : completedTaskCollection) {
                    task.getListener().taskEnd(task, EndCause.COMPLETED, null);
                }
                for (DownloadTask task : sameTaskConflictCollection) {
                    task.getListener().taskEnd(task, EndCause.SAME_TASK_BUSY, null);
                }
                for (DownloadTask task : fileBusyCollection) {
                    task.getListener().taskEnd(task, EndCause.FILE_BUSY, null);
                }
            }
        });
    }

    public void endTasksWithCanceled(final Collection<DownloadTask> canceledCollection) {
        if (canceledCollection.size() <= 0) {
            return;
        }
        Util.d(TAG, "endTasksWithCanceled canceled[" + canceledCollection.size() + "]");
        Iterator<DownloadTask> iterator = canceledCollection.iterator();
        while (iterator.hasNext()) {
            DownloadTask task = iterator.next();
            if (task.isAutoCallbackToUIThread()) continue;
            task.getListener().taskEnd(task, EndCause.CANCELED, null);
            iterator.remove();
        }
        this.uiHandler.post(new Runnable(){

            @Override
            public void run() {
                for (DownloadTask task : canceledCollection) {
                    task.getListener().taskEnd(task, EndCause.CANCELED, null);
                }
            }
        });
    }

    public DownloadListener dispatch() {
        return this.transmit;
    }

    static class DefaultTransmitListener
    implements DownloadListener {
        private final Handler uiHandler;

        DefaultTransmitListener(Handler uiHandler) {
            this.uiHandler = uiHandler;
        }

        @Override
        public void taskStart(final DownloadTask task) {
            Util.d(CallbackDispatcher.TAG, "taskStart: " + task.getId());
            this.inspectTaskStart(task);
            if (task.isAutoCallbackToUIThread()) {
                this.uiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        task.getListener().taskStart(task);
                    }
                });
            } else {
                task.getListener().taskStart(task);
            }
        }

        @Override
        public void connectTrialStart(final DownloadTask task, final Map<String, List<String>> headerFields) {
            Util.d(CallbackDispatcher.TAG, "-----> start trial task(" + task.getId() + ") " + headerFields);
            if (task.isAutoCallbackToUIThread()) {
                this.uiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        task.getListener().connectTrialStart(task, headerFields);
                    }
                });
            } else {
                task.getListener().connectTrialStart(task, headerFields);
            }
        }

        @Override
        public void connectTrialEnd(final DownloadTask task, final int responseCode, final Map<String, List<String>> headerFields) {
            Util.d(CallbackDispatcher.TAG, "<----- finish trial task(" + task.getId() + ") code[" + responseCode + "]" + headerFields);
            if (task.isAutoCallbackToUIThread()) {
                this.uiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        task.getListener().connectTrialEnd(task, responseCode, headerFields);
                    }
                });
            } else {
                task.getListener().connectTrialEnd(task, responseCode, headerFields);
            }
        }

        @Override
        public void downloadFromBeginning(final DownloadTask task, final BreakpointInfo info, final ResumeFailedCause cause) {
            Util.d(CallbackDispatcher.TAG, "downloadFromBeginning: " + task.getId());
            this.inspectDownloadFromBeginning(task, info, cause);
            if (task.isAutoCallbackToUIThread()) {
                this.uiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        task.getListener().downloadFromBeginning(task, info, cause);
                    }
                });
            } else {
                task.getListener().downloadFromBeginning(task, info, cause);
            }
        }

        @Override
        public void downloadFromBreakpoint(final DownloadTask task, final BreakpointInfo info) {
            Util.d(CallbackDispatcher.TAG, "downloadFromBreakpoint: " + task.getId());
            this.inspectDownloadFromBreakpoint(task, info);
            if (task.isAutoCallbackToUIThread()) {
                this.uiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        task.getListener().downloadFromBreakpoint(task, info);
                    }
                });
            } else {
                task.getListener().downloadFromBreakpoint(task, info);
            }
        }

        @Override
        public void connectStart(final DownloadTask task, final int blockIndex, final Map<String, List<String>> requestHeaderFields) {
            Util.d(CallbackDispatcher.TAG, "-----> start connection task(" + task.getId() + ") block(" + blockIndex + ") " + requestHeaderFields);
            if (task.isAutoCallbackToUIThread()) {
                this.uiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        task.getListener().connectStart(task, blockIndex, requestHeaderFields);
                    }
                });
            } else {
                task.getListener().connectStart(task, blockIndex, requestHeaderFields);
            }
        }

        @Override
        public void connectEnd(final DownloadTask task, final int blockIndex, final int responseCode, final Map<String, List<String>> requestHeaderFields) {
            Util.d(CallbackDispatcher.TAG, "<----- finish connection task(" + task.getId() + ") block(" + blockIndex + ") code[" + responseCode + "]" + requestHeaderFields);
            if (task.isAutoCallbackToUIThread()) {
                this.uiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        task.getListener().connectEnd(task, blockIndex, responseCode, requestHeaderFields);
                    }
                });
            } else {
                task.getListener().connectEnd(task, blockIndex, responseCode, requestHeaderFields);
            }
        }

        @Override
        public void fetchStart(final DownloadTask task, final int blockIndex, final long contentLength) {
            Util.d(CallbackDispatcher.TAG, "fetchStart: " + task.getId());
            if (task.isAutoCallbackToUIThread()) {
                this.uiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        task.getListener().fetchStart(task, blockIndex, contentLength);
                    }
                });
            } else {
                task.getListener().fetchStart(task, blockIndex, contentLength);
            }
        }

        @Override
        public void fetchProgress(final DownloadTask task, final int blockIndex, final long increaseBytes) {
            if (task.getMinIntervalMillisCallbackProcess() > 0) {
                DownloadTask.TaskHideWrapper.setLastCallbackProcessTs(task, SystemClock.uptimeMillis());
            }
            if (task.isAutoCallbackToUIThread()) {
                this.uiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        task.getListener().fetchProgress(task, blockIndex, increaseBytes);
                    }
                });
            } else {
                task.getListener().fetchProgress(task, blockIndex, increaseBytes);
            }
        }

        @Override
        public void fetchEnd(final DownloadTask task, final int blockIndex, final long contentLength) {
            Util.d(CallbackDispatcher.TAG, "fetchEnd: " + task.getId());
            if (task.isAutoCallbackToUIThread()) {
                this.uiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        task.getListener().fetchEnd(task, blockIndex, contentLength);
                    }
                });
            } else {
                task.getListener().fetchEnd(task, blockIndex, contentLength);
            }
        }

        @Override
        public void taskEnd(final DownloadTask task, final EndCause cause, final Exception realCause) {
            if (cause == EndCause.ERROR) {
                Util.d(CallbackDispatcher.TAG, "taskEnd: " + task.getId() + " " + (Object)((Object)cause) + " " + realCause);
            }
            this.inspectTaskEnd(task, cause, realCause);
            if (task.isAutoCallbackToUIThread()) {
                this.uiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        task.getListener().taskEnd(task, cause, realCause);
                    }
                });
            } else {
                task.getListener().taskEnd(task, cause, realCause);
            }
        }

        void inspectDownloadFromBreakpoint(DownloadTask task, BreakpointInfo info) {
            DownloadMonitor monitor = OkDownload.with().getMonitor();
            if (monitor != null) {
                monitor.taskDownloadFromBreakpoint(task, info);
            }
        }

        void inspectDownloadFromBeginning(DownloadTask task, BreakpointInfo info, ResumeFailedCause cause) {
            DownloadMonitor monitor = OkDownload.with().getMonitor();
            if (monitor != null) {
                monitor.taskDownloadFromBeginning(task, info, cause);
            }
        }

        void inspectTaskStart(DownloadTask task) {
            DownloadMonitor monitor = OkDownload.with().getMonitor();
            if (monitor != null) {
                monitor.taskStart(task);
            }
        }

        void inspectTaskEnd(DownloadTask task, EndCause cause, Exception realCause) {
            DownloadMonitor monitor = OkDownload.with().getMonitor();
            if (monitor != null) {
                monitor.taskEnd(task, cause, realCause);
            }
        }
    }
}

