/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download.core.download;

import android.os.SystemClock;
import com.taptap.sdk.update.download.DownloadTask;
import com.taptap.sdk.update.download.OkDownload;
import com.taptap.sdk.update.download.core.NamedRunnable;
import com.taptap.sdk.update.download.core.Util;
import com.taptap.sdk.update.download.core.breakpoint.BlockInfo;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointInfo;
import com.taptap.sdk.update.download.core.breakpoint.DownloadStore;
import com.taptap.sdk.update.download.core.cause.EndCause;
import com.taptap.sdk.update.download.core.cause.ResumeFailedCause;
import com.taptap.sdk.update.download.core.download.BreakpointLocalCheck;
import com.taptap.sdk.update.download.core.download.BreakpointRemoteCheck;
import com.taptap.sdk.update.download.core.download.DownloadCache;
import com.taptap.sdk.update.download.core.download.DownloadChain;
import com.taptap.sdk.update.download.core.file.MultiPointOutputStream;
import com.taptap.sdk.update.download.core.file.ProcessFileStrategy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DownloadCall
extends NamedRunnable
implements Comparable<DownloadCall> {
    private static final ExecutorService EXECUTOR = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkDownload Block", false));
    private static final String TAG = "DownloadCall";
    static final int MAX_COUNT_RETRY_FOR_PRECONDITION_FAILED = 1;
    public final DownloadTask task;
    public final boolean asyncExecuted;
    final ArrayList<DownloadChain> blockChainList;
    volatile DownloadCache cache;
    volatile boolean canceled;
    volatile boolean finishing;
    volatile Thread currentThread;
    private final DownloadStore store;

    private DownloadCall(DownloadTask task, boolean asyncExecuted, DownloadStore store) {
        this(task, asyncExecuted, new ArrayList<DownloadChain>(), store);
    }

    DownloadCall(DownloadTask task, boolean asyncExecuted, ArrayList<DownloadChain> runningBlockList, DownloadStore store) {
        super("download call: " + task.getId());
        this.task = task;
        this.asyncExecuted = asyncExecuted;
        this.blockChainList = runningBlockList;
        this.store = store;
    }

    public static DownloadCall create(DownloadTask task, boolean asyncExecuted, DownloadStore store) {
        return new DownloadCall(task, asyncExecuted, store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        Object[] chains;
        DownloadCall downloadCall = this;
        synchronized (downloadCall) {
            if (this.canceled) {
                return false;
            }
            if (this.finishing) {
                return false;
            }
            this.canceled = true;
        }
        long startCancelTime = SystemClock.uptimeMillis();
        OkDownload.with().downloadDispatcher().flyingCanceled(this);
        DownloadCache cache = this.cache;
        if (cache != null) {
            cache.setUserCanceled();
        }
        if ((chains = this.blockChainList.toArray()) == null || chains.length == 0) {
            if (this.currentThread != null) {
                Util.d(TAG, "interrupt thread with cancel operation because of chains are not running " + this.task.getId());
                this.currentThread.interrupt();
            }
        } else {
            for (Object chain : chains) {
                if (!(chain instanceof DownloadChain)) continue;
                ((DownloadChain)chain).cancel();
            }
        }
        if (cache != null) {
            cache.getOutputStream().cancelAsync();
        }
        Util.d(TAG, "cancel task " + this.task.getId() + " consume: " + (SystemClock.uptimeMillis() - startCancelTime) + "ms");
        return true;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isFinishing() {
        return this.finishing;
    }

    @Override
    public void execute() throws InterruptedException {
        EndCause cause;
        boolean retry;
        this.currentThread = Thread.currentThread();
        int retryCount = 0;
        OkDownload okDownload = OkDownload.with();
        ProcessFileStrategy fileStrategy = okDownload.processFileStrategy();
        this.inspectTaskStart();
        do {
            DownloadCache cache;
            BreakpointInfo info;
            if (this.task.getUrl().length() <= 0) {
                this.cache = new DownloadCache.PreError(new IOException("unexpected url: " + this.task.getUrl()));
                break;
            }
            if (this.canceled) break;
            try {
                BreakpointInfo infoOnStore = this.store.get(this.task.getId());
                info = infoOnStore == null ? this.store.createAndInsert(this.task) : infoOnStore;
                this.setInfoToTask(info);
            }
            catch (IOException e) {
                this.cache = new DownloadCache.PreError(e);
                break;
            }
            if (this.canceled) break;
            this.cache = cache = this.createCache(info);
            BreakpointRemoteCheck remoteCheck = this.createRemoteCheck(info);
            try {
                remoteCheck.check();
            }
            catch (IOException e) {
                cache.catchException(e);
                break;
            }
            cache.setRedirectLocation(this.task.getRedirectLocation());
            fileStrategy.getFileLock().waitForRelease(this.task.getFile().getAbsolutePath());
            OkDownload.with().downloadStrategy().inspectAnotherSameInfo(this.task, info, remoteCheck.getInstanceLength());
            try {
                if (remoteCheck.isResumable()) {
                    BreakpointLocalCheck localCheck = this.createLocalCheck(info, remoteCheck.getInstanceLength());
                    localCheck.check();
                    if (localCheck.isDirty()) {
                        Util.d(TAG, "breakpoint invalid: download from beginning because of local check is dirty " + this.task.getId() + " " + localCheck);
                        fileStrategy.discardProcess(this.task);
                        this.assembleBlockAndCallbackFromBeginning(info, remoteCheck, localCheck.getCauseOrThrow());
                    } else {
                        okDownload.callbackDispatcher().dispatch().downloadFromBreakpoint(this.task, info);
                    }
                } else {
                    Util.d(TAG, "breakpoint invalid: download from beginning because of remote check not resumable " + this.task.getId() + " " + remoteCheck);
                    fileStrategy.discardProcess(this.task);
                    this.assembleBlockAndCallbackFromBeginning(info, remoteCheck, remoteCheck.getCauseOrThrow());
                }
            }
            catch (IOException e) {
                cache.setUnknownError(e);
                break;
            }
            this.start(cache, info);
            if (this.canceled) break;
            if (cache.isPreconditionFailed() && retryCount++ < 1) {
                this.store.remove(this.task.getId());
                retry = true;
                continue;
            }
            retry = false;
        } while (retry);
        this.finishing = true;
        this.blockChainList.clear();
        DownloadCache cache = this.cache;
        if (this.canceled || cache == null) {
            return;
        }
        IOException realCause = null;
        if (cache.isServerCanceled() || cache.isUnknownError() || cache.isPreconditionFailed()) {
            cause = EndCause.ERROR;
            realCause = cache.getRealCause();
        } else if (cache.isFileBusyAfterRun()) {
            cause = EndCause.FILE_BUSY;
        } else if (cache.isPreAllocateFailed()) {
            cause = EndCause.PRE_ALLOCATE_FAILED;
            realCause = cache.getRealCause();
        } else {
            cause = EndCause.COMPLETED;
        }
        this.inspectTaskEnd(cache, cause, realCause);
    }

    private void inspectTaskStart() {
        this.store.onTaskStart(this.task.getId());
        OkDownload.with().callbackDispatcher().dispatch().taskStart(this.task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inspectTaskEnd(DownloadCache cache, EndCause cause, Exception realCause) {
        if (cause == EndCause.CANCELED) {
            throw new IllegalAccessError("can't recognize cancelled on here");
        }
        DownloadCall downloadCall = this;
        synchronized (downloadCall) {
            if (this.canceled) {
                return;
            }
            this.finishing = true;
        }
        this.store.onTaskEnd(this.task.getId(), cause, realCause);
        if (cause == EndCause.COMPLETED) {
            this.store.markFileClear(this.task.getId());
            OkDownload.with().processFileStrategy().completeProcessStream(cache.getOutputStream(), this.task);
        }
        OkDownload.with().callbackDispatcher().dispatch().taskEnd(this.task, cause, realCause);
    }

    DownloadCache createCache(BreakpointInfo info) {
        MultiPointOutputStream outputStream = OkDownload.with().processFileStrategy().createProcessStream(this.task, info, this.store);
        return new DownloadCache(outputStream);
    }

    int getPriority() {
        return this.task.getPriority();
    }

    void start(DownloadCache cache, BreakpointInfo info) throws InterruptedException {
        int blockCount = info.getBlockCount();
        ArrayList<DownloadChain> blockChainList = new ArrayList<DownloadChain>(info.getBlockCount());
        ArrayList<Integer> blockIndexList = new ArrayList<Integer>();
        for (int i = 0; i < blockCount; ++i) {
            BlockInfo blockInfo = info.getBlock(i);
            if (Util.isCorrectFull(blockInfo.getCurrentOffset(), blockInfo.getContentLength())) continue;
            Util.resetBlockIfDirty(blockInfo);
            DownloadChain chain = DownloadChain.createChain(i, this.task, info, cache, this.store);
            blockChainList.add(chain);
            blockIndexList.add(chain.getBlockIndex());
        }
        if (this.canceled) {
            return;
        }
        cache.getOutputStream().setRequireStreamBlocks(blockIndexList);
        this.startBlocks(blockChainList);
    }

    @Override
    protected void interrupted(InterruptedException e) {
    }

    @Override
    protected void finished() {
        OkDownload.with().downloadDispatcher().finish(this);
        Util.d(TAG, "call is finished " + this.task.getId());
    }

    void startBlocks(List<DownloadChain> tasks) throws InterruptedException {
        ArrayList futures = new ArrayList(tasks.size());
        try {
            for (DownloadChain downloadChain : tasks) {
                futures.add(this.submitChain(downloadChain));
            }
            this.blockChainList.addAll(tasks);
            for (Future future : futures) {
                if (future.isDone()) continue;
                try {
                    future.get();
                }
                catch (CancellationException | ExecutionException exception) {}
            }
        }
        catch (Throwable t) {
            for (Future future : futures) {
                future.cancel(true);
            }
            throw t;
        }
        finally {
            this.blockChainList.removeAll(tasks);
        }
    }

    BreakpointLocalCheck createLocalCheck(BreakpointInfo info, long responseInstanceLength) {
        return new BreakpointLocalCheck(this.task, info, responseInstanceLength);
    }

    BreakpointRemoteCheck createRemoteCheck(BreakpointInfo info) {
        return new BreakpointRemoteCheck(this.task, info);
    }

    void setInfoToTask(BreakpointInfo info) {
        DownloadTask.TaskHideWrapper.setBreakpointInfo(this.task, info);
    }

    void assembleBlockAndCallbackFromBeginning(BreakpointInfo info, BreakpointRemoteCheck remoteCheck, ResumeFailedCause failedCause) {
        Util.assembleBlock(this.task, info, remoteCheck.getInstanceLength(), remoteCheck.isAcceptRange());
        OkDownload.with().callbackDispatcher().dispatch().downloadFromBeginning(this.task, info, failedCause);
    }

    Future<?> submitChain(DownloadChain chain) {
        return EXECUTOR.submit(chain);
    }

    public boolean equalsTask(DownloadTask task) {
        return this.task.equals(task);
    }

    public File getFile() {
        return this.task.getFile();
    }

    @Override
    public int compareTo(DownloadCall o) {
        return o.getPriority() - this.getPriority();
    }
}

