/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download.core.download;

import android.net.ConnectivityManager;
import com.taptap.sdk.update.download.DownloadTask;
import com.taptap.sdk.update.download.OkDownload;
import com.taptap.sdk.update.download.core.Util;
import com.taptap.sdk.update.download.core.breakpoint.BlockInfo;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointInfo;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointStore;
import com.taptap.sdk.update.download.core.breakpoint.DownloadStore;
import com.taptap.sdk.update.download.core.cause.ResumeFailedCause;
import com.taptap.sdk.update.download.core.connection.DownloadConnection;
import com.taptap.sdk.update.download.core.exception.NetworkPolicyException;
import com.taptap.sdk.update.download.core.exception.ResumeFailedException;
import com.taptap.sdk.update.download.core.exception.ServerCanceledException;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DownloadStrategy {
    private static final String TAG = "DownloadStrategy";
    private static final long ONE_CONNECTION_UPPER_LIMIT = 0x100000L;
    private static final long TWO_CONNECTION_UPPER_LIMIT = 0x500000L;
    private static final long THREE_CONNECTION_UPPER_LIMIT = 0x3200000L;
    private static final long FOUR_CONNECTION_UPPER_LIMIT = 0x6400000L;
    private static final Pattern TMP_FILE_NAME_PATTERN = Pattern.compile(".*\\\\|/([^\\\\|/|?]*)\\??");
    Boolean isHasAccessNetworkStatePermission = null;
    private ConnectivityManager manager = null;

    public ResumeAvailableResponseCheck resumeAvailableResponseCheck(DownloadConnection.Connected connected, int blockIndex, BreakpointInfo info) {
        return new ResumeAvailableResponseCheck(connected, blockIndex, info);
    }

    public int determineBlockCount(DownloadTask task, long totalLength) {
        if (task.getSetConnectionCount() != null) {
            return task.getSetConnectionCount();
        }
        if (totalLength < 0x100000L) {
            return 1;
        }
        if (totalLength < 0x500000L) {
            return 2;
        }
        if (totalLength < 0x3200000L) {
            return 3;
        }
        if (totalLength < 0x6400000L) {
            return 4;
        }
        return 5;
    }

    public long reuseIdledSameInfoThresholdBytes() {
        return 10240L;
    }

    public boolean inspectAnotherSameInfo(DownloadTask task, BreakpointInfo info, long instanceLength) {
        if (!task.isFilenameFromResponse()) {
            return false;
        }
        BreakpointStore store = OkDownload.with().breakpointStore();
        BreakpointInfo anotherInfo = store.findAnotherInfoFromCompare(task, info);
        if (anotherInfo == null) {
            return false;
        }
        store.remove(anotherInfo.getId());
        if (anotherInfo.getTotalOffset() <= OkDownload.with().downloadStrategy().reuseIdledSameInfoThresholdBytes()) {
            return false;
        }
        if (anotherInfo.getEtag() != null && !anotherInfo.getEtag().equals(info.getEtag())) {
            return false;
        }
        if (anotherInfo.getTotalLength() != instanceLength) {
            return false;
        }
        if (anotherInfo.getFile() == null || !anotherInfo.getFile().exists()) {
            return false;
        }
        info.reuseBlocks(anotherInfo);
        Util.d(TAG, "Reuse another same info: " + info);
        return true;
    }

    public boolean isUseMultiBlock(boolean isAcceptRange) {
        if (!OkDownload.with().outputStreamFactory().supportSeek()) {
            return false;
        }
        return isAcceptRange;
    }

    public void inspectFilenameFromResume(String filenameOnStore, DownloadTask task) {
        String filename = task.getFilename();
        if (Util.isEmpty(filename)) {
            task.getFilenameHolder().set(filenameOnStore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validFilenameFromResponse(String responseFileName, DownloadTask task, BreakpointInfo info) throws IOException {
        if (Util.isEmpty(task.getFilename())) {
            String filename = this.determineFilename(responseFileName, task);
            if (Util.isEmpty(task.getFilename())) {
                DownloadTask downloadTask = task;
                synchronized (downloadTask) {
                    if (Util.isEmpty(task.getFilename())) {
                        task.getFilenameHolder().set(filename);
                        info.getFilenameHolder().set(filename);
                    }
                }
            }
        }
    }

    protected String determineFilename(String responseFileName, DownloadTask task) throws IOException {
        if (Util.isEmpty(responseFileName)) {
            String url = task.getUrl();
            Matcher m = TMP_FILE_NAME_PATTERN.matcher(url);
            String filename = null;
            while (m.find()) {
                filename = m.group(1);
            }
            if (Util.isEmpty(filename)) {
                filename = Util.md5(url);
            }
            if (filename == null) {
                throw new IOException("Can't find valid filename.");
            }
            return filename;
        }
        return responseFileName;
    }

    public boolean validFilenameFromStore(DownloadTask task) {
        String filename = OkDownload.with().breakpointStore().getResponseFilename(task.getUrl());
        if (filename == null) {
            return false;
        }
        task.getFilenameHolder().set(filename);
        return true;
    }

    public void validInfoOnCompleted(DownloadTask task, DownloadStore store) {
        BreakpointInfo info = store.getAfterCompleted(task.getId());
        if (info == null) {
            long size;
            info = new BreakpointInfo(task.getId(), task.getUrl(), task.getParentFile(), task.getFilename());
            if (Util.isUriContentScheme(task.getUri())) {
                size = Util.getSizeFromContentUri(task.getUri());
            } else {
                File file = task.getFile();
                if (file == null) {
                    size = 0L;
                    Util.w(TAG, "file is not ready on valid info for task on complete state " + task);
                } else {
                    size = file.length();
                }
            }
            info.addBlock(new BlockInfo(0L, size, size));
        }
        DownloadTask.TaskHideWrapper.setBreakpointInfo(task, info);
    }

    public ResumeFailedCause getPreconditionFailedCause(int responseCode, boolean isAlreadyProceed, BreakpointInfo info, String responseEtag) {
        String localEtag = info.getEtag();
        if (responseCode == 412) {
            return ResumeFailedCause.RESPONSE_PRECONDITION_FAILED;
        }
        if (!(Util.isEmpty(localEtag) || Util.isEmpty(responseEtag) || responseEtag.equals(localEtag))) {
            return ResumeFailedCause.RESPONSE_ETAG_CHANGED;
        }
        if (responseCode == 201 && isAlreadyProceed) {
            return ResumeFailedCause.RESPONSE_CREATED_RANGE_NOT_FROM_0;
        }
        if (responseCode == 205 && isAlreadyProceed) {
            return ResumeFailedCause.RESPONSE_RESET_RANGE_NOT_FROM_0;
        }
        return null;
    }

    public boolean isServerCanceled(int responseCode, boolean isAlreadyProceed) {
        if (responseCode != 206 && responseCode != 200) {
            return true;
        }
        return responseCode == 200 && isAlreadyProceed;
    }

    public void inspectNetworkAvailable() throws UnknownHostException {
        if (this.isHasAccessNetworkStatePermission == null) {
            this.isHasAccessNetworkStatePermission = Util.checkPermission("android.permission.ACCESS_NETWORK_STATE");
        }
        if (!this.isHasAccessNetworkStatePermission.booleanValue()) {
            return;
        }
        if (this.manager == null) {
            this.manager = (ConnectivityManager)OkDownload.with().context().getSystemService("connectivity");
        }
        if (!Util.isNetworkAvailable(this.manager)) {
            throw new UnknownHostException("network is not available!");
        }
    }

    public void inspectNetworkOnWifi(DownloadTask task) throws IOException {
        if (this.isHasAccessNetworkStatePermission == null) {
            this.isHasAccessNetworkStatePermission = Util.checkPermission("android.permission.ACCESS_NETWORK_STATE");
        }
        if (!task.isWifiRequired()) {
            return;
        }
        if (!this.isHasAccessNetworkStatePermission.booleanValue()) {
            throw new IOException("required for access network state but don't have the permission of Manifest.permission.ACCESS_NETWORK_STATE, please declare this permission first on your AndroidManifest, so we can handle the case of downloading required wifi state.");
        }
        if (this.manager == null) {
            this.manager = (ConnectivityManager)OkDownload.with().context().getSystemService("connectivity");
        }
        if (Util.isNetworkNotOnWifiType(this.manager)) {
            throw new NetworkPolicyException();
        }
    }

    public static class ResumeAvailableResponseCheck {
        private DownloadConnection.Connected connected;
        private BreakpointInfo info;
        private int blockIndex;

        protected ResumeAvailableResponseCheck(DownloadConnection.Connected connected, int blockIndex, BreakpointInfo info) {
            this.connected = connected;
            this.info = info;
            this.blockIndex = blockIndex;
        }

        public void inspect() throws IOException {
            BlockInfo blockInfo = this.info.getBlock(this.blockIndex);
            int code = this.connected.getResponseCode();
            String newEtag = this.connected.getResponseHeaderField("Etag");
            ResumeFailedCause resumeFailedCause = OkDownload.with().downloadStrategy().getPreconditionFailedCause(code, blockInfo.getCurrentOffset() != 0L, this.info, newEtag);
            if (resumeFailedCause != null) {
                throw new ResumeFailedException(resumeFailedCause);
            }
            boolean isServerCancelled = OkDownload.with().downloadStrategy().isServerCanceled(code, blockInfo.getCurrentOffset() != 0L);
            if (isServerCancelled) {
                throw new ServerCanceledException(code, blockInfo.getCurrentOffset());
            }
        }
    }

    public static class FilenameHolder {
        private volatile String filename;
        private final boolean filenameProvidedByConstruct;

        public FilenameHolder() {
            this.filenameProvidedByConstruct = false;
        }

        public FilenameHolder(String filename) {
            this.filename = filename;
            this.filenameProvidedByConstruct = true;
        }

        void set(String filename) {
            this.filename = filename;
        }

        public String get() {
            return this.filename;
        }

        public boolean isFilenameProvidedByConstruct() {
            return this.filenameProvidedByConstruct;
        }

        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                return true;
            }
            if (obj instanceof FilenameHolder) {
                if (this.filename == null) {
                    return ((FilenameHolder)obj).filename == null;
                }
                return this.filename.equals(((FilenameHolder)obj).filename);
            }
            return false;
        }

        public int hashCode() {
            return this.filename == null ? 0 : this.filename.hashCode();
        }
    }
}

