/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download.core.file;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import com.taptap.sdk.update.download.core.Util;
import com.taptap.sdk.update.download.core.file.DownloadOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class DownloadUriOutputStream
implements DownloadOutputStream {
    private final FileChannel channel;
    final ParcelFileDescriptor pdf;
    final BufferedOutputStream out;
    final FileOutputStream fos;

    public DownloadUriOutputStream(Context context, Uri uri, int bufferSize) throws FileNotFoundException {
        ParcelFileDescriptor pdf = context.getContentResolver().openFileDescriptor(uri, "rw");
        if (pdf == null) {
            throw new FileNotFoundException("result of " + uri + " is null!");
        }
        this.pdf = pdf;
        this.fos = new FileOutputStream(pdf.getFileDescriptor());
        this.channel = this.fos.getChannel();
        this.out = new BufferedOutputStream(this.fos, bufferSize);
    }

    DownloadUriOutputStream(FileChannel channel, ParcelFileDescriptor pdf, FileOutputStream fos, BufferedOutputStream out) {
        this.channel = channel;
        this.pdf = pdf;
        this.fos = fos;
        this.out = out;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        this.fos.close();
        this.pdf.close();
    }

    @Override
    public void flushAndSync() throws IOException {
        this.out.flush();
        this.pdf.getFileDescriptor().sync();
    }

    @Override
    public void seek(long offset) throws IOException {
        this.channel.position(offset);
    }

    @Override
    public void setLength(long newLength) {
        block8: {
            String tag = "DownloadUriOutputStream";
            if (Build.VERSION.SDK_INT >= 21) {
                try {
                    Os.posix_fallocate((FileDescriptor)this.pdf.getFileDescriptor(), (long)0L, (long)newLength);
                }
                catch (Throwable e) {
                    if (e instanceof ErrnoException) {
                        if (((ErrnoException)e).errno == OsConstants.ENOSYS || ((ErrnoException)e).errno == OsConstants.ENOTSUP) {
                            Util.w("DownloadUriOutputStream", "fallocate() not supported; falling back to ftruncate()");
                            try {
                                Os.ftruncate((FileDescriptor)this.pdf.getFileDescriptor(), (long)newLength);
                            }
                            catch (Throwable e1) {
                                Util.w("DownloadUriOutputStream", "It can't pre-allocate length(" + newLength + ") on the sdk version(" + Build.VERSION.SDK_INT + "), because of " + e1);
                            }
                        }
                        break block8;
                    }
                    Util.w("DownloadUriOutputStream", "It can't pre-allocate length(" + newLength + ") on the sdk version(" + Build.VERSION.SDK_INT + "), because of " + e);
                }
            } else {
                Util.w("DownloadUriOutputStream", "It can't pre-allocate length(" + newLength + ") on the sdk version(" + Build.VERSION.SDK_INT + ")");
            }
        }
    }

    public static class Factory
    implements DownloadOutputStream.Factory {
        @Override
        public DownloadOutputStream create(Context context, File file, int flushBufferSize) throws FileNotFoundException {
            return new DownloadUriOutputStream(context, Uri.fromFile((File)file), flushBufferSize);
        }

        @Override
        public DownloadOutputStream create(Context context, Uri uri, int flushBufferSize) throws FileNotFoundException {
            return new DownloadUriOutputStream(context, uri, flushBufferSize);
        }

        @Override
        public boolean supportSeek() {
            return true;
        }
    }
}

