/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download.core.file;

import android.net.Uri;
import android.os.StatFs;
import android.os.SystemClock;
import android.util.SparseArray;
import com.taptap.sdk.update.download.DownloadTask;
import com.taptap.sdk.update.download.OkDownload;
import com.taptap.sdk.update.download.core.Util;
import com.taptap.sdk.update.download.core.breakpoint.BlockInfo;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointInfo;
import com.taptap.sdk.update.download.core.breakpoint.DownloadStore;
import com.taptap.sdk.update.download.core.cause.EndCause;
import com.taptap.sdk.update.download.core.exception.PreAllocateException;
import com.taptap.sdk.update.download.core.file.DownloadOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;

public class MultiPointOutputStream {
    private static final String TAG = "MultiPointOutputStream";
    private static final ExecutorService FILE_IO_EXECUTOR = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkDownload file io", false));
    final SparseArray<DownloadOutputStream> outputStreamMap = new SparseArray();
    final SparseArray<AtomicLong> noSyncLengthMap = new SparseArray();
    final AtomicLong allNoSyncLength = new AtomicLong();
    final AtomicLong lastSyncTimestamp = new AtomicLong();
    boolean canceled = false;
    private final int flushBufferSize;
    private final int syncBufferSize;
    private final int syncBufferIntervalMills;
    private final BreakpointInfo info;
    private final DownloadTask task;
    private final DownloadStore store;
    private final boolean supportSeek;
    private final boolean isPreAllocateLength;
    volatile Future syncFuture;
    volatile Thread runSyncThread;
    final SparseArray<Thread> parkedRunBlockThreadMap = new SparseArray();
    private final Runnable syncRunnable;
    private String path;
    IOException syncException;
    ArrayList<Integer> noMoreStreamList;
    List<Integer> requireStreamBlocks;
    final StreamsState doneState = new StreamsState();
    StreamsState state = new StreamsState();
    private volatile boolean firstOutputStream = true;

    MultiPointOutputStream(DownloadTask task, BreakpointInfo info, DownloadStore store, Runnable syncRunnable) {
        this.task = task;
        this.flushBufferSize = task.getFlushBufferSize();
        this.syncBufferSize = task.getSyncBufferSize();
        this.syncBufferIntervalMills = task.getSyncBufferIntervalMills();
        this.info = info;
        this.store = store;
        this.supportSeek = OkDownload.with().outputStreamFactory().supportSeek();
        this.isPreAllocateLength = OkDownload.with().processFileStrategy().isPreAllocateLength(task);
        this.noMoreStreamList = new ArrayList();
        this.syncRunnable = syncRunnable == null ? new Runnable(){

            @Override
            public void run() {
                MultiPointOutputStream.this.runSyncDelayException();
            }
        } : syncRunnable;
        File file = task.getFile();
        if (file != null) {
            this.path = file.getAbsolutePath();
        }
    }

    public MultiPointOutputStream(DownloadTask task, BreakpointInfo info, DownloadStore store) {
        this(task, info, store, null);
    }

    public synchronized void write(int blockIndex, byte[] bytes, int length) throws IOException {
        if (this.canceled) {
            return;
        }
        this.outputStream(blockIndex).write(bytes, 0, length);
        this.allNoSyncLength.addAndGet(length);
        ((AtomicLong)this.noSyncLengthMap.get(blockIndex)).addAndGet(length);
        this.inspectAndPersist();
    }

    public void cancelAsync() {
        FILE_IO_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                MultiPointOutputStream.this.cancel();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cancel() {
        block17: {
            if (this.requireStreamBlocks == null) {
                return;
            }
            if (this.canceled) {
                return;
            }
            this.canceled = true;
            this.noMoreStreamList.addAll(this.requireStreamBlocks);
            try {
                if (this.allNoSyncLength.get() <= 0L) {
                    return;
                }
                if (this.syncFuture == null || this.syncFuture.isDone()) break block17;
                this.inspectValidPath();
                OkDownload.with().processFileStrategy().getFileLock().increaseLock(this.path);
                try {
                    this.ensureSync(true, -1);
                }
                finally {
                    OkDownload.with().processFileStrategy().getFileLock().decreaseLock(this.path);
                }
            }
            finally {
                for (Integer blockIndex : this.requireStreamBlocks) {
                    try {
                        this.close(blockIndex);
                    }
                    catch (IOException e) {
                        Util.d(TAG, "OutputStream close failed task[" + this.task.getId() + "] block[" + blockIndex + "]" + e);
                    }
                }
                this.store.onTaskEnd(this.task.getId(), EndCause.CANCELED, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void done(int blockIndex) throws IOException {
        this.noMoreStreamList.add(blockIndex);
        try {
            if (this.syncException != null) {
                throw this.syncException;
            }
            if (this.syncFuture != null && !this.syncFuture.isDone()) {
                AtomicLong noSyncLength = (AtomicLong)this.noSyncLengthMap.get(blockIndex);
                if (noSyncLength != null && noSyncLength.get() > 0L) {
                    this.inspectStreamState(this.doneState);
                    boolean isNoMoreStream = this.doneState.isNoMoreStream;
                    this.ensureSync(isNoMoreStream, blockIndex);
                }
            } else if (this.syncFuture == null) {
                Util.d(TAG, "OutputStream done but no need to ensure sync, because the sync job not run yet. task[" + this.task.getId() + "] block[" + blockIndex + "]");
            } else {
                Util.d(TAG, "OutputStream done but no need to ensure sync, because the syncFuture.isDone[" + this.syncFuture.isDone() + "] task[" + this.task.getId() + "] block[" + blockIndex + "]");
            }
        }
        finally {
            this.close(blockIndex);
        }
    }

    void ensureSync(boolean isNoMoreStream, int blockIndex) {
        if (this.syncFuture == null || this.syncFuture.isDone()) {
            return;
        }
        if (!isNoMoreStream) {
            this.parkedRunBlockThreadMap.put(blockIndex, (Object)Thread.currentThread());
        }
        if (this.runSyncThread != null) {
            this.unparkThread(this.runSyncThread);
        } else {
            while (true) {
                if (this.isRunSyncThreadValid()) {
                    this.unparkThread(this.runSyncThread);
                    break;
                }
                this.parkThread(25L);
            }
        }
        if (isNoMoreStream) {
            this.unparkThread(this.runSyncThread);
            try {
                this.syncFuture.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {}
        } else {
            this.parkThread();
        }
    }

    boolean isRunSyncThreadValid() {
        return this.runSyncThread != null;
    }

    public void inspectComplete(int blockIndex) throws IOException {
        BlockInfo blockInfo = this.info.getBlock(blockIndex);
        if (!Util.isCorrectFull(blockInfo.getCurrentOffset(), blockInfo.getContentLength())) {
            throw new IOException("The current offset on block-info isn't update correct, " + blockInfo.getCurrentOffset() + " != " + blockInfo.getContentLength() + " on " + blockIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void inspectAndPersist() throws IOException {
        if (this.syncException != null) {
            throw this.syncException;
        }
        if (this.syncFuture == null) {
            Runnable runnable = this.syncRunnable;
            synchronized (runnable) {
                if (this.syncFuture == null) {
                    this.syncFuture = this.executeSyncRunnableAsync();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void close(int blockIndex) throws IOException {
        DownloadOutputStream outputStream = (DownloadOutputStream)this.outputStreamMap.get(blockIndex);
        if (outputStream != null) {
            outputStream.close();
            SparseArray<AtomicLong> sparseArray = this.noSyncLengthMap;
            synchronized (sparseArray) {
                this.outputStreamMap.remove(blockIndex);
                this.noSyncLengthMap.remove(blockIndex);
            }
            Util.d(TAG, "OutputStream close task[" + this.task.getId() + "] block[" + blockIndex + "]");
        }
    }

    void parkThread(long milliseconds) {
        LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(milliseconds));
    }

    void parkThread() {
        LockSupport.park();
    }

    void unparkThread(Thread thread) {
        LockSupport.unpark(thread);
    }

    Future executeSyncRunnableAsync() {
        return FILE_IO_EXECUTOR.submit(this.syncRunnable);
    }

    void inspectStreamState(StreamsState state) {
        state.newNoMoreStreamBlockList.clear();
        List clonedList = (List)this.noMoreStreamList.clone();
        HashSet uniqueBlockList = new HashSet(clonedList);
        int noMoreStreamBlockCount = uniqueBlockList.size();
        if (noMoreStreamBlockCount != this.requireStreamBlocks.size()) {
            Util.d(TAG, "task[" + this.task.getId() + "] current need fetching block count " + this.requireStreamBlocks.size() + " is not equal to no more stream block count " + noMoreStreamBlockCount);
            state.isNoMoreStream = false;
        } else {
            Util.d(TAG, "task[" + this.task.getId() + "] current need fetching block count " + this.requireStreamBlocks.size() + " is equal to no more stream block count " + noMoreStreamBlockCount);
            state.isNoMoreStream = true;
        }
        SparseArray streamMap = this.outputStreamMap.clone();
        int size = streamMap.size();
        for (int i = 0; i < size; ++i) {
            int blockIndex = streamMap.keyAt(i);
            if (!this.noMoreStreamList.contains(blockIndex) || state.noMoreStreamBlockList.contains(blockIndex)) continue;
            state.noMoreStreamBlockList.add(blockIndex);
            state.newNoMoreStreamBlockList.add(blockIndex);
        }
    }

    public void setRequireStreamBlocks(List<Integer> requireStreamBlocks) {
        this.requireStreamBlocks = requireStreamBlocks;
    }

    public void catchBlockConnectException(int blockIndex) {
        this.noMoreStreamList.add(blockIndex);
    }

    void runSyncDelayException() {
        try {
            this.runSync();
        }
        catch (IOException e) {
            this.syncException = e;
            Util.w(TAG, "Sync to breakpoint-store for task[" + this.task.getId() + "] failed with cause: " + e);
        }
    }

    void runSync() throws IOException {
        Util.d(TAG, "OutputStream start flush looper task[" + this.task.getId() + "] with syncBufferIntervalMills[" + this.syncBufferIntervalMills + "] syncBufferSize[" + this.syncBufferSize + "]");
        this.runSyncThread = Thread.currentThread();
        long nextParkMills = this.syncBufferIntervalMills;
        this.flushProcess();
        while (true) {
            this.parkThread(nextParkMills);
            this.inspectStreamState(this.state);
            if (this.state.isStreamsEndOrChanged()) {
                Thread parkedThread;
                Util.d(TAG, "runSync state change isNoMoreStream[" + this.state.isNoMoreStream + "] newNoMoreStreamBlockList[" + this.state.newNoMoreStreamBlockList + "]");
                if (this.allNoSyncLength.get() > 0L) {
                    this.flushProcess();
                }
                for (Integer blockIndex : this.state.newNoMoreStreamBlockList) {
                    parkedThread = (Thread)this.parkedRunBlockThreadMap.get(blockIndex.intValue());
                    this.parkedRunBlockThreadMap.remove(blockIndex.intValue());
                    if (parkedThread == null) continue;
                    this.unparkThread(parkedThread);
                }
                if (!this.state.isNoMoreStream) continue;
                int size = this.parkedRunBlockThreadMap.size();
                for (int i = 0; i < size; ++i) {
                    parkedThread = (Thread)this.parkedRunBlockThreadMap.valueAt(i);
                    if (parkedThread == null) continue;
                    this.unparkThread(parkedThread);
                }
                break;
            }
            if (this.isNoNeedFlushForLength()) {
                nextParkMills = this.syncBufferIntervalMills;
                continue;
            }
            nextParkMills = this.getNextParkMillisecond();
            if (nextParkMills > 0L) continue;
            this.flushProcess();
            nextParkMills = this.syncBufferIntervalMills;
        }
        this.parkedRunBlockThreadMap.clear();
        Util.d(TAG, "OutputStream stop flush looper task[" + this.task.getId() + "]");
    }

    boolean isNoNeedFlushForLength() {
        return this.allNoSyncLength.get() < (long)this.syncBufferSize;
    }

    long getNextParkMillisecond() {
        long farToLastSyncMills = this.now() - this.lastSyncTimestamp.get();
        return (long)this.syncBufferIntervalMills - farToLastSyncMills;
    }

    long now() {
        return SystemClock.uptimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushProcess() throws IOException {
        boolean success;
        int size;
        SparseArray<AtomicLong> sparseArray = this.noSyncLengthMap;
        synchronized (sparseArray) {
            size = this.noSyncLengthMap.size();
        }
        SparseArray increaseLengthMap = new SparseArray(size);
        try {
            for (int i = 0; i < size; ++i) {
                int blockIndex = this.outputStreamMap.keyAt(i);
                long noSyncLength = ((AtomicLong)this.noSyncLengthMap.get(blockIndex)).get();
                if (noSyncLength <= 0L) continue;
                increaseLengthMap.put(blockIndex, (Object)noSyncLength);
                DownloadOutputStream outputStream = (DownloadOutputStream)this.outputStreamMap.get(blockIndex);
                outputStream.flushAndSync();
            }
            success = true;
        }
        catch (IOException ex) {
            Util.w(TAG, "OutputStream flush and sync data to filesystem failed " + ex);
            success = false;
        }
        if (success) {
            int increaseLengthSize = increaseLengthMap.size();
            long allIncreaseLength = 0L;
            for (int i = 0; i < increaseLengthSize; ++i) {
                int blockIndex = increaseLengthMap.keyAt(i);
                long noSyncLength = (Long)increaseLengthMap.valueAt(i);
                this.store.onSyncToFilesystemSuccess(this.info, blockIndex, noSyncLength);
                allIncreaseLength += noSyncLength;
                ((AtomicLong)this.noSyncLengthMap.get(blockIndex)).addAndGet(-noSyncLength);
                Util.d(TAG, "OutputStream sync success (" + this.task.getId() + ") block(" + blockIndex + ")  syncLength(" + noSyncLength + ") currentOffset(" + this.info.getBlock(blockIndex).getCurrentOffset() + ")");
            }
            this.allNoSyncLength.addAndGet(-allIncreaseLength);
            this.lastSyncTimestamp.set(SystemClock.uptimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized DownloadOutputStream outputStream(int blockIndex) throws IOException {
        DownloadOutputStream outputStream = (DownloadOutputStream)this.outputStreamMap.get(blockIndex);
        if (outputStream == null) {
            long seekPoint;
            Uri uri;
            boolean isFileScheme = Util.isUriFileScheme(this.task.getUri());
            if (isFileScheme) {
                File file = this.task.getFile();
                if (file == null) {
                    throw new FileNotFoundException("Filename is not ready!");
                }
                File parentFile = this.task.getParentFile();
                if (!parentFile.exists() && !parentFile.mkdirs()) {
                    throw new IOException("Create parent folder failed!");
                }
                if (file.createNewFile()) {
                    Util.d(TAG, "Create new file: " + file.getName());
                }
                uri = Uri.fromFile((File)file);
            } else {
                uri = this.task.getUri();
            }
            outputStream = OkDownload.with().outputStreamFactory().create(OkDownload.with().context(), uri, this.flushBufferSize);
            if (this.supportSeek && (seekPoint = this.info.getBlock(blockIndex).getRangeLeft()) > 0L) {
                outputStream.seek(seekPoint);
                Util.d(TAG, "Create output stream write from (" + this.task.getId() + ") block(" + blockIndex + ") " + seekPoint);
            }
            if (this.firstOutputStream) {
                this.store.markFileDirty(this.task.getId());
            }
            if (!this.info.isChunked() && this.firstOutputStream && this.isPreAllocateLength) {
                long totalLength = this.info.getTotalLength();
                if (isFileScheme) {
                    File file = this.task.getFile();
                    long requireSpace = totalLength - file.length();
                    if (requireSpace > 0L) {
                        this.inspectFreeSpace(new StatFs(file.getAbsolutePath()), requireSpace);
                        outputStream.setLength(totalLength);
                    }
                } else {
                    outputStream.setLength(totalLength);
                }
            }
            SparseArray<AtomicLong> sparseArray = this.noSyncLengthMap;
            synchronized (sparseArray) {
                this.outputStreamMap.put(blockIndex, (Object)outputStream);
                this.noSyncLengthMap.put(blockIndex, (Object)new AtomicLong());
            }
            this.firstOutputStream = false;
        }
        return outputStream;
    }

    void inspectFreeSpace(StatFs statFs, long requireSpace) throws PreAllocateException {
        long freeSpace = Util.getFreeSpaceBytes(statFs);
        if (freeSpace < requireSpace) {
            throw new PreAllocateException(requireSpace, freeSpace);
        }
    }

    private void inspectValidPath() {
        if (this.path == null && this.task.getFile() != null) {
            this.path = this.task.getFile().getAbsolutePath();
        }
    }

    static class StreamsState {
        boolean isNoMoreStream;
        List<Integer> noMoreStreamBlockList = new ArrayList<Integer>();
        List<Integer> newNoMoreStreamBlockList = new ArrayList<Integer>();

        StreamsState() {
        }

        boolean isStreamsEndOrChanged() {
            return this.isNoMoreStream || this.newNoMoreStreamBlockList.size() > 0;
        }
    }
}

