/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download.core.listener.assist;

import android.util.SparseArray;
import com.taptap.sdk.update.download.DownloadTask;
import com.taptap.sdk.update.download.core.breakpoint.BlockInfo;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointInfo;
import com.taptap.sdk.update.download.core.cause.EndCause;
import com.taptap.sdk.update.download.core.listener.assist.ListenerAssist;
import com.taptap.sdk.update.download.core.listener.assist.ListenerModelHandler;

public class Listener4Assist<T extends Listener4Model>
implements ListenerAssist {
    Listener4Callback callback;
    private AssistExtend assistExtend;
    private final ListenerModelHandler<T> modelHandler;

    Listener4Assist(ListenerModelHandler<T> handler) {
        this.modelHandler = handler;
    }

    public Listener4Assist(ListenerModelHandler.ModelCreator<T> creator) {
        this.modelHandler = new ListenerModelHandler<T>(creator);
    }

    public void setCallback(Listener4Callback callback) {
        this.callback = callback;
    }

    public void setAssistExtend(AssistExtend assistExtend) {
        this.assistExtend = assistExtend;
    }

    public AssistExtend getAssistExtend() {
        return this.assistExtend;
    }

    public void infoReady(DownloadTask task, BreakpointInfo info, boolean fromBreakpoint) {
        Listener4Model model = (Listener4Model)this.modelHandler.addAndGetModel(task, info);
        if (this.assistExtend != null && this.assistExtend.dispatchInfoReady(task, info, fromBreakpoint, model)) {
            return;
        }
        if (this.callback != null) {
            this.callback.infoReady(task, info, fromBreakpoint, model);
        }
    }

    public void setCurrentOffset(DownloadTask task, long offset) {
        Listener4Model model = (Listener4Model)this.modelHandler.addAndGetModel(task, task.getInfo());
        model.setCurrentOffset(offset);
    }

    public long getCurrentOffset(DownloadTask task) {
        Listener4Model model = (Listener4Model)this.modelHandler.getOrRecoverModel(task, task.getInfo());
        if (model != null) {
            return model.getCurrentOffset();
        }
        return 0L;
    }

    public void fetchProgress(DownloadTask task, int blockIndex, long increaseBytes) {
        Listener4Model model = (Listener4Model)this.modelHandler.getOrRecoverModel(task, task.getInfo());
        if (model == null) {
            return;
        }
        if (model.blockCurrentOffsetMap.get(blockIndex) == null) {
            return;
        }
        long blockCurrentOffset = (Long)model.blockCurrentOffsetMap.get(blockIndex) + increaseBytes;
        model.blockCurrentOffsetMap.put(blockIndex, (Object)blockCurrentOffset);
        model.currentOffset += increaseBytes;
        if (this.assistExtend != null && this.assistExtend.dispatchFetchProgress(task, blockIndex, increaseBytes, model)) {
            return;
        }
        if (this.callback != null) {
            this.callback.progressBlock(task, blockIndex, blockCurrentOffset);
            this.callback.progress(task, model.currentOffset);
        }
    }

    public void fetchEnd(DownloadTask task, int blockIndex) {
        Listener4Model model = (Listener4Model)this.modelHandler.getOrRecoverModel(task, task.getInfo());
        if (model == null) {
            return;
        }
        if (this.assistExtend != null && this.assistExtend.dispatchBlockEnd(task, blockIndex, model)) {
            return;
        }
        if (this.callback != null) {
            this.callback.blockEnd(task, blockIndex, model.info.getBlock(blockIndex));
        }
    }

    public synchronized void taskEnd(DownloadTask task, EndCause cause, Exception realCause) {
        Listener4Model model = (Listener4Model)this.modelHandler.removeOrCreate(task, task.getInfo());
        if (this.assistExtend != null && this.assistExtend.dispatchTaskEnd(task, cause, realCause, model)) {
            return;
        }
        if (this.callback != null) {
            this.callback.taskEnd(task, cause, realCause, model);
        }
    }

    @Override
    public boolean isAlwaysRecoverAssistModel() {
        return this.modelHandler.isAlwaysRecoverAssistModel();
    }

    @Override
    public void setAlwaysRecoverAssistModel(boolean isAlwaysRecoverAssistModel) {
        this.modelHandler.setAlwaysRecoverAssistModel(isAlwaysRecoverAssistModel);
    }

    @Override
    public void setAlwaysRecoverAssistModelIfNotSet(boolean isAlwaysRecoverAssistModel) {
        this.modelHandler.setAlwaysRecoverAssistModelIfNotSet(isAlwaysRecoverAssistModel);
    }

    public static interface Listener4Callback {
        public void infoReady(DownloadTask var1, BreakpointInfo var2, boolean var3, Listener4Model var4);

        public void progressBlock(DownloadTask var1, int var2, long var3);

        public void progress(DownloadTask var1, long var2);

        public void blockEnd(DownloadTask var1, int var2, BlockInfo var3);

        public void taskEnd(DownloadTask var1, EndCause var2, Exception var3, Listener4Model var4);
    }

    public static interface AssistExtend {
        public boolean dispatchInfoReady(DownloadTask var1, BreakpointInfo var2, boolean var3, Listener4Model var4);

        public boolean dispatchFetchProgress(DownloadTask var1, int var2, long var3, Listener4Model var5);

        public boolean dispatchBlockEnd(DownloadTask var1, int var2, Listener4Model var3);

        public boolean dispatchTaskEnd(DownloadTask var1, EndCause var2, Exception var3, Listener4Model var4);
    }

    public static class Listener4Model
    implements ListenerModelHandler.ListenerModel {
        private final int id;
        BreakpointInfo info;
        long currentOffset;
        SparseArray<Long> blockCurrentOffsetMap;

        public Listener4Model(int id2) {
            this.id = id2;
        }

        SparseArray<Long> getBlockCurrentOffsetMap() {
            return this.blockCurrentOffsetMap;
        }

        public long getCurrentOffset() {
            return this.currentOffset;
        }

        public void setCurrentOffset(long offset) {
            this.currentOffset = offset;
        }

        public long getBlockCurrentOffset(int blockIndex) {
            return (Long)this.blockCurrentOffsetMap.get(blockIndex);
        }

        public SparseArray<Long> cloneBlockCurrentOffsetMap() {
            return this.blockCurrentOffsetMap.clone();
        }

        public BreakpointInfo getInfo() {
            return this.info;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public void onInfoValid(BreakpointInfo info) {
            this.info = info;
            this.currentOffset = info.getTotalOffset();
            SparseArray blockCurrentOffsetMap = new SparseArray();
            int blockCount = info.getBlockCount();
            for (int i = 0; i < blockCount; ++i) {
                BlockInfo blockInfo = info.getBlock(i);
                blockCurrentOffsetMap.put(i, (Object)blockInfo.getCurrentOffset());
            }
            this.blockCurrentOffsetMap = blockCurrentOffsetMap;
        }
    }
}

