/*
 * Decompiled with CFR 0.152.
 */
package com.taradevko.aem.misc.dao;

import com.day.cq.commons.Externalizer;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.taradevko.aem.misc.dao.PageDao;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component
public class PageDaoImpl
implements PageDao {
    private static final Logger LOG = LoggerFactory.getLogger(PageDaoImpl.class);
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private Externalizer externalizer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPagePath(String resourcePath) {
        try (ResourceResolver resourceResolver = null;){
            resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(null);
            PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
            Page containingPage = pageManager.getContainingPage(resourcePath);
            if (containingPage != null) {
                String string = containingPage.getPath();
                return string;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String externalizePagePath(String pagePath) {
        try (ResourceResolver resourceResolver = null;){
            resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(null);
            String string = this.externalizer.publishLink(resourceResolver, pagePath);
            return string;
        }
        return null;
    }

    public void bindResourceResolverFactory(ResourceResolverFactory rrf) {
        this.resourceResolverFactory = rrf;
    }

    public void bindExternalizer(Externalizer externalizer) {
        this.externalizer = externalizer;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void unbindExternalizer(Externalizer externalizer) {
        if (this.externalizer == externalizer) {
            this.externalizer = null;
        }
    }
}

