/*
 * Decompiled with CFR 0.152.
 */
package com.taradevko.aem.seo.misc;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public final class Rule {
    private final String prefixPatternString;
    private final String lookupPath;
    private final boolean isStrict;
    private final Pattern prefixPattern;

    public Rule(String prefixPatternString, String lookupPath, boolean isStrict) {
        this.prefixPatternString = prefixPatternString;
        this.lookupPath = lookupPath;
        this.isStrict = isStrict;
        this.prefixPattern = Pattern.compile(prefixPatternString);
    }

    public String getLookupPath() {
        return this.lookupPath;
    }

    public Matcher match(String input) {
        return this.prefixPattern.matcher(input);
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        return new EqualsBuilder().append(this.isStrict, rule.isStrict).append((Object)this.prefixPatternString, (Object)rule.prefixPatternString).append((Object)this.lookupPath, (Object)rule.lookupPath).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.prefixPatternString).append((Object)this.lookupPath).append(this.isStrict).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("prefixPatternString", (Object)this.prefixPatternString).append("lookupPath", (Object)this.lookupPath).append("isStrict", this.isStrict).append("prefixPattern", (Object)this.prefixPattern).toString();
    }
}

