/*
 * Decompiled with CFR 0.152.
 */
package com.taradevko.aem.seo.service;

import com.taradevko.aem.misc.dao.PageDao;
import com.taradevko.aem.seo.misc.Rule;
import com.taradevko.aem.seo.service.CanonicalTagging;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.assertj.core.util.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(label="Canonical Tagging Support", description="Configuration for the Canonical Tagging Support service", metatype=true)
public class CanonicalTaggingImpl
implements CanonicalTagging {
    private static final Logger LOG = LoggerFactory.getLogger(CanonicalTaggingImpl.class);
    @Property(cardinality=-2147483648, label="Page path mapping", description="Define page mapping")
    static final String PAGE_MAPPING = "canonical.mapping.rules";
    private static final String STRICT_MAPPING_SEPARATOR = "=>";
    private static final String REGEX_MAPPING_SEPARATOR = ">";
    @Reference
    private PageDao pageDao;
    private List<Rule> canonicalRules;

    @Override
    public String getCanonicalLink(String resourcePath) {
        for (Rule rule : this.canonicalRules) {
            String externalizedCanonicalPage;
            if (!rule.match(resourcePath).find() || !StringUtils.isNotBlank((CharSequence)(externalizedCanonicalPage = this.findCanonicalPage(resourcePath, rule)))) continue;
            return externalizedCanonicalPage;
        }
        return null;
    }

    private String findCanonicalPage(String resourcePath, Rule rule) {
        String pagePath = this.pageDao.getPagePath(resourcePath);
        if (StringUtils.isBlank((CharSequence)pagePath)) {
            LOG.warn("Can not get page path for the resource '{}'. Have you configured system user for this bundle?");
            return null;
        }
        if (rule.isStrict()) {
            return this.pageDao.externalizePagePath(rule.getLookupPath());
        }
        Matcher pagePathMatcher = rule.match(pagePath);
        pagePathMatcher.find();
        String pageRelativePath = pagePathMatcher.group(1);
        String canonicalPagePath = rule.getLookupPath() + pageRelativePath;
        return this.pageDao.externalizePagePath(canonicalPagePath);
    }

    @Activate
    @Modified
    public void activate(Map<String, Object> properties) {
        this.canonicalRules = new ArrayList<Rule>();
        String[] canonicalRulesArray = PropertiesUtil.toStringArray((Object)properties.get(PAGE_MAPPING));
        if (canonicalRulesArray.length < 1) {
            return;
        }
        for (String ruleString : canonicalRulesArray) {
            Rule rule = this.parseRule(ruleString);
            if (rule == null) continue;
            this.canonicalRules.add(rule);
        }
    }

    private Rule parseRule(String ruleString) {
        String[] ruleSplit;
        String separator = REGEX_MAPPING_SEPARATOR;
        boolean isStrict = false;
        if (ruleString.contains(STRICT_MAPPING_SEPARATOR)) {
            separator = STRICT_MAPPING_SEPARATOR;
            isStrict = true;
        }
        if (this.validateRule(ruleSplit = ruleString.split(separator))) {
            if (isStrict) {
                return new Rule(ruleSplit[0], ruleSplit[1], isStrict);
            }
            return new Rule(this.formatPrefixPattern(ruleSplit[0]), this.formatLookupPath(ruleSplit[1]), isStrict);
        }
        LOG.warn("Incorrect mapping rule '{}'", (Object)ruleString);
        return null;
    }

    private boolean validateRule(String[] ruleSplit) {
        return ruleSplit.length == 2 && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{ruleSplit[0], ruleSplit[1]});
    }

    private String formatPrefixPattern(String prefixPattern) {
        return this.addPatternGroupEnding(this.ensureSlashEnding(prefixPattern));
    }

    private String ensureSlashEnding(String path) {
        if (!path.endsWith("/")) {
            return path + "/";
        }
        return path;
    }

    private String addPatternGroupEnding(String pattern) {
        return pattern + "(.+)";
    }

    private String formatLookupPath(String lookupPath) {
        return this.ensureSlashEnding(lookupPath);
    }

    public void bindPageDao(PageDao pageDao) {
        this.pageDao = pageDao;
    }

    @VisibleForTesting
    public List<Rule> getCanonicalRules() {
        return this.canonicalRules;
    }

    protected void unbindPageDao(PageDao pageDao) {
        if (this.pageDao == pageDao) {
            this.pageDao = null;
        }
    }
}

