/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.internal.comm.betterssl;

import com.taskadapter.redmineapi.internal.comm.betterssl.CompositeTrustManager;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.SSLSocketFactory;

public class BetterSSLFactory {
    public static SSLSocketFactory createSocketFactory(Collection<KeyStore> extraStores) throws KeyStoreException, KeyManagementException {
        ArrayList<X509TrustManager> managers = new ArrayList<X509TrustManager>();
        for (KeyStore ks : extraStores) {
            BetterSSLFactory.addX509Managers(managers, ks);
        }
        BetterSSLFactory.addX509Managers(managers, null);
        CompositeTrustManager tm = new CompositeTrustManager(managers);
        try {
            SSLContext ctx = SSLContext.getInstance("SSL");
            ctx.init(null, new TrustManager[]{tm}, null);
            return new SSLSocketFactory(ctx);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("No SSL protocols supported :(", e);
        }
    }

    private static void addX509Managers(Collection<X509TrustManager> managers, KeyStore ks) throws KeyStoreException, Error {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                managers.add((X509TrustManager)tm);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("Default trust manager algorithm is not supported!", e);
        }
    }
}

