/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.internal.comm.betterssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.net.ssl.X509TrustManager;

final class CompositeTrustManager
implements X509TrustManager {
    private final Collection<X509TrustManager> peers;
    private final X509Certificate[] allCerts;

    CompositeTrustManager(Collection<X509TrustManager> peers) {
        this.peers = peers;
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        for (X509TrustManager peer : peers) {
            certs.addAll(Arrays.asList(peer.getAcceptedIssuers()));
        }
        this.allCerts = certs.toArray(new X509Certificate[certs.size()]);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509TrustManager peer : this.peers) {
            try {
                peer.checkClientTrusted(chain, authType);
                return;
            }
            catch (CertificateException certificateException) {
            }
        }
        throw new CertificateException("Could not authenticate client, nobody trusts it.");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509TrustManager peer : this.peers) {
            try {
                peer.checkServerTrusted(chain, authType);
                return;
            }
            catch (CertificateException certificateException) {
            }
        }
        throw new CertificateException("Could not authenticate server, nobody trusts it.");
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.allCerts;
    }
}

