/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi;

import com.taskadapter.redmineapi.NotFoundException;
import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineInternalError;
import com.taskadapter.redmineapi.bean.Membership;
import com.taskadapter.redmineapi.bean.News;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.Role;
import com.taskadapter.redmineapi.bean.Version;
import com.taskadapter.redmineapi.internal.RequestParam;
import com.taskadapter.redmineapi.internal.Transport;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class ProjectManager {
    private final Transport transport;

    ProjectManager(Transport transport) {
        this.transport = transport;
    }

    @Deprecated
    public Project createProject(Project project) throws RedmineException {
        return this.transport.addObject(project, new RequestParam("include", "trackers"));
    }

    public List<Project> getProjects() throws RedmineException {
        try {
            return this.transport.getObjectsList(Project.class, new RequestParam("include", "trackers"));
        }
        catch (NotFoundException e) {
            throw new RedmineInternalError("NotFoundException received, which should never happen in this request");
        }
    }

    public Project getProjectByKey(String projectKey) throws RedmineException {
        return this.transport.getObject(Project.class, projectKey, new RequestParam("include", "trackers"));
    }

    public Project getProjectById(int id) throws RedmineException {
        return this.transport.getObject(Project.class, id, new RequestParam("include", "trackers"));
    }

    @Deprecated
    public void deleteProject(String projectKey) throws RedmineException {
        this.transport.deleteObject(Project.class, projectKey);
    }

    @Deprecated
    public Version createVersion(Version version) throws RedmineException {
        return version.create();
    }

    @Deprecated
    public void deleteVersion(Version version) throws RedmineException {
        this.transport.deleteObject(Version.class, Integer.toString(version.getId()));
    }

    public List<Version> getVersions(int projectID) throws RedmineException {
        return this.transport.getChildEntries(Project.class, Integer.toString(projectID), Version.class);
    }

    public Version getVersionById(int versionId) throws RedmineException {
        return this.transport.getObject(Version.class, versionId, new RequestParam[0]);
    }

    @Deprecated
    public void update(Project object) throws RedmineException {
        this.transport.updateObject(object, new RequestParam[0]);
    }

    @Deprecated
    public void update(Version object) throws RedmineException {
        this.transport.updateObject(object, new RequestParam[0]);
    }

    public List<News> getNews(String projectKey) throws RedmineException {
        HashSet<RequestParam> params = new HashSet<RequestParam>();
        if (projectKey != null && projectKey.length() > 0) {
            params.add(new RequestParam("project_id", projectKey));
        }
        return this.transport.getObjectsList(News.class, params);
    }

    @Deprecated
    public Membership addUserToProject(int projectId, int userId, Collection<Role> roles) throws RedmineException {
        return new Membership(this.transport).setProject(new Project(this.transport).setId(projectId)).setUserId(userId).addRoles(roles).create();
    }

    @Deprecated
    public Membership addGroupToProject(int projectId, int groupId, Collection<Role> roles) throws RedmineException {
        return new Membership(this.transport).setProject(new Project(this.transport).setId(projectId)).setUserId(groupId).addRoles(roles).create();
    }

    public List<Membership> getProjectMembers(String projectKey) throws RedmineException {
        return this.transport.getChildEntries(Project.class, projectKey, Membership.class);
    }

    public List<Membership> getProjectMembers(int projectId) throws RedmineException {
        return this.transport.getChildEntries(Project.class, projectId, Membership.class);
    }

    public Membership getProjectMember(int membershipId) throws RedmineException {
        return this.transport.getObject(Membership.class, membershipId, new RequestParam[0]);
    }

    @Deprecated
    public void deleteProjectMembership(int membershipId) throws RedmineException {
        this.transport.deleteObject(Membership.class, Integer.toString(membershipId));
    }

    @Deprecated
    public void deleteProjectMembership(Membership membership) throws RedmineException {
        this.transport.deleteObject(Membership.class, membership.getId().toString());
    }

    @Deprecated
    public void updateProjectMembership(Membership membership) throws RedmineException {
        this.transport.updateObject(membership, new RequestParam[0]);
    }
}

