/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi;

import com.taskadapter.redmineapi.RedmineConfigurationException;
import com.taskadapter.redmineapi.RedmineManager;
import com.taskadapter.redmineapi.internal.Transport;
import com.taskadapter.redmineapi.internal.URIConfigurator;
import com.taskadapter.redmineapi.internal.comm.BaseCommunicator;
import com.taskadapter.redmineapi.internal.comm.betterssl.BetterSSLFactory;
import com.taskadapter.redmineapi.internal.comm.naivessl.NaiveSSLFactory;
import com.taskadapter.redmineapi.internal.comm.redmine.RedmineApiKeyAuthenticator;
import com.taskadapter.redmineapi.internal.comm.redmine.RedmineUserPasswordAuthenticator;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Collection;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public final class RedmineManagerFactory {
    private static final String DEFAULT_USER_PASSWORD_AUTHENTICATOR_CHARSET = "UTF-8";

    private RedmineManagerFactory() {
        throw new UnsupportedOperationException();
    }

    public static RedmineManager createUnauthenticated(String uri) {
        return RedmineManagerFactory.createUnauthenticated(uri, RedmineManagerFactory.createDefaultHttpClient(uri));
    }

    public static RedmineManager createUnauthenticated(String uri, HttpClient httpClient) {
        return RedmineManagerFactory.createWithUserAuth(uri, null, null, httpClient);
    }

    public static RedmineManager createWithApiKey(String uri, String apiAccessKey) {
        return RedmineManagerFactory.createWithApiKey(uri, apiAccessKey, RedmineManagerFactory.createDefaultHttpClient(uri));
    }

    public static RedmineManager createWithApiKey(String uri, String apiAccessKey, HttpClient httpClient) {
        BaseCommunicator baseCommunicator = new BaseCommunicator(httpClient);
        RedmineApiKeyAuthenticator<HttpResponse> authenticator = new RedmineApiKeyAuthenticator<HttpResponse>(baseCommunicator, apiAccessKey);
        return new RedmineManager(new Transport(new URIConfigurator(uri), httpClient, authenticator));
    }

    public static RedmineManager createWithUserAuth(String uri, String login, String password) {
        return RedmineManagerFactory.createWithUserAuth(uri, login, password, RedmineManagerFactory.createDefaultHttpClient(uri));
    }

    public static RedmineManager createWithUserAuth(String uri, String login, String password, HttpClient httpClient) {
        BaseCommunicator baseCommunicator = new BaseCommunicator(httpClient);
        RedmineUserPasswordAuthenticator<HttpResponse> passwordAuthenticator = new RedmineUserPasswordAuthenticator<HttpResponse>(baseCommunicator, DEFAULT_USER_PASSWORD_AUTHENTICATOR_CHARSET, login, password);
        Transport transport = new Transport(new URIConfigurator(uri), httpClient, passwordAuthenticator);
        return new RedmineManager(transport);
    }

    public static RedmineManager createWithUserAuth(String uri, String authenticationCharset, String login, String password, HttpClient httpClient) {
        BaseCommunicator baseCommunicator = new BaseCommunicator(httpClient);
        RedmineUserPasswordAuthenticator<HttpResponse> passwordAuthenticator = new RedmineUserPasswordAuthenticator<HttpResponse>(baseCommunicator, authenticationCharset, login, password);
        Transport transport = new Transport(new URIConfigurator(uri), httpClient, passwordAuthenticator);
        return new RedmineManager(transport);
    }

    @Deprecated
    public static ClientConnectionManager createInsecureConnectionManager() {
        return RedmineManagerFactory.createConnectionManager(NaiveSSLFactory.createNaiveSSLSocketFactory());
    }

    public static ClientConnectionManager createConnectionManagerWithExtraTrust(Collection<KeyStore> trustStores) throws KeyManagementException, KeyStoreException {
        return RedmineManagerFactory.createConnectionManager(BetterSSLFactory.createSocketFactory(trustStores));
    }

    public static ClientConnectionManager createConnectionManagerWithClientCertificate(KeyStore keyStore, String keyStorePassword, Collection<KeyStore> trustStores) throws KeyManagementException, KeyStoreException {
        return RedmineManagerFactory.createConnectionManager(BetterSSLFactory.createSocketFactory(keyStore, keyStorePassword, trustStores));
    }

    public static ClientConnectionManager createDefaultConnectionManager() {
        return RedmineManagerFactory.createConnectionManager(SSLSocketFactory.getSocketFactory());
    }

    public static ClientConnectionManager createSystemDefaultConnectionManager() {
        return RedmineManagerFactory.createConnectionManager(SSLSocketFactory.getSystemSocketFactory());
    }

    public static ClientConnectionManager createConnectionManager(SSLSocketFactory sslSocketFactory) {
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        registry.register(new Scheme("https", 443, (SchemeSocketFactory)sslSocketFactory));
        return new BasicClientConnectionManager(registry);
    }

    public static HttpClient createDefaultHttpClient(String uri) {
        try {
            return RedmineManagerFactory.getNewHttpClient(uri, RedmineManagerFactory.createSystemDefaultConnectionManager());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DefaultHttpClient();
        }
    }

    public static HttpClient getNewHttpClient(String uri, ClientConnectionManager connectionManager) {
        try {
            BasicHttpParams params = new BasicHttpParams();
            HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
            HttpProtocolParams.setContentCharset((HttpParams)params, (String)DEFAULT_USER_PASSWORD_AUTHENTICATOR_CHARSET);
            DefaultHttpClient result = new DefaultHttpClient(connectionManager, (HttpParams)params);
            RedmineManagerFactory.configureProxy(uri, result);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DefaultHttpClient();
        }
    }

    private static void configureProxy(String uri, DefaultHttpClient httpclient) {
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (proxyHost != null && proxyPort != null) {
            int port;
            List<Proxy> proxyList = null;
            try {
                proxyList = ProxySelector.getDefault().select(new URI(uri));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            if (proxyList != null && proxyList.get(0) == Proxy.NO_PROXY) {
                return;
            }
            try {
                port = Integer.parseInt(proxyPort);
            }
            catch (NumberFormatException e) {
                throw new RedmineConfigurationException("Illegal proxy port " + proxyPort, e);
            }
            HttpHost proxy = new HttpHost(proxyHost, port);
            httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            String proxyUser = System.getProperty("http.proxyUser");
            if (proxyUser != null) {
                String proxyPassword = System.getProperty("http.proxyPassword");
                httpclient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, port), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
            }
        }
    }
}

