/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.bean;

import com.taskadapter.redmineapi.Include;
import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.bean.Attachment;
import com.taskadapter.redmineapi.bean.Changeset;
import com.taskadapter.redmineapi.bean.CustomField;
import com.taskadapter.redmineapi.bean.FluentStyle;
import com.taskadapter.redmineapi.bean.Identifiable;
import com.taskadapter.redmineapi.bean.IssueCategory;
import com.taskadapter.redmineapi.bean.IssueRelation;
import com.taskadapter.redmineapi.bean.Journal;
import com.taskadapter.redmineapi.bean.Property;
import com.taskadapter.redmineapi.bean.PropertyStorage;
import com.taskadapter.redmineapi.bean.PropertyStorageUtil;
import com.taskadapter.redmineapi.bean.Tracker;
import com.taskadapter.redmineapi.bean.Version;
import com.taskadapter.redmineapi.bean.Watcher;
import com.taskadapter.redmineapi.internal.RequestParam;
import com.taskadapter.redmineapi.internal.Transport;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class Issue
implements Identifiable,
FluentStyle {
    private final PropertyStorage storage = new PropertyStorage();
    public static final Property<Integer> DATABASE_ID = new Property<Integer>(Integer.class, "id");
    public static final Property<String> SUBJECT = new Property<String>(String.class, "subject");
    public static final Property<Date> START_DATE = new Property<Date>(Date.class, "startDate");
    public static final Property<Date> DUE_DATE = new Property<Date>(Date.class, "dueDate");
    public static final Property<Date> CREATED_ON = new Property<Date>(Date.class, "createdOn");
    public static final Property<Date> UPDATED_ON = new Property<Date>(Date.class, "updatedOn");
    public static final Property<Integer> DONE_RATIO = new Property<Integer>(Integer.class, "doneRatio");
    public static final Property<Integer> PARENT_ID = new Property<Integer>(Integer.class, "parentId");
    public static final Property<Integer> PRIORITY_ID = new Property<Integer>(Integer.class, "priorityId");
    public static final Property<Float> ESTIMATED_HOURS = new Property<Float>(Float.class, "estimatedHours");
    public static final Property<Float> SPENT_HOURS = new Property<Float>(Float.class, "spentHours");
    public static final Property<Integer> ASSIGNEE_ID = new Property<Integer>(Integer.class, "assigneeId");
    public static final Property<String> ASSIGNEE_NAME = new Property<String>(String.class, "assigneeName");
    public static final Property<String> NOTES = new Property<String>(String.class, "notes");
    public static final Property<Boolean> PRIVATE_NOTES = new Property<Boolean>(Boolean.class, "notes");
    public static final Property<String> PRIORITY_TEXT = new Property<String>(String.class, "priorityText");
    public static final Property<Integer> PROJECT_ID = new Property<Integer>(Integer.class, "projectId");
    public static final Property<String> PROJECT_NAME = new Property<String>(String.class, "projectName");
    public static final Property<Integer> AUTHOR_ID = new Property<Integer>(Integer.class, "authorId");
    public static final Property<String> AUTHOR_NAME = new Property<String>(String.class, "authorName");
    public static final Property<Tracker> TRACKER = new Property<Tracker>(Tracker.class, "tracker");
    public static final Property<String> DESCRIPTION = new Property<String>(String.class, "description");
    public static final Property<Date> CLOSED_ON = new Property<Date>(Date.class, "closedOn");
    public static final Property<Integer> STATUS_ID = new Property<Integer>(Integer.class, "statusId");
    public static final Property<String> STATUS_NAME = new Property<String>(String.class, "statusName");
    public static final Property<Version> TARGET_VERSION = new Property<Version>(Version.class, "targetVersion");
    public static final Property<IssueCategory> ISSUE_CATEGORY = new Property<IssueCategory>(IssueCategory.class, "issueCategory");
    public static final Property<Boolean> PRIVATE_ISSUE = new Property<Boolean>(Boolean.class, "privateIssue");
    public static final Property<Set<CustomField>> CUSTOM_FIELDS = new Property<Set>(Set.class, "customFields");
    public static final Property<Set<Journal>> JOURNALS = new Property<Set>(Set.class, "journals");
    public static final Property<Set<IssueRelation>> RELATIONS = new Property<Set>(Set.class, "relations");
    public static final Property<Set<Attachment>> ATTACHMENTS = new Property<Set>(Set.class, "attachments");
    public static final Property<Set<Changeset>> CHANGESETS = new Property<Set>(Set.class, "changesets");
    public static final Property<Set<Watcher>> WATCHERS = new Property<Set>(Set.class, "watchers");
    public static final Property<Set<Issue>> CHILDREN = new Property<Set>(Set.class, "children");
    private Transport transport;

    public Issue() {
        this.initCollections(this.storage);
    }

    public Issue(Transport transport, int projectId) {
        this();
        this.transport = transport;
        this.setProjectId(projectId);
    }

    public Issue(Transport transport, int projectId, String subject) {
        this();
        this.transport = transport;
        this.setSubject(subject);
        this.setProjectId(projectId);
    }

    private void initCollections(PropertyStorage storage) {
        storage.set(CUSTOM_FIELDS, new HashSet());
        storage.set(CHILDREN, new HashSet());
        storage.set(WATCHERS, new HashSet());
        storage.set(CHANGESETS, new HashSet());
        storage.set(ATTACHMENTS, new HashSet());
        storage.set(RELATIONS, new HashSet());
        storage.set(JOURNALS, new HashSet());
    }

    public Integer getProjectId() {
        return this.storage.get(PROJECT_ID);
    }

    public Issue setProjectId(Integer projectId) {
        this.storage.set(PROJECT_ID, projectId);
        return this;
    }

    public String getProjectName() {
        return this.storage.get(PROJECT_NAME);
    }

    public Issue setProjectName(String name) {
        this.storage.set(PROJECT_NAME, name);
        return this;
    }

    public Issue setId(Integer id) {
        this.storage.set(DATABASE_ID, id);
        return this;
    }

    public Integer getDoneRatio() {
        return this.storage.get(DONE_RATIO);
    }

    public Issue setDoneRatio(Integer doneRatio) {
        this.storage.set(DONE_RATIO, doneRatio);
        return this;
    }

    public String getPriorityText() {
        return this.storage.get(PRIORITY_TEXT);
    }

    public void setPriorityText(String priority) {
        this.storage.set(PRIORITY_TEXT, priority);
    }

    public Integer getAssigneeId() {
        return this.storage.get(ASSIGNEE_ID);
    }

    public Issue setAssigneeId(Integer assigneeId) {
        this.storage.set(ASSIGNEE_ID, assigneeId);
        return this;
    }

    public String getAssigneeName() {
        return this.storage.get(ASSIGNEE_NAME);
    }

    public Issue setAssigneeName(String assigneeName) {
        this.storage.set(ASSIGNEE_NAME, assigneeName);
        return this;
    }

    public Float getEstimatedHours() {
        return this.storage.get(ESTIMATED_HOURS);
    }

    public Issue setEstimatedHours(Float estimatedTime) {
        this.storage.set(ESTIMATED_HOURS, estimatedTime);
        return this;
    }

    public Float getSpentHours() {
        return this.storage.get(SPENT_HOURS);
    }

    public Issue setSpentHours(Float spentHours) {
        this.storage.set(SPENT_HOURS, spentHours);
        return this;
    }

    public Integer getParentId() {
        return this.storage.get(PARENT_ID);
    }

    public Issue setParentId(Integer parentId) {
        this.storage.set(PARENT_ID, parentId);
        return this;
    }

    @Override
    public Integer getId() {
        return this.storage.get(DATABASE_ID);
    }

    public String getSubject() {
        return this.storage.get(SUBJECT);
    }

    public Issue setSubject(String subject) {
        this.storage.set(SUBJECT, subject);
        return this;
    }

    public Date getStartDate() {
        return this.storage.get(START_DATE);
    }

    public Issue setStartDate(Date startDate) {
        this.storage.set(START_DATE, startDate);
        return this;
    }

    public Date getDueDate() {
        return this.storage.get(DUE_DATE);
    }

    public Issue setDueDate(Date dueDate) {
        this.storage.set(DUE_DATE, dueDate);
        return this;
    }

    public Integer getAuthorId() {
        return this.storage.get(AUTHOR_ID);
    }

    @Deprecated
    public Issue setAuthorId(Integer id) {
        this.storage.set(AUTHOR_ID, id);
        return this;
    }

    public String getAuthorName() {
        return this.storage.get(AUTHOR_NAME);
    }

    @Deprecated
    public Issue setAuthorName(String name) {
        this.storage.set(AUTHOR_NAME, name);
        return this;
    }

    public Tracker getTracker() {
        return this.storage.get(TRACKER);
    }

    public Issue setTracker(Tracker tracker) {
        this.storage.set(TRACKER, tracker);
        return this;
    }

    public String getDescription() {
        return this.storage.get(DESCRIPTION);
    }

    public Issue setDescription(String description) {
        this.storage.set(DESCRIPTION, description);
        return this;
    }

    public Date getCreatedOn() {
        return this.storage.get(CREATED_ON);
    }

    public Issue setCreatedOn(Date createdOn) {
        this.storage.set(CREATED_ON, createdOn);
        return this;
    }

    public Date getUpdatedOn() {
        return this.storage.get(UPDATED_ON);
    }

    public Issue setUpdatedOn(Date updatedOn) {
        this.storage.set(UPDATED_ON, updatedOn);
        return this;
    }

    public Date getClosedOn() {
        return this.storage.get(CLOSED_ON);
    }

    public Issue setClosedOn(Date closedOn) {
        this.storage.set(CLOSED_ON, closedOn);
        return this;
    }

    public Integer getStatusId() {
        return this.storage.get(STATUS_ID);
    }

    public Issue setStatusId(Integer statusId) {
        this.storage.set(STATUS_ID, statusId);
        return this;
    }

    public String getStatusName() {
        return this.storage.get(STATUS_NAME);
    }

    public Issue setStatusName(String statusName) {
        this.storage.set(STATUS_NAME, statusName);
        return this;
    }

    public Collection<CustomField> getCustomFields() {
        return Collections.unmodifiableCollection((Collection)this.storage.get(CUSTOM_FIELDS));
    }

    public Issue clearCustomFields() {
        this.storage.set(CUSTOM_FIELDS, new HashSet());
        return this;
    }

    public Issue addCustomFields(Collection<CustomField> customFields) {
        this.storage.get(CUSTOM_FIELDS).addAll(customFields);
        return this;
    }

    public Issue addCustomField(CustomField customField) {
        this.storage.get(CUSTOM_FIELDS).add(customField);
        return this;
    }

    @Deprecated
    public String getNotes() {
        return this.storage.get(NOTES);
    }

    public Issue setNotes(String notes) {
        this.storage.set(NOTES, notes);
        return this;
    }

    public boolean isPrivateNotes() {
        return this.storage.get(PRIVATE_NOTES);
    }

    public Issue setPrivateNotes(boolean privateNotes) {
        this.storage.set(PRIVATE_NOTES, privateNotes);
        return this;
    }

    public Collection<Journal> getJournals() {
        return Collections.unmodifiableCollection((Collection)this.storage.get(JOURNALS));
    }

    public void addJournals(Collection<Journal> journals) {
        this.storage.get(JOURNALS).addAll(journals);
    }

    public Collection<Changeset> getChangesets() {
        return Collections.unmodifiableCollection((Collection)this.storage.get(CHANGESETS));
    }

    public Issue addChangesets(Collection<Changeset> changesets) {
        this.storage.get(CHANGESETS).addAll(changesets);
        return this;
    }

    public Collection<Watcher> getWatchers() {
        return Collections.unmodifiableCollection((Collection)this.storage.get(WATCHERS));
    }

    public Issue addWatchers(Collection<Watcher> watchers) {
        this.storage.get(WATCHERS).addAll(watchers);
        return this;
    }

    public Collection<Issue> getChildren() {
        return Collections.unmodifiableCollection((Collection)this.storage.get(CHILDREN));
    }

    public Issue addChildren(Collection<Issue> children) {
        this.storage.get(CHILDREN).addAll(children);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Issue issue = (Issue)o;
        return !(this.getId() != null ? !this.getId().equals(issue.getId()) : issue.getId() != null);
    }

    public int hashCode() {
        return this.getId() != null ? this.getId().hashCode() : 0;
    }

    public CustomField getCustomFieldById(int customFieldId) {
        for (CustomField customField : this.storage.get(CUSTOM_FIELDS)) {
            if (customFieldId != customField.getId()) continue;
            return customField;
        }
        return null;
    }

    public CustomField getCustomFieldByName(String customFieldName) {
        for (CustomField customField : this.storage.get(CUSTOM_FIELDS)) {
            if (!customFieldName.equals(customField.getName())) continue;
            return customField;
        }
        return null;
    }

    public String toString() {
        return "Issue [id=" + this.getId() + ", subject=" + this.getSubject() + "]";
    }

    public Collection<IssueRelation> getRelations() {
        return Collections.unmodifiableCollection((Collection)this.storage.get(RELATIONS));
    }

    public Issue addRelations(Collection<IssueRelation> collection) {
        this.storage.get(RELATIONS).addAll(collection);
        return this;
    }

    public Integer getPriorityId() {
        return this.storage.get(PRIORITY_ID);
    }

    public Issue setPriorityId(Integer priorityId) {
        this.storage.set(PRIORITY_ID, priorityId);
        return this;
    }

    public Version getTargetVersion() {
        return this.storage.get(TARGET_VERSION);
    }

    public Collection<Attachment> getAttachments() {
        return Collections.unmodifiableCollection((Collection)this.storage.get(ATTACHMENTS));
    }

    public Issue addAttachments(Collection<Attachment> collection) {
        this.storage.get(ATTACHMENTS).addAll(collection);
        return this;
    }

    public Issue addAttachment(Attachment attachment) {
        this.storage.get(ATTACHMENTS).add(attachment);
        return this;
    }

    public Issue setTargetVersion(Version version) {
        this.storage.set(TARGET_VERSION, version);
        return this;
    }

    public IssueCategory getCategory() {
        return this.storage.get(ISSUE_CATEGORY);
    }

    public Issue setCategory(IssueCategory category) {
        this.storage.set(ISSUE_CATEGORY, category);
        return this;
    }

    public boolean isPrivateIssue() {
        return this.storage.get(PRIVATE_ISSUE);
    }

    public Issue setPrivateIssue(boolean privateIssue) {
        this.storage.set(PRIVATE_ISSUE, privateIssue);
        return this;
    }

    public PropertyStorage getStorage() {
        return this.storage;
    }

    public Issue create(RequestParam ... params) throws RedmineException {
        RequestParam[] enrichParams = Arrays.copyOf(params, params.length + 1);
        enrichParams[params.length] = new RequestParam("include", Include.attachments.toString());
        return this.transport.addObject(this, enrichParams);
    }

    public void update(RequestParam ... params) throws RedmineException {
        this.transport.updateObject(this, params);
    }

    public void delete() throws RedmineException {
        this.transport.deleteObject(Issue.class, Integer.toString(this.getId()));
    }

    public void addWatcher(int watcherId) throws RedmineException {
        this.transport.addWatcherToIssue(watcherId, this.getId());
    }

    public void deleteWatcher(int watcherId) throws RedmineException {
        this.transport.deleteChildId(Issue.class, Integer.toString(this.getId()), new Watcher(), watcherId);
    }

    @Override
    public void setTransport(Transport transport) {
        this.transport = transport;
        PropertyStorageUtil.updateCollections(this.storage, transport);
    }
}

