/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.bean;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.bean.CustomField;
import com.taskadapter.redmineapi.bean.FluentStyle;
import com.taskadapter.redmineapi.bean.Identifiable;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.Property;
import com.taskadapter.redmineapi.bean.PropertyStorage;
import com.taskadapter.redmineapi.bean.PropertyStorageUtil;
import com.taskadapter.redmineapi.internal.RequestParam;
import com.taskadapter.redmineapi.internal.Transport;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class Version
implements Identifiable,
FluentStyle {
    public static final String STATUS_OPEN = "open";
    public static final String STATUS_LOCKED = "locked";
    public static final String STATUS_CLOSED = "closed";
    public static final String SHARING_NONE = "none";
    public static final String SHARING_DESCENDANTS = "descendants";
    public static final String SHARING_HIERARCHY = "hierarchy";
    public static final String SHARING_TREE = "tree";
    public static final String SHARING_SYSTEM = "system";
    private final PropertyStorage storage = new PropertyStorage();
    public static final Property<Integer> DATABASE_ID = new Property<Integer>(Integer.class, "id");
    public static final Property<Integer> PROJECT_ID = new Property<Integer>(Integer.class, "projectId");
    public static final Property<String> PROJECT_NAME = new Property<String>(String.class, "projectName");
    public static final Property<String> NAME = new Property<String>(String.class, "name");
    public static final Property<String> DESCRIPTION = new Property<String>(String.class, "description");
    public static final Property<String> STATUS = new Property<String>(String.class, "status");
    public static final Property<String> SHARING = new Property<String>(String.class, "sharing");
    public static final Property<Date> DUE_DATE = new Property<Date>(Date.class, "dueDate");
    public static final Property<Date> CREATED_ON = new Property<Date>(Date.class, "createdOn");
    public static final Property<Date> UPDATED_ON = new Property<Date>(Date.class, "updatedOn");
    public static final Property<Set<CustomField>> CUSTOM_FIELDS = new Property<Set>(Set.class, "customFields");
    private Transport transport;

    public Version() {
        this.initCollections(this.storage);
    }

    public Version(Transport transport, int projectId, String name) {
        this();
        this.setTransport(transport);
        this.setProjectId(projectId);
        this.setName(name);
    }

    public Version setId(Integer id) {
        this.storage.set(DATABASE_ID, id);
        return this;
    }

    private void initCollections(PropertyStorage storage) {
        storage.set(CUSTOM_FIELDS, new HashSet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return !(this.getId() != null ? !this.getId().equals(version.getId()) : version.getId() != null);
    }

    public int hashCode() {
        return this.getId() != null ? this.getId().hashCode() : 0;
    }

    public Date getCreatedOn() {
        return this.storage.get(CREATED_ON);
    }

    public String getDescription() {
        return this.storage.get(DESCRIPTION);
    }

    public Date getDueDate() {
        return this.storage.get(DUE_DATE);
    }

    @Override
    public Integer getId() {
        return this.storage.get(DATABASE_ID);
    }

    public Integer getProjectId() {
        return this.storage.get(PROJECT_ID);
    }

    public Version setProjectId(Integer projectId) {
        this.storage.set(PROJECT_ID, projectId);
        return this;
    }

    public String getProjectName() {
        return this.storage.get(PROJECT_NAME);
    }

    public Version setProjectName(String name) {
        this.storage.set(PROJECT_NAME, name);
        return this;
    }

    public String getName() {
        return this.storage.get(NAME);
    }

    public String getSharing() {
        return this.storage.get(SHARING);
    }

    public String getStatus() {
        return this.storage.get(STATUS);
    }

    public Date getUpdatedOn() {
        return this.storage.get(UPDATED_ON);
    }

    public Version setCreatedOn(Date createdOn) {
        this.storage.set(CREATED_ON, createdOn);
        return this;
    }

    public Version setDescription(String description) {
        this.storage.set(DESCRIPTION, description);
        return this;
    }

    public Version setDueDate(Date dueDate) {
        this.storage.set(DUE_DATE, dueDate);
        return this;
    }

    public Version setName(String name) {
        this.storage.set(NAME, name);
        return this;
    }

    public Version setSharing(String sharing) {
        this.storage.set(SHARING, sharing);
        return this;
    }

    public Version setStatus(String status) {
        this.storage.set(STATUS, status);
        return this;
    }

    public void setUpdatedOn(Date updatedOn) {
        this.storage.set(UPDATED_ON, updatedOn);
    }

    public Collection<CustomField> getCustomFields() {
        return Collections.unmodifiableCollection((Collection)this.storage.get(CUSTOM_FIELDS));
    }

    public Version addCustomFields(Collection<CustomField> customFields) {
        this.storage.get(CUSTOM_FIELDS).addAll(customFields);
        return this;
    }

    public CustomField getCustomFieldById(int customFieldId) {
        for (CustomField customField : this.getCustomFields()) {
            if (customFieldId != customField.getId()) continue;
            return customField;
        }
        return null;
    }

    public String toString() {
        return "Version [id=" + this.getId() + ", name=" + this.getName() + "]";
    }

    public PropertyStorage getStorage() {
        return this.storage;
    }

    public Version create() throws RedmineException {
        if (this.getProjectId() == null) {
            throw new IllegalArgumentException("Version must contain projectId");
        }
        return this.transport.addChildEntry(Project.class, this.getProjectId().toString(), this, new RequestParam[0]);
    }

    public void update() throws RedmineException {
        this.transport.updateObject(this, new RequestParam[0]);
    }

    public void delete() throws RedmineException {
        this.transport.deleteObject(Version.class, Integer.toString(this.getId()));
    }

    @Override
    public void setTransport(Transport transport) {
        this.transport = transport;
        PropertyStorageUtil.updateCollections(this.storage, transport);
    }
}

