/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.internal;

import com.taskadapter.redmineapi.RedmineInternalError;
import com.taskadapter.redmineapi.bean.Attachment;
import com.taskadapter.redmineapi.bean.CustomField;
import com.taskadapter.redmineapi.bean.Group;
import com.taskadapter.redmineapi.bean.Identifiable;
import com.taskadapter.redmineapi.bean.Issue;
import com.taskadapter.redmineapi.bean.IssueCategory;
import com.taskadapter.redmineapi.bean.IssueRelation;
import com.taskadapter.redmineapi.bean.Membership;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.Property;
import com.taskadapter.redmineapi.bean.PropertyStorage;
import com.taskadapter.redmineapi.bean.Role;
import com.taskadapter.redmineapi.bean.TimeEntry;
import com.taskadapter.redmineapi.bean.Tracker;
import com.taskadapter.redmineapi.bean.User;
import com.taskadapter.redmineapi.bean.Version;
import com.taskadapter.redmineapi.bean.Watcher;
import com.taskadapter.redmineapi.bean.WikiPage;
import com.taskadapter.redmineapi.bean.WikiPageDetail;
import com.taskadapter.redmineapi.internal.RedmineDateParser;
import com.taskadapter.redmineapi.internal.json.JsonObjectWriter;
import com.taskadapter.redmineapi.internal.json.JsonOutput;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.json.JSONException;
import org.json.JSONWriter;

public class RedmineJSONBuilder {
    public static void writeProject(JSONWriter writer, Project project) throws IllegalArgumentException, JSONException {
        if (project.getName() == null) {
            throw new IllegalArgumentException("Project name must be set to create a new project");
        }
        if (project.getIdentifier() == null) {
            throw new IllegalArgumentException("Project identifier must be set to create a new project");
        }
        RedmineJSONBuilder.writeProject(project, writer);
    }

    static void writeTimeEntry(JSONWriter writer, TimeEntry timeEntry) throws JSONException {
        PropertyStorage storage = timeEntry.getStorage();
        RedmineJSONBuilder.addIfSet(writer, "id", storage, TimeEntry.DATABASE_ID);
        RedmineJSONBuilder.addIfSet(writer, "project_id", storage, TimeEntry.PROJECT_ID);
        RedmineJSONBuilder.addIfSet(writer, "issue_id", storage, TimeEntry.ISSUE_ID);
        RedmineJSONBuilder.addIfSet(writer, "user_id", storage, TimeEntry.USER_ID);
        RedmineJSONBuilder.addIfSet(writer, "activity_id", storage, TimeEntry.ACTIVITY_ID);
        RedmineJSONBuilder.addIfSet(writer, "hours", storage, TimeEntry.HOURS);
        RedmineJSONBuilder.addIfSet(writer, "comments", storage, TimeEntry.COMMENT);
        RedmineJSONBuilder.addIfSetShort2(writer, "spent_on", storage, TimeEntry.SPENT_ON);
        RedmineJSONBuilder.addIfSetFullDate(writer, "created_on", storage, TimeEntry.SPENT_ON);
        RedmineJSONBuilder.addIfSetFullDate(writer, "updated_on", storage, TimeEntry.SPENT_ON);
        RedmineJSONBuilder.writeCustomFields(writer, timeEntry.getCustomFields());
    }

    static void writeRelation(JSONWriter writer, IssueRelation relation) throws JSONException {
        PropertyStorage storage = relation.getStorage();
        RedmineJSONBuilder.addIfSet(writer, "issue_to_id", storage, IssueRelation.ISSUE_TO_ID);
        RedmineJSONBuilder.addIfSet(writer, "relation_type", storage, IssueRelation.RELATION_TYPE);
        RedmineJSONBuilder.addIfSet(writer, "delay", storage, IssueRelation.DELAY);
    }

    static void writeVersion(JSONWriter writer, Version version) throws JSONException {
        PropertyStorage storage = version.getStorage();
        RedmineJSONBuilder.addIfSet(writer, "id", storage, Version.DATABASE_ID);
        RedmineJSONBuilder.addIfSet(writer, "project_id", storage, Version.PROJECT_ID);
        RedmineJSONBuilder.addIfSet(writer, "name", storage, Version.NAME);
        RedmineJSONBuilder.addIfSet(writer, "description", storage, Version.DESCRIPTION);
        RedmineJSONBuilder.addIfSet(writer, "sharing", storage, Version.SHARING);
        RedmineJSONBuilder.addIfSet(writer, "status", storage, Version.STATUS);
        RedmineJSONBuilder.addIfSetShort2(writer, "due_date", storage, Version.DUE_DATE);
        RedmineJSONBuilder.addIfSetFullDate(writer, "created_on", storage, Version.CREATED_ON);
        RedmineJSONBuilder.addIfSetFullDate(writer, "updated_on", storage, Version.UPDATED_ON);
        RedmineJSONBuilder.writeCustomFields(writer, version.getCustomFields());
    }

    public static <T> String toSimpleJSON(String tag, T object, JsonObjectWriter<T> writer) throws RedmineInternalError {
        StringWriter swriter = new StringWriter();
        JSONWriter jsWriter = new JSONWriter((Appendable)swriter);
        try {
            jsWriter.object();
            jsWriter.key(tag);
            jsWriter.object();
            writer.write(jsWriter, object);
            jsWriter.endObject();
            jsWriter.endObject();
        }
        catch (JSONException e) {
            throw new RedmineInternalError("Unexpected JSONException", e);
        }
        return swriter.toString();
    }

    public static void writeProject(Project project, JSONWriter writer) throws JSONException {
        PropertyStorage storage = project.getStorage();
        RedmineJSONBuilder.addIfSet(writer, "id", storage, Project.DATABASE_ID);
        RedmineJSONBuilder.addIfSet(writer, "identifier", storage, Project.STRING_IDENTIFIER);
        RedmineJSONBuilder.addIfSet(writer, "name", storage, Project.NAME);
        RedmineJSONBuilder.addIfSet(writer, "description", storage, Project.DESCRIPTION);
        RedmineJSONBuilder.addIfSet(writer, "homepage", storage, Project.HOMEPAGE);
        RedmineJSONBuilder.addIfSetFullDate(writer, "created_on", storage, Project.CREATED_ON);
        RedmineJSONBuilder.addIfSetFullDate(writer, "updated_on", storage, Project.UPDATED_ON);
        RedmineJSONBuilder.writeCustomFields(writer, project.getCustomFields());
        RedmineJSONBuilder.addIfSet(writer, "parent_id", storage, Project.PARENT_DATABASE_ID);
        RedmineJSONBuilder.addIfSet(writer, "status", storage, Project.STATUS);
        RedmineJSONBuilder.addIfSet(writer, "is_public", storage, Project.PUBLIC);
        RedmineJSONBuilder.addIfSet(writer, "inherit_members", storage, Project.INHERIT_MEMBERS);
        RedmineJSONBuilder.writeProjectTrackers(writer, project);
    }

    private static void writeProjectTrackers(JSONWriter writer, Project project) throws JSONException {
        PropertyStorage storage = project.getStorage();
        if (storage.isPropertySet(Project.TRACKERS)) {
            ArrayList<Integer> trackerIds = new ArrayList<Integer>();
            for (Tracker tracker : project.getTrackers()) {
                trackerIds.add(tracker.getId());
            }
            JsonOutput.addScalarArray(writer, "tracker_ids", trackerIds, RedmineJSONBuilder::writeScalarValue);
        }
    }

    static void writeScalarValue(JSONWriter writer, Object object) throws JSONException {
        writer.value(object);
    }

    public static void writeCategory(JSONWriter writer, IssueCategory category) throws JSONException {
        PropertyStorage storage = category.getStorage();
        writer.key("id");
        writer.value((Object)category.getId());
        RedmineJSONBuilder.addIfSet(writer, "name", storage, IssueCategory.NAME);
        RedmineJSONBuilder.addIfSet(writer, "project_id", storage, IssueCategory.PROJECT_ID);
        RedmineJSONBuilder.addIfSet(writer, "assigned_to_id", storage, IssueCategory.ASSIGNEE_ID);
    }

    public static void writeUser(JSONWriter writer, User user) throws JSONException {
        PropertyStorage storage = user.getStorage();
        RedmineJSONBuilder.addIfSet(writer, "id", storage, User.ID);
        RedmineJSONBuilder.addIfSet(writer, "login", storage, User.LOGIN);
        RedmineJSONBuilder.addIfSet(writer, "password", storage, User.PASSWORD);
        RedmineJSONBuilder.addIfSet(writer, "firstname", storage, User.FIRST_NAME);
        RedmineJSONBuilder.addIfSet(writer, "lastname", storage, User.LAST_NAME);
        RedmineJSONBuilder.addIfSet(writer, "mail", storage, User.MAIL);
        RedmineJSONBuilder.addIfSet(writer, "auth_source_id", storage, User.AUTH_SOURCE_ID);
        RedmineJSONBuilder.addIfSet(writer, "status", storage, User.STATUS);
        RedmineJSONBuilder.addIfSetFullDate(writer, "created_on", storage, User.CREATED_ON);
        RedmineJSONBuilder.addIfSetFullDate(writer, "last_login_on", storage, User.LAST_LOGIN_ON);
        RedmineJSONBuilder.addIfSet(writer, "mail_notification", storage, User.MAIL_NOTIFICATION);
        RedmineJSONBuilder.addIfSet(writer, "must_change_passwd", storage, User.MUST_CHANGE_PASSWD);
        RedmineJSONBuilder.addIfSet(writer, "generate_password", storage, User.GENERATE_PASSWORD);
        RedmineJSONBuilder.writeCustomFields(writer, user.getCustomFields());
    }

    public static void writeGroup(JSONWriter writer, Group group) throws JSONException {
        PropertyStorage storage = group.getStorage();
        RedmineJSONBuilder.addIfSet(writer, "id", storage, Group.ID);
        RedmineJSONBuilder.addIfSet(writer, "name", storage, Group.NAME);
    }

    public static void writeIssue(JSONWriter writer, Issue issue) throws JSONException {
        PropertyStorage storage = issue.getStorage();
        RedmineJSONBuilder.addIfSet(writer, "id", storage, Issue.DATABASE_ID);
        RedmineJSONBuilder.addIfSet(writer, "subject", storage, Issue.SUBJECT);
        RedmineJSONBuilder.addIfSet(writer, "parent_issue_id", storage, Issue.PARENT_ID);
        RedmineJSONBuilder.addIfSet(writer, "estimated_hours", storage, Issue.ESTIMATED_HOURS);
        RedmineJSONBuilder.addIfSet(writer, "spent_hours", storage, Issue.SPENT_HOURS);
        RedmineJSONBuilder.addIfSet(writer, "assigned_to_id", storage, Issue.ASSIGNEE_ID);
        RedmineJSONBuilder.addIfSet(writer, "priority_id", storage, Issue.PRIORITY_ID);
        RedmineJSONBuilder.addIfSet(writer, "done_ratio", storage, Issue.DONE_RATIO);
        RedmineJSONBuilder.addIfSet(writer, "is_private", storage, Issue.PRIVATE_ISSUE);
        RedmineJSONBuilder.addIfSet(writer, "project_id", storage, Issue.PROJECT_ID);
        RedmineJSONBuilder.addIfSet(writer, "author_id", storage, Issue.AUTHOR_ID);
        RedmineJSONBuilder.addIfSet(writer, "start_date", storage, Issue.START_DATE, (SimpleDateFormat)RedmineDateParser.SHORT_DATE_FORMAT_V2.get());
        RedmineJSONBuilder.addIfSet(writer, "due_date", storage, Issue.DUE_DATE, (SimpleDateFormat)RedmineDateParser.SHORT_DATE_FORMAT_V2.get());
        RedmineJSONBuilder.addIfSetIdentifiable(writer, "tracker_id", storage, Issue.TRACKER);
        RedmineJSONBuilder.addIfSet(writer, "description", storage, Issue.DESCRIPTION);
        RedmineJSONBuilder.addIfSetFullDate(writer, "created_on", storage, Issue.CREATED_ON);
        RedmineJSONBuilder.addIfSetFullDate(writer, "updated_on", storage, Issue.UPDATED_ON);
        RedmineJSONBuilder.addIfSet(writer, "status_id", storage, Issue.STATUS_ID);
        RedmineJSONBuilder.addIfSetIdentifiable(writer, "fixed_version_id", storage, Issue.TARGET_VERSION);
        RedmineJSONBuilder.addIfSetIdentifiable(writer, "category_id", storage, Issue.ISSUE_CATEGORY);
        RedmineJSONBuilder.addIfSet(writer, "notes", storage, Issue.NOTES);
        RedmineJSONBuilder.addIfSet(writer, "private_notes", storage, Issue.PRIVATE_NOTES);
        RedmineJSONBuilder.writeCustomFields(writer, issue.getCustomFields());
        Collection<Watcher> issueWatchers = issue.getWatchers();
        if (issueWatchers != null && !issueWatchers.isEmpty()) {
            RedmineJSONBuilder.writeWatchers(writer, issueWatchers);
        }
        List uploads = issue.getAttachments().stream().filter(attachment -> attachment.getToken() != null).collect(Collectors.toList());
        JsonOutput.addArrayIfNotEmpty(writer, "uploads", uploads, RedmineJSONBuilder::writeUpload);
    }

    private static void addIfSet(JSONWriter writer, String jsonKeyName, PropertyStorage storage, Property<?> property) throws JSONException {
        if (storage.isPropertySet(property)) {
            writer.key(jsonKeyName);
            writer.value(storage.get(property));
        }
    }

    public static void addIfSetShort2(JSONWriter writer, String jsonKeyName, PropertyStorage storage, Property<Date> property) throws JSONException {
        SimpleDateFormat format = (SimpleDateFormat)RedmineDateParser.SHORT_DATE_FORMAT_V2.get();
        RedmineJSONBuilder.addIfSet(writer, jsonKeyName, storage, property, format);
    }

    private static void addIfSetFullDate(JSONWriter writer, String jsonKeyName, PropertyStorage storage, Property<Date> property) throws JSONException {
        SimpleDateFormat format = (SimpleDateFormat)RedmineDateParser.FULL_DATE_FORMAT.get();
        RedmineJSONBuilder.addIfSet(writer, jsonKeyName, storage, property, format);
    }

    private static void addIfSetIdentifiable(JSONWriter writer, String jsonKeyName, PropertyStorage storage, Property<? extends Identifiable> property) throws JSONException {
        if (storage.isPropertySet(property)) {
            Identifiable propertyValue = storage.get(property);
            writer.key(jsonKeyName);
            if (propertyValue != null) {
                writer.value((Object)propertyValue.getId());
            } else {
                writer.value(null);
            }
        }
    }

    private static void addIfSet(JSONWriter writer, String jsonKeyName, PropertyStorage storage, Property<Date> property, SimpleDateFormat format) throws JSONException {
        if (storage.isPropertySet(property)) {
            JsonOutput.add(writer, jsonKeyName, storage.get(property), format);
        }
    }

    public static void writeUpload(JSONWriter writer, Attachment attachment) throws JSONException {
        PropertyStorage storage = attachment.getStorage();
        RedmineJSONBuilder.addIfSet(writer, "token", storage, Attachment.TOKEN);
        RedmineJSONBuilder.addIfSet(writer, "filename", storage, Attachment.FILE_NAME);
        RedmineJSONBuilder.addIfSet(writer, "content_type", storage, Attachment.CONTENT_TYPE);
        RedmineJSONBuilder.addIfSet(writer, "description", storage, Attachment.DESCRIPTION);
    }

    public static void writeMembership(JSONWriter writer, Membership membership) throws JSONException {
        PropertyStorage storage = membership.getStorage();
        RedmineJSONBuilder.addIfSet(writer, "user_id", storage, Membership.USER_ID);
        RedmineJSONBuilder.addIfSet(writer, "group_id", storage, Membership.GROUP_ID);
        if (membership.getRoles() != null) {
            writer.key("role_ids");
            writer.array();
            for (Role role : membership.getRoles()) {
                writer.value(role.getId().longValue());
            }
            writer.endArray();
        }
    }

    private static void writeCustomFields(JSONWriter writer, Collection<CustomField> customFields) throws JSONException {
        if (customFields == null || customFields.isEmpty()) {
            return;
        }
        writer.key("custom_field_values").object();
        for (CustomField field : customFields) {
            Object valueToWrite = field.isMultiple() ? field.getValues() : field.getValue();
            writer.key(Integer.toString(field.getId())).value(valueToWrite);
        }
        writer.endObject();
    }

    public static void writeWatchers(JSONWriter writer, Collection<Watcher> watchers) throws JSONException {
        if (watchers == null || watchers.isEmpty()) {
            return;
        }
        writer.key("watcher_user_ids");
        writer.array();
        for (Watcher watcher : watchers) {
            if (watcher.getId() == null) continue;
            writer.value(watcher.getId().longValue());
        }
        writer.endArray();
    }

    public static void writeWikiPageDetail(JSONWriter writer, WikiPageDetail detail) throws JSONException {
        PropertyStorage storage = detail.getStorage();
        RedmineJSONBuilder.addIfSet(writer, "text", storage, WikiPageDetail.TEXT);
        RedmineJSONBuilder.addIfSet(writer, "comments", storage, WikiPageDetail.COMMENTS);
        RedmineJSONBuilder.addIfSet(writer, "version", storage, WikiPage.VERSION);
        JsonOutput.addArrayIfNotEmpty(writer, "uploads", detail.getAttachments(), RedmineJSONBuilder::writeUpload);
    }
}

