/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.internal;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineFormatException;
import com.taskadapter.redmineapi.RedmineInternalError;
import com.taskadapter.redmineapi.RedmineManager;
import com.taskadapter.redmineapi.bean.Attachment;
import com.taskadapter.redmineapi.bean.CustomFieldDefinition;
import com.taskadapter.redmineapi.bean.FluentStyle;
import com.taskadapter.redmineapi.bean.Group;
import com.taskadapter.redmineapi.bean.Identifiable;
import com.taskadapter.redmineapi.bean.Issue;
import com.taskadapter.redmineapi.bean.IssueCategory;
import com.taskadapter.redmineapi.bean.IssuePriority;
import com.taskadapter.redmineapi.bean.IssueRelation;
import com.taskadapter.redmineapi.bean.IssueStatus;
import com.taskadapter.redmineapi.bean.Membership;
import com.taskadapter.redmineapi.bean.News;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.Role;
import com.taskadapter.redmineapi.bean.SavedQuery;
import com.taskadapter.redmineapi.bean.TimeEntry;
import com.taskadapter.redmineapi.bean.TimeEntryActivity;
import com.taskadapter.redmineapi.bean.Tracker;
import com.taskadapter.redmineapi.bean.User;
import com.taskadapter.redmineapi.bean.Version;
import com.taskadapter.redmineapi.bean.Watcher;
import com.taskadapter.redmineapi.bean.WikiPage;
import com.taskadapter.redmineapi.bean.WikiPageDetail;
import com.taskadapter.redmineapi.internal.RedmineJSONBuilder;
import com.taskadapter.redmineapi.internal.RedmineJSONParser;
import com.taskadapter.redmineapi.internal.RequestParam;
import com.taskadapter.redmineapi.internal.ResultsWrapper;
import com.taskadapter.redmineapi.internal.URIConfigurator;
import com.taskadapter.redmineapi.internal.comm.BaseCommunicator;
import com.taskadapter.redmineapi.internal.comm.BasicHttpResponse;
import com.taskadapter.redmineapi.internal.comm.Communicator;
import com.taskadapter.redmineapi.internal.comm.Communicators;
import com.taskadapter.redmineapi.internal.comm.ContentHandler;
import com.taskadapter.redmineapi.internal.comm.SimpleCommunicator;
import com.taskadapter.redmineapi.internal.comm.redmine.RedmineAuthenticator;
import com.taskadapter.redmineapi.internal.comm.redmine.RedmineErrorHandler;
import com.taskadapter.redmineapi.internal.json.JsonInput;
import com.taskadapter.redmineapi.internal.json.JsonObjectParser;
import com.taskadapter.redmineapi.internal.json.JsonObjectWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Transport {
    private static final Map<Class<?>, EntityConfig<?>> OBJECT_CONFIGS = new HashMap();
    private static final String CONTENT_TYPE = "application/json; charset=utf-8";
    private static final int DEFAULT_OBJECTS_PER_PAGE = 25;
    private static final String KEY_TOTAL_COUNT = "total_count";
    private static final String KEY_LIMIT = "limit";
    private static final String KEY_OFFSET = "offset";
    private final Logger logger = LoggerFactory.getLogger(RedmineManager.class);
    private final SimpleCommunicator<String> communicator;
    private final Communicator<BasicHttpResponse> errorCheckingCommunicator;
    private final Communicator<HttpResponse> authenticator;
    private String onBehalfOfUser = null;
    private final URIConfigurator configurator;
    private String login;
    private String password;
    private int objectsPerPage = 25;
    private static final String CHARSET = "UTF-8";

    public Transport(URIConfigurator configurator, HttpClient client) {
        this.configurator = configurator;
        BaseCommunicator baseCommunicator = new BaseCommunicator(client);
        this.authenticator = new RedmineAuthenticator<HttpResponse>(baseCommunicator, CHARSET);
        RedmineErrorHandler errorProcessor = new RedmineErrorHandler();
        this.errorCheckingCommunicator = Communicators.fmap(this.authenticator, Communicators.compose(errorProcessor, Communicators.transportDecoder()));
        Communicator<String> coreCommunicator = Communicators.fmap(this.errorCheckingCommunicator, Communicators.contentReader());
        this.communicator = Communicators.simplify(coreCommunicator, Communicators.identityHandler());
    }

    public Transport(URIConfigurator configurator, HttpClient client, Communicator communicator) {
        this.configurator = configurator;
        this.authenticator = communicator;
        RedmineErrorHandler errorProcessor = new RedmineErrorHandler();
        this.errorCheckingCommunicator = Communicators.fmap(this.authenticator, Communicators.compose(errorProcessor, Communicators.transportDecoder()));
        Communicator<String> coreCommunicator = Communicators.fmap(this.errorCheckingCommunicator, Communicators.contentReader());
        this.communicator = Communicators.simplify(coreCommunicator, Communicators.identityHandler());
    }

    public User getCurrentUser(RequestParam ... params) throws RedmineException {
        URI uri = this.getURIConfigurator().createURI("users/current.json", params);
        HttpGet http = new HttpGet(uri);
        String response = this.send((HttpRequestBase)http);
        return this.parseResponse(response, "user", RedmineJSONParser::parseUser);
    }

    public <T> T addObject(T object, RequestParam ... params) throws RedmineException {
        EntityConfig<T> config = this.getConfig(object.getClass());
        if (config.writer == null) {
            throw new RuntimeException("can't create object: writer is not implemented or is not registered in RedmineJSONBuilder for object " + object);
        }
        URI uri = this.getURIConfigurator().getObjectsURI(object.getClass(), params);
        HttpPost httpPost = new HttpPost(uri);
        String body = RedmineJSONBuilder.toSimpleJSON(config.singleObjectName, object, config.writer);
        Transport.setEntity((HttpEntityEnclosingRequest)httpPost, body);
        String response = this.send((HttpRequestBase)httpPost);
        this.logger.debug(response);
        return this.parseResponse(response, config.singleObjectName, config.parser);
    }

    public <T> T addChildEntry(Class<?> parentClass, String parentId, T object, RequestParam ... params) throws RedmineException {
        EntityConfig<T> config = this.getConfig(object.getClass());
        URI uri = this.getURIConfigurator().getChildObjectsURI(parentClass, parentId, object.getClass(), params);
        HttpPost httpPost = new HttpPost(uri);
        String body = RedmineJSONBuilder.toSimpleJSON(config.singleObjectName, object, config.writer);
        Transport.setEntity((HttpEntityEnclosingRequest)httpPost, body);
        String response = this.send((HttpRequestBase)httpPost);
        this.logger.debug(response);
        return this.parseResponse(response, config.singleObjectName, config.parser);
    }

    public <T extends Identifiable> void updateObject(T obj, RequestParam ... params) throws RedmineException {
        EntityConfig<T> config = this.getConfig(obj.getClass());
        Integer id = obj.getId();
        if (id == null) {
            throw new RuntimeException("'id' field cannot be NULL in the given object: it is required to identify the object in the target system");
        }
        URI uri = this.getURIConfigurator().getObjectURI(obj.getClass(), Integer.toString(id), params);
        HttpPut http = new HttpPut(uri);
        String body = RedmineJSONBuilder.toSimpleJSON(config.singleObjectName, obj, config.writer);
        Transport.setEntity((HttpEntityEnclosingRequest)http, body);
        this.send((HttpRequestBase)http);
    }

    public <T> void updateChildEntry(Class<?> parentClass, String parentId, T obj, String objId, RequestParam ... params) throws RedmineException {
        EntityConfig<T> config = this.getConfig(obj.getClass());
        URI uri = this.getURIConfigurator().getChildIdURI(parentClass, parentId, obj.getClass(), objId, params);
        HttpPut http = new HttpPut(uri);
        String body = RedmineJSONBuilder.toSimpleJSON(config.singleObjectName, obj, config.writer);
        Transport.setEntity((HttpEntityEnclosingRequest)http, body);
        this.send((HttpRequestBase)http);
    }

    public <T> void deleteChildId(Class<?> parentClass, String parentId, T object, Integer value) throws RedmineException {
        URI uri = this.getURIConfigurator().getChildIdURI(parentClass, parentId, object.getClass(), value, new RequestParam[0]);
        HttpDelete httpDelete = new HttpDelete(uri);
        String response = this.send((HttpRequestBase)httpDelete);
        this.logger.debug(response);
    }

    public <T extends Identifiable> void deleteObject(Class<T> classs, String id) throws RedmineException {
        URI uri = this.getURIConfigurator().getObjectURI(classs, id, new RequestParam[0]);
        HttpDelete http = new HttpDelete(uri);
        this.send((HttpRequestBase)http);
    }

    public <T> T getObject(Class<T> classs, String key, RequestParam ... params) throws RedmineException {
        EntityConfig<T> config = this.getConfig(classs);
        URI uri = this.getURIConfigurator().getObjectURI(classs, key, params);
        HttpGet http = new HttpGet(uri);
        String response = this.send((HttpRequestBase)http);
        this.logger.debug(response);
        return this.parseResponse(response, config.singleObjectName, config.parser);
    }

    public <R> R download(String uri, ContentHandler<BasicHttpResponse, R> handler) throws RedmineException {
        HttpGet request = new HttpGet(uri);
        if (this.onBehalfOfUser != null) {
            request.addHeader("X-Redmine-Switch-User", this.onBehalfOfUser);
        }
        return this.errorCheckingCommunicator.sendRequest((HttpRequest)request, handler);
    }

    @Deprecated
    public String upload(InputStream content) throws RedmineException {
        return this.upload(content, -1L);
    }

    public String upload(InputStream content, long contentLength) throws RedmineException {
        URI uploadURI = this.getURIConfigurator().getUploadURI();
        HttpPost request = new HttpPost(uploadURI);
        InputStreamEntity entity = new InputStreamEntity(content, contentLength);
        entity.setContentType("application/octet-stream");
        request.setEntity((HttpEntity)entity);
        String result = this.send((HttpRequestBase)request);
        return this.parseResponse(result, "upload", input -> JsonInput.getStringNotNull(input, "token"));
    }

    public <T> T getObject(Class<T> classs, Integer key, RequestParam ... params) throws RedmineException {
        return this.getObject(classs, key.toString(), params);
    }

    public <T> List<T> getObjectsList(Class<T> objectClass, RequestParam ... params) throws RedmineException {
        return this.getObjectsList(objectClass, Arrays.asList(params));
    }

    public <T> List<T> getObjectsList(Class<T> objectClass, Collection<? extends RequestParam> params) throws RedmineException {
        ResultsWrapper<T> wrapper;
        Integer totalObjectsFoundOnServer;
        ArrayList<T> result = new ArrayList<T>();
        int offset = 0;
        do {
            ArrayList<? extends RequestParam> newParams = new ArrayList<RequestParam>(params);
            newParams.add(new RequestParam(KEY_LIMIT, String.valueOf(this.objectsPerPage)));
            newParams.add(new RequestParam(KEY_OFFSET, String.valueOf(offset)));
            wrapper = this.getObjectsListNoPaging(objectClass, newParams);
            result.addAll(wrapper.getResults());
        } while ((totalObjectsFoundOnServer = wrapper.getTotalFoundOnServer()) != null && wrapper.hasSomeResults() && (offset += wrapper.getResultsNumber()) < totalObjectsFoundOnServer);
        return result;
    }

    public <T> ResultsWrapper<T> getObjectsListNoPaging(Class<T> objectClass, Collection<? extends RequestParam> params) throws RedmineException {
        EntityConfig<T> config = this.getConfig(objectClass);
        try {
            JSONObject responseObject = this.getJsonResponseFromGet(objectClass, params);
            List results = JsonInput.getListOrNull(responseObject, config.multiObjectName, config.parser);
            Integer totalFoundOnServer = JsonInput.getIntOrNull(responseObject, KEY_TOTAL_COUNT);
            Integer limitOnServer = JsonInput.getIntOrNull(responseObject, KEY_LIMIT);
            Integer offsetOnServer = JsonInput.getIntOrNull(responseObject, KEY_OFFSET);
            return new ResultsWrapper(totalFoundOnServer, limitOnServer, offsetOnServer, results);
        }
        catch (JSONException e) {
            throw new RedmineFormatException(e);
        }
    }

    public <T> JSONObject getJsonResponseFromGet(Class<T> objectClass, Collection<? extends RequestParam> params) throws RedmineException, JSONException {
        ArrayList<? extends RequestParam> newParams = new ArrayList<RequestParam>(params);
        ArrayList<RequestParam> paramsList = new ArrayList<RequestParam>(newParams);
        URI uri = this.getURIConfigurator().getObjectsURI(objectClass, paramsList);
        HttpGet http = new HttpGet(uri);
        String response = this.send((HttpRequestBase)http);
        return RedmineJSONParser.getResponse(response);
    }

    public <T> List<T> getChildEntries(Class<?> parentClass, int parentId, Class<T> classs) throws RedmineException {
        return this.getChildEntries(parentClass, "" + parentId, classs);
    }

    public <T> List<T> getChildEntries(Class<?> parentClass, String parentKey, Class<T> classs) throws RedmineException {
        EntityConfig<T> config = this.getConfig(classs);
        URI uri = this.getURIConfigurator().getChildObjectsURI(parentClass, parentKey, classs, new RequestParam(KEY_LIMIT, String.valueOf(this.objectsPerPage)));
        HttpGet http = new HttpGet(uri);
        String response = this.send((HttpRequestBase)http);
        try {
            JSONObject responseObject = RedmineJSONParser.getResponse(response);
            return JsonInput.getListNotNull(responseObject, config.multiObjectName, config.parser);
        }
        catch (JSONException e) {
            throw new RedmineFormatException("Bad categories response " + response, e);
        }
    }

    public <T> T getChildEntry(Class<?> parentClass, String parentId, Class<T> classs, String childId, RequestParam ... params) throws RedmineException {
        EntityConfig<T> config = this.getConfig(classs);
        URI uri = this.getURIConfigurator().getChildIdURI(parentClass, parentId, classs, childId, params);
        HttpGet http = new HttpGet(uri);
        String response = this.send((HttpRequestBase)http);
        return this.parseResponse(response, config.singleObjectName, config.parser);
    }

    public void setObjectsPerPage(int pageSize) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("Page size must be >= 0. You provided: " + pageSize);
        }
        this.objectsPerPage = pageSize;
    }

    public void addUserToGroup(int userId, int groupId) throws RedmineException {
        this.logger.debug("adding user " + userId + " to group " + groupId + "...");
        URI uri = this.getURIConfigurator().getChildObjectsURI(Group.class, Integer.toString(groupId), User.class, new RequestParam[0]);
        HttpPost httpPost = new HttpPost(uri);
        StringWriter writer = new StringWriter();
        JSONWriter jsonWriter = new JSONWriter((Appendable)writer);
        try {
            jsonWriter.object().key("user_id").value((long)userId).endObject();
        }
        catch (JSONException e) {
            throw new RedmineInternalError("Unexpected exception", e);
        }
        String body = writer.toString();
        Transport.setEntity((HttpEntityEnclosingRequest)httpPost, body);
        String response = this.send((HttpRequestBase)httpPost);
        this.logger.debug(response);
    }

    public void addWatcherToIssue(int watcherId, int issueId) throws RedmineException {
        this.logger.debug("adding watcher " + watcherId + " to issue " + issueId + "...");
        URI uri = this.getURIConfigurator().getChildObjectsURI(Issue.class, Integer.toString(issueId), Watcher.class, new RequestParam[0]);
        HttpPost httpPost = new HttpPost(uri);
        StringWriter writer = new StringWriter();
        JSONWriter jsonWriter = new JSONWriter((Appendable)writer);
        try {
            jsonWriter.object().key("user_id").value((long)watcherId).endObject();
        }
        catch (JSONException e) {
            throw new RedmineInternalError("Unexpected exception", e);
        }
        String body = writer.toString();
        Transport.setEntity((HttpEntityEnclosingRequest)httpPost, body);
        String response = this.send((HttpRequestBase)httpPost);
        this.logger.debug(response);
    }

    private String send(HttpRequestBase http) throws RedmineException {
        if (this.onBehalfOfUser != null) {
            http.addHeader("X-Redmine-Switch-User", this.onBehalfOfUser);
        }
        return this.communicator.sendRequest((HttpRequest)http);
    }

    private <T> T parseResponse(String response, String tag, JsonObjectParser<T> parser) throws RedmineFormatException {
        try {
            T parse = parser.parse(RedmineJSONParser.getResponseSingleObject(response, tag));
            if (parse instanceof FluentStyle) {
                ((FluentStyle)parse).setTransport(this);
            }
            return parse;
        }
        catch (JSONException e) {
            throw new RedmineFormatException(e);
        }
    }

    private static void setEntity(HttpEntityEnclosingRequest request, String body) {
        Transport.setEntity(request, body, CONTENT_TYPE);
    }

    private static void setEntity(HttpEntityEnclosingRequest request, String body, String contentType) {
        StringEntity entity;
        try {
            entity = new StringEntity(body, CHARSET);
        }
        catch (UnsupportedCharsetException e) {
            throw new RedmineInternalError("Required charset UTF-8 is not supported", e);
        }
        entity.setContentType(contentType);
        request.setEntity((HttpEntity)entity);
    }

    private <T> EntityConfig<T> getConfig(Class<?> class1) {
        EntityConfig<?> guess = OBJECT_CONFIGS.get(class1);
        if (guess == null) {
            throw new RedmineInternalError("Unsupported class " + class1);
        }
        return guess;
    }

    private URIConfigurator getURIConfigurator() {
        return this.configurator;
    }

    private static <T> EntityConfig<T> config(String objectField, String urlPrefix, JsonObjectWriter<T> writer, JsonObjectParser<T> parser) {
        return new EntityConfig<T>(objectField, urlPrefix, writer, parser);
    }

    public void setOnBehalfOfUser(String loginName) {
        this.onBehalfOfUser = loginName;
    }

    static {
        OBJECT_CONFIGS.put(Project.class, Transport.config("project", "projects", RedmineJSONBuilder::writeProject, RedmineJSONParser::parseProject));
        OBJECT_CONFIGS.put(Issue.class, Transport.config("issue", "issues", RedmineJSONBuilder::writeIssue, RedmineJSONParser::parseIssue));
        OBJECT_CONFIGS.put(User.class, Transport.config("user", "users", RedmineJSONBuilder::writeUser, RedmineJSONParser::parseUser));
        OBJECT_CONFIGS.put(Group.class, Transport.config("group", "groups", RedmineJSONBuilder::writeGroup, RedmineJSONParser::parseGroup));
        OBJECT_CONFIGS.put(IssueCategory.class, Transport.config("issue_category", "issue_categories", RedmineJSONBuilder::writeCategory, RedmineJSONParser::parseCategory));
        OBJECT_CONFIGS.put(Version.class, Transport.config("version", "versions", RedmineJSONBuilder::writeVersion, RedmineJSONParser::parseVersion));
        OBJECT_CONFIGS.put(TimeEntry.class, Transport.config("time_entry", "time_entries", RedmineJSONBuilder::writeTimeEntry, RedmineJSONParser::parseTimeEntry));
        OBJECT_CONFIGS.put(News.class, Transport.config("news", "news", null, RedmineJSONParser::parseNews));
        OBJECT_CONFIGS.put(IssueRelation.class, Transport.config("relation", "relations", RedmineJSONBuilder::writeRelation, RedmineJSONParser::parseRelation));
        OBJECT_CONFIGS.put(Tracker.class, Transport.config("tracker", "trackers", null, RedmineJSONParser::parseTracker));
        OBJECT_CONFIGS.put(IssueStatus.class, Transport.config("status", "issue_statuses", null, RedmineJSONParser::parseStatus));
        OBJECT_CONFIGS.put(SavedQuery.class, Transport.config("query", "queries", null, RedmineJSONParser::parseSavedQuery));
        OBJECT_CONFIGS.put(Role.class, Transport.config("role", "roles", null, RedmineJSONParser::parseRole));
        OBJECT_CONFIGS.put(Membership.class, Transport.config("membership", "memberships", RedmineJSONBuilder::writeMembership, RedmineJSONParser::parseMembership));
        OBJECT_CONFIGS.put(IssuePriority.class, Transport.config("issue_priority", "issue_priorities", null, RedmineJSONParser::parseIssuePriority));
        OBJECT_CONFIGS.put(TimeEntryActivity.class, Transport.config("time_entry_activity", "time_entry_activities", null, RedmineJSONParser::parseTimeEntryActivity));
        OBJECT_CONFIGS.put(Watcher.class, Transport.config("watcher", "watchers", null, RedmineJSONParser::parseWatcher));
        OBJECT_CONFIGS.put(WikiPage.class, Transport.config("wiki_page", "wiki_pages", null, RedmineJSONParser::parseWikiPage));
        OBJECT_CONFIGS.put(WikiPageDetail.class, Transport.config("wiki_page", null, RedmineJSONBuilder::writeWikiPageDetail, RedmineJSONParser::parseWikiPageDetail));
        OBJECT_CONFIGS.put(CustomFieldDefinition.class, Transport.config("custom_field", "custom_fields", null, RedmineJSONParser::parseCustomFieldDefinition));
        OBJECT_CONFIGS.put(Attachment.class, Transport.config("attachment", "attachments", null, RedmineJSONParser::parseAttachments));
    }

    static class EntityConfig<T> {
        final String singleObjectName;
        final String multiObjectName;
        final JsonObjectWriter<T> writer;
        final JsonObjectParser<T> parser;

        public EntityConfig(String objectField, String urlPrefix, JsonObjectWriter<T> writer, JsonObjectParser<T> parser) {
            this.singleObjectName = objectField;
            this.multiObjectName = urlPrefix;
            this.writer = writer;
            this.parser = parser;
        }
    }
}

