/*
 * Decompiled with CFR 0.152.
 */
package com.tbuonomo.viewpagerdotsindicator;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import androidx.dynamicanimation.animation.FloatPropertyCompat;
import androidx.dynamicanimation.animation.SpringAnimation;
import androidx.dynamicanimation.animation.SpringForce;
import com.tbuonomo.viewpagerdotsindicator.BaseDotsIndicator;
import com.tbuonomo.viewpagerdotsindicator.ExtensionsKt;
import com.tbuonomo.viewpagerdotsindicator.OnPageChangeListenerHelper;
import com.tbuonomo.viewpagerdotsindicator.R;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J\b\u0010$\u001a\u00020\u001bH\u0016J\u000e\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u0007J\u000e\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u0013J\u000e\u0010)\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u0007J\u0018\u0010*\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010+\u001a\u00020\u000bH\u0002J\b\u0010,\u001a\u00020\u001bH\u0002R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006-"}, d2={"Lcom/tbuonomo/viewpagerdotsindicator/WormDotsIndicator;", "Lcom/tbuonomo/viewpagerdotsindicator/BaseDotsIndicator;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "dotIndicatorColor", "dotIndicatorLayout", "Landroid/view/View;", "dotIndicatorView", "Landroid/widget/ImageView;", "dotIndicatorWidthSpring", "Landroidx/dynamicanimation/animation/SpringAnimation;", "dotIndicatorXSpring", "dotsStrokeColor", "dotsStrokeWidth", "", "strokeDotsLinearLayout", "Landroid/widget/LinearLayout;", "type", "Lcom/tbuonomo/viewpagerdotsindicator/BaseDotsIndicator$Type;", "getType", "()Lcom/tbuonomo/viewpagerdotsindicator/BaseDotsIndicator$Type;", "addDot", "", "index", "buildDot", "Landroid/view/ViewGroup;", "stroke", "", "buildOnPageChangedListener", "Lcom/tbuonomo/viewpagerdotsindicator/OnPageChangeListenerHelper;", "refreshDotColor", "removeDot", "setDotIndicatorColor", "color", "setDotsStrokeWidth", "width", "setStrokeDotsIndicatorColor", "setUpDotBackground", "dotImageView", "setUpDotIndicator", "viewpagerdotsindicator_debug"})
public final class WormDotsIndicator
extends BaseDotsIndicator {
    @Nullable
    private ImageView dotIndicatorView;
    @Nullable
    private View dotIndicatorLayout;
    private float dotsStrokeWidth;
    private int dotIndicatorColor;
    private int dotsStrokeColor;
    @Nullable
    private SpringAnimation dotIndicatorXSpring;
    @Nullable
    private SpringAnimation dotIndicatorWidthSpring;
    @NotNull
    private final LinearLayout strokeDotsLinearLayout;

    @JvmOverloads
    public WormDotsIndicator(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.strokeDotsLinearLayout = new LinearLayout(context);
        FrameLayout.LayoutParams linearParams = new FrameLayout.LayoutParams(-2, -2);
        int horizontalPadding = this.dpToPx(24);
        this.setPadding(horizontalPadding, 0, horizontalPadding, 0);
        this.setClipToPadding(false);
        this.strokeDotsLinearLayout.setLayoutParams((ViewGroup.LayoutParams)linearParams);
        this.strokeDotsLinearLayout.setOrientation(0);
        this.addView((View)this.strokeDotsLinearLayout);
        this.dotsStrokeWidth = this.dpToPxF(2.0f);
        this.dotsStrokeColor = this.dotIndicatorColor = ExtensionsKt.getThemePrimaryColor(context);
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.WormDotsIndicator);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"getContext().obtainStyle\u2026leable.WormDotsIndicator)");
            TypedArray a = typedArray;
            this.dotIndicatorColor = a.getColor(R.styleable.WormDotsIndicator_dotsColor, this.dotIndicatorColor);
            this.dotsStrokeColor = a.getColor(R.styleable.WormDotsIndicator_dotsStrokeColor, this.dotIndicatorColor);
            this.dotsStrokeWidth = a.getDimension(R.styleable.WormDotsIndicator_dotsStrokeWidth, this.dotsStrokeWidth);
            a.recycle();
        }
        if (this.isInEditMode()) {
            this.addDots(5);
            this.addView((View)this.buildDot(false));
        }
        this.setUpDotIndicator();
    }

    public /* synthetic */ WormDotsIndicator(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final void setUpDotIndicator() {
        BaseDotsIndicator.Pager pager = this.getPager();
        boolean bl = pager != null ? pager.isEmpty() : false;
        if (bl) {
            return;
        }
        if (this.dotIndicatorView != null && this.indexOfChild((View)this.dotIndicatorView) != -1) {
            this.removeView((View)this.dotIndicatorView);
        }
        View view = this.dotIndicatorLayout = (View)this.buildDot(false);
        Intrinsics.checkNotNull((Object)view);
        this.dotIndicatorView = (ImageView)view.findViewById(R.id.worm_dot);
        this.addView(this.dotIndicatorLayout);
        this.dotIndicatorXSpring = new SpringAnimation((Object)this.dotIndicatorLayout, (FloatPropertyCompat)SpringAnimation.TRANSLATION_X);
        SpringForce springForceX = new SpringForce(0.0f);
        springForceX.setDampingRatio(1.0f);
        springForceX.setStiffness(300.0f);
        SpringAnimation springAnimation = this.dotIndicatorXSpring;
        Intrinsics.checkNotNull((Object)springAnimation);
        springAnimation.setSpring(springForceX);
        FloatPropertyCompat<View> floatPropertyCompat2 = new FloatPropertyCompat<View>(this){
            final /* synthetic */ WormDotsIndicator this$0;
            {
                this.this$0 = $receiver;
                super("DotsWidth");
            }

            public float getValue(@NotNull View object) {
                Intrinsics.checkNotNullParameter((Object)object, (String)"object");
                ImageView imageView = WormDotsIndicator.access$getDotIndicatorView$p(this.this$0);
                Intrinsics.checkNotNull((Object)imageView);
                return imageView.getLayoutParams().width;
            }

            public void setValue(@NotNull View object, float value) {
                Intrinsics.checkNotNullParameter((Object)object, (String)"object");
                ImageView imageView = WormDotsIndicator.access$getDotIndicatorView$p(this.this$0);
                Intrinsics.checkNotNull((Object)imageView);
                ViewGroup.LayoutParams params = imageView.getLayoutParams();
                params.width = (int)value;
                ImageView imageView2 = WormDotsIndicator.access$getDotIndicatorView$p(this.this$0);
                Intrinsics.checkNotNull((Object)imageView2);
                imageView2.requestLayout();
            }
        };
        this.dotIndicatorWidthSpring = new SpringAnimation((Object)this.dotIndicatorLayout, (FloatPropertyCompat)floatPropertyCompat2);
        SpringForce springForceWidth = new SpringForce(0.0f);
        springForceWidth.setDampingRatio(1.0f);
        springForceWidth.setStiffness(300.0f);
        SpringAnimation springAnimation2 = this.dotIndicatorWidthSpring;
        Intrinsics.checkNotNull((Object)springAnimation2);
        springAnimation2.setSpring(springForceWidth);
    }

    @Override
    public void addDot(int index) {
        ViewGroup dot = this.buildDot(true);
        dot.setOnClickListener(arg_0 -> WormDotsIndicator.addDot$lambda-0(this, index, arg_0));
        View view = dot.findViewById(R.id.worm_dot);
        if (view == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.widget.ImageView");
        }
        this.dots.add((ImageView)view);
        this.strokeDotsLinearLayout.addView((View)dot);
    }

    private final ViewGroup buildDot(boolean stroke) {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.worm_dot_layout, (ViewGroup)this, false);
        if (view == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        ViewGroup dot = (ViewGroup)view;
        if (Build.VERSION.SDK_INT >= 17) {
            dot.setLayoutDirection(0);
        }
        View dotImageView = dot.findViewById(R.id.worm_dot);
        dotImageView.setBackgroundResource(stroke ? R.drawable.worm_dot_stroke_background : R.drawable.worm_dot_background);
        ViewGroup.LayoutParams layoutParams = dotImageView.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
        }
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)layoutParams;
        params.width = params.height = (int)this.getDotsSize();
        params.addRule(15, -1);
        params.setMargins((int)this.getDotsSpacing(), 0, (int)this.getDotsSpacing(), 0);
        Intrinsics.checkNotNullExpressionValue((Object)dotImageView, (String)"dotImageView");
        this.setUpDotBackground(stroke, dotImageView);
        return dot;
    }

    private final void setUpDotBackground(boolean stroke, View dotImageView) {
        Drawable drawable2 = dotImageView.getBackground();
        if (drawable2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.GradientDrawable");
        }
        GradientDrawable dotBackground = (GradientDrawable)drawable2;
        if (stroke) {
            dotBackground.setStroke((int)this.dotsStrokeWidth, this.dotsStrokeColor);
        } else {
            dotBackground.setColor(this.dotIndicatorColor);
        }
        dotBackground.setCornerRadius(this.getDotsCornerRadius());
    }

    @Override
    public void refreshDotColor(int index) {
        Object e = this.dots.get(index);
        Intrinsics.checkNotNullExpressionValue(e, (String)"dots[index]");
        this.setUpDotBackground(true, (View)e);
    }

    @Override
    public void removeDot() {
        this.strokeDotsLinearLayout.removeViewAt(this.strokeDotsLinearLayout.getChildCount() - 1);
        this.dots.remove(this.dots.size() - 1);
    }

    @Override
    @NotNull
    public OnPageChangeListenerHelper buildOnPageChangedListener() {
        return new OnPageChangeListenerHelper(this){
            final /* synthetic */ WormDotsIndicator this$0;
            {
                this.this$0 = $receiver;
            }

            public int getPageCount$viewpagerdotsindicator_debug() {
                return this.this$0.dots.size();
            }

            public void onPageScrolled$viewpagerdotsindicator_debug(int selectedPosition, int nextPosition, float positionOffset) {
                block7: {
                    ViewParent viewParent = ((ImageView)this.this$0.dots.get(selectedPosition)).getParent();
                    if (viewParent == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
                    }
                    float x = ((ViewGroup)viewParent).getLeft();
                    ViewParent viewParent2 = ((ImageView)this.this$0.dots.get(nextPosition == -1 ? selectedPosition : nextPosition)).getParent();
                    if (viewParent2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
                    }
                    float nextX = ((ViewGroup)viewParent2).getLeft();
                    float xFinalPosition = 0.0f;
                    float widthFinalPosition = 0.0f;
                    float f = positionOffset;
                    boolean bl = 0.0f <= f ? f <= 0.1f : false;
                    if (bl) {
                        xFinalPosition = x;
                        widthFinalPosition = this.this$0.getDotsSize();
                    } else {
                        boolean bl2 = 0.1f <= f ? f <= 0.9f : false;
                        if (bl2) {
                            xFinalPosition = x;
                            widthFinalPosition = nextX - x + this.this$0.getDotsSize();
                        } else {
                            xFinalPosition = nextX;
                            widthFinalPosition = this.this$0.getDotsSize();
                        }
                    }
                    SpringAnimation springAnimation = WormDotsIndicator.access$getDotIndicatorXSpring$p(this.this$0);
                    if (springAnimation != null) {
                        springAnimation.animateToFinalPosition(xFinalPosition);
                    }
                    SpringAnimation springAnimation2 = WormDotsIndicator.access$getDotIndicatorWidthSpring$p(this.this$0);
                    if (springAnimation2 == null) break block7;
                    springAnimation2.animateToFinalPosition(widthFinalPosition);
                }
            }

            public void resetPosition$viewpagerdotsindicator_debug(int position) {
            }
        };
    }

    @Override
    @NotNull
    public BaseDotsIndicator.Type getType() {
        return BaseDotsIndicator.Type.WORM;
    }

    public final void setDotIndicatorColor(int color) {
        if (this.dotIndicatorView != null) {
            this.dotIndicatorColor = color;
            ImageView imageView = this.dotIndicatorView;
            Intrinsics.checkNotNull((Object)imageView);
            this.setUpDotBackground(false, (View)imageView);
        }
    }

    public final void setStrokeDotsIndicatorColor(int color) {
        this.dotsStrokeColor = color;
        for (ImageView v : this.dots) {
            Intrinsics.checkNotNullExpressionValue((Object)v, (String)"v");
            this.setUpDotBackground(true, (View)v);
        }
    }

    public final void setDotsStrokeWidth(float width) {
        this.dotsStrokeWidth = width;
        for (ImageView v : this.dots) {
            Intrinsics.checkNotNullExpressionValue((Object)v, (String)"v");
            this.setUpDotBackground(true, (View)v);
        }
    }

    @JvmOverloads
    public WormDotsIndicator(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public WormDotsIndicator(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void addDot$lambda-0(WormDotsIndicator this$0, int $index, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.getDotsClickable()) {
            BaseDotsIndicator.Pager pager = this$0.getPager();
            if ($index < (pager != null ? pager.getCount() : 0)) {
                BaseDotsIndicator.Pager pager2 = this$0.getPager();
                Intrinsics.checkNotNull((Object)pager2);
                pager2.setCurrentItem($index, true);
            }
        }
    }

    public static final /* synthetic */ ImageView access$getDotIndicatorView$p(WormDotsIndicator $this) {
        return $this.dotIndicatorView;
    }

    public static final /* synthetic */ SpringAnimation access$getDotIndicatorXSpring$p(WormDotsIndicator $this) {
        return $this.dotIndicatorXSpring;
    }

    public static final /* synthetic */ SpringAnimation access$getDotIndicatorWidthSpring$p(WormDotsIndicator $this) {
        return $this.dotIndicatorWidthSpring;
    }
}

