/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.jetty.http;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.constant.NetworkSchemeType;
import com.tcdng.unify.web.http.AbstractEmbeddedHttpWebServer;
import com.tcdng.unify.web.http.HttpApplicationServlet;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

@Component(value="jetty-embeddedwebserver")
public class JettyEmbeddedWebServer
extends AbstractEmbeddedHttpWebServer {
    private Server httpServer;
    private NetworkSchemeType networkSchemeType = NetworkSchemeType.HTTP;

    public String getScheme() {
        return this.networkSchemeType.code();
    }

    public int getPort() throws UnifyException {
        return this.getHttpPort();
    }

    protected void onInitialize() throws UnifyException {
        try {
            this.logInfo("Initializing HTTP server on port {0}; using context path {1} and servlet path {2}...", new Object[]{Integer.toString(this.getHttpPort()), this.getContextPath(), this.getServletPath()});
            this.httpServer = new Server(this.getHttpPort());
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath(this.getContextPath());
            context.getSessionHandler().setMaxInactiveInterval(((Integer)this.getContainerSetting(Integer.TYPE, "application.session.timeout", 600)).intValue());
            this.httpServer.setHandler((Handler)context);
            ServletHolder mainHolder = new ServletHolder((Servlet)new HttpApplicationServlet(this.createHttpServletModule()));
            mainHolder.getRegistration().setMultipartConfig(new MultipartConfigElement(this.getMultipartLocation(), this.getMultipartMaxFileSize(), this.getMultipartMaxRequestSize(), this.getMultipartFileSizeThreshold()));
            context.addServlet(mainHolder, this.getServletPath());
            this.httpServer.start();
            this.logInfo("HTTP server initialization completed.", new Object[0]);
        }
        catch (Exception e) {
            throw new UnifyException((Throwable)e, "UC_0007", new Object[]{this.getName()});
        }
    }

    protected void onTerminate() throws UnifyException {
        try {
            this.httpServer.stop();
        }
        catch (Exception e) {
            throw new UnifyException((Throwable)e, "UC_0079", new Object[]{this.getName()});
        }
    }

    protected void onStartServicingRequests() throws UnifyException {
    }

    protected void onStopServicingRequests() throws UnifyException {
    }
}

