/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.http;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.web.http.HttpRequest;
import com.tcdng.unify.web.http.HttpRequestImpl;
import com.tcdng.unify.web.http.HttpRequestMethodType;
import com.tcdng.unify.web.http.HttpResponse;
import com.tcdng.unify.web.http.HttpResponseImpl;
import com.tcdng.unify.web.http.HttpServletModule;
import com.tcdng.unify.web.http.util.HttpWebTypeUtils;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@MultipartConfig
public class HttpApplicationServlet
extends HttpServlet {
    private static final long serialVersionUID = 3971544226497014269L;
    private HttpServletModule httpModule;

    public HttpApplicationServlet() {
        this(false);
    }

    public HttpApplicationServlet(boolean embedded) {
        this.httpModule = new HttpServletModule(embedded);
    }

    public HttpApplicationServlet(HttpServletModule httpModule) {
        this.httpModule = httpModule;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!this.httpModule.isEmbedded()) {
            ServletContext servletContext = config.getServletContext();
            String workingFolder = servletContext.getRealPath("");
            String configFilename = config.getInitParameter("application-config-file");
            try {
                this.httpModule.init(servletContext.getContextPath(), workingFolder, configFilename, HttpWebTypeUtils.getTypeRepositoryFromServletContext(servletContext));
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    public void destroy() {
        this.httpModule.destroy();
        super.destroy();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequestMethod(HttpRequestMethodType.GET, request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequestMethod(HttpRequestMethodType.POST, request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequestMethod(HttpRequestMethodType.DELETE, request, response);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequestMethod(HttpRequestMethodType.HEAD, request, response);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequestMethod(HttpRequestMethodType.OPTIONS, request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequestMethod(HttpRequestMethodType.PUT, request, response);
    }

    protected void doTrace(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequestMethod(HttpRequestMethodType.TRACE, request, response);
    }

    private void doRequestMethod(HttpRequestMethodType type, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            this.httpModule.handleRequest(type, (HttpRequest)new HttpRequestImpl(request), (HttpResponse)new HttpResponseImpl(response));
        }
        catch (UnifyException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

