/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.http;

import com.tcdng.unify.web.ClientCookie;
import com.tcdng.unify.web.http.HttpPart;
import com.tcdng.unify.web.http.HttpPartImpl;
import com.tcdng.unify.web.http.HttpRequest;
import com.tcdng.unify.web.http.HttpUserSession;
import com.tcdng.unify.web.http.HttpUserSessionImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;

public class HttpRequestImpl
implements HttpRequest {
    private HttpServletRequest request;

    public HttpRequestImpl(HttpServletRequest request) {
        this.request = request;
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public String getHeader(String headerName) {
        return this.request.getHeader(headerName);
    }

    public String getParameter(String paramName) {
        return this.request.getParameter(paramName);
    }

    public BufferedReader getReader() throws IOException {
        return this.request.getReader();
    }

    public InputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public Map<String, String[]> getParameterMap() {
        return this.request.getParameterMap();
    }

    public Collection<HttpPart> getParts() throws Exception {
        ArrayList<HttpPart> partList = new ArrayList<HttpPart>();
        for (Part part : this.request.getParts()) {
            partList.add(new HttpPartImpl(part));
        }
        return partList;
    }

    public List<ClientCookie> getCookies() {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null && cookies.length > 0) {
            ArrayList<ClientCookie> list = new ArrayList<ClientCookie>();
            for (Cookie cookie : cookies) {
                list.add(new ClientCookie(cookie.getDomain(), cookie.getPath(), cookie.getName(), cookie.getValue(), cookie.getMaxAge()));
            }
            return list;
        }
        return Collections.emptyList();
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public String getServletPath() {
        return this.request.getServletPath();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public HttpUserSession createHttpUserSession(Locale locale, TimeZone timeZone, String sessionId, String uriBase, String contextPath, String tenantPath, String remoteIpAddress) {
        return new HttpUserSessionImpl(locale, timeZone, sessionId, uriBase.toString(), contextPath, tenantPath, this.request.getRemoteHost(), remoteIpAddress, this.request.getRemoteUser());
    }

    public void invalidateSession() {
        HttpSession httpSession = this.request.getSession(false);
        if (httpSession != null) {
            httpSession.invalidate();
        }
    }

    public void setSessionAttribute(String name, Object val) {
        this.request.getSession().setAttribute(name, val);
    }

    public Object getSessionAttribute(String name) {
        return this.request.getSession().getAttribute(name);
    }

    public void removeSessionAttribute(String name) {
        this.request.getSession().removeAttribute(name);
    }

    public Object getSessionSychObject() {
        return this.request.getSession();
    }
}

