/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.http;

import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.http.HttpResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class HttpResponseImpl
implements HttpResponse {
    private HttpServletResponse response;

    public HttpResponseImpl(HttpServletResponse response) {
        this.response = response;
    }

    public void setHeader(String key, String val) {
        this.response.setHeader(key, val);
    }

    public void setContentType(String contentType) {
        this.response.setContentType(contentType);
    }

    public void setCharacterEncoding(String charset) {
        this.response.setCharacterEncoding(charset);
    }

    public OutputStream getOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    public Writer getWriter() throws IOException {
        return this.response.getWriter();
    }

    public void setStatus(int status) {
        this.response.setStatus(status);
    }

    public void setStatusOk() {
        this.response.setStatus(200);
    }

    public void setStatusForbidden() {
        this.response.setStatus(403);
    }

    public void setCookie(String name, String val) {
        Cookie cookie = new Cookie(name, val);
        this.response.addCookie(cookie);
    }

    public void setCookie(String name, String val, int maxAge) {
        Cookie cookie = new Cookie(name, val);
        if (maxAge >= 0) {
            cookie.setMaxAge(maxAge);
        }
        this.response.addCookie(cookie);
    }

    public void setCookie(String domain, String path, String name, String val, int maxAge) {
        Cookie cookie = new Cookie(name, val);
        if (!StringUtils.isBlank((String)domain)) {
            cookie.setDomain(domain);
        }
        if (!StringUtils.isBlank((String)path)) {
            cookie.setPath(path);
        }
        if (maxAge >= 0) {
            cookie.setMaxAge(maxAge);
        }
        this.response.addCookie(cookie);
    }
}

