/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.http.util;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.util.TypeRepository;
import com.tcdng.unify.core.util.TypeUtils;
import java.net.URL;
import javax.servlet.ServletContext;
import org.scannotation.AnnotationDB;
import org.scannotation.WarUrlFinder;

public class HttpWebTypeUtils
extends TypeUtils {
    private static TypeRepository servletContextTypeRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypeRepository getTypeRepositoryFromServletContext(ServletContext servletContext) throws UnifyException {
        if (servletContextTypeRepository != null) return servletContextTypeRepository;
        Class<HttpWebTypeUtils> clazz = HttpWebTypeUtils.class;
        synchronized (HttpWebTypeUtils.class) {
            if (servletContextTypeRepository != null) return servletContextTypeRepository;
            try {
                AnnotationDB classpathDB = new AnnotationDB();
                classpathDB.setScanFieldAnnotations(false);
                classpathDB.setScanMethodAnnotations(false);
                classpathDB.setScanParameterAnnotations(false);
                URL[] urls = null;
                URL classPathUrl = WarUrlFinder.findWebInfClassesPath((ServletContext)servletContext);
                URL[] libUrls = WarUrlFinder.findWebInfLibClasspaths((ServletContext)servletContext);
                if (classPathUrl != null) {
                    urls = new URL[libUrls.length + 1];
                    for (int i = 0; i < libUrls.length; ++i) {
                        urls[i] = libUrls[i];
                    }
                    urls[i] = classPathUrl;
                } else {
                    urls = libUrls;
                }
                classpathDB.scanArchives(urls);
                servletContextTypeRepository = new TypeUtils.TypeRepositoryImpl(classpathDB);
            }
            catch (Exception e) {
                throw new UnifyException((Throwable)e, "UC_0039", new Object[0]);
            }
            return servletContextTypeRepository;
        }
    }
}

