/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.UplBinding;
import com.tcdng.unify.core.constant.DataType;
import com.tcdng.unify.core.constant.Gender;
import com.tcdng.unify.core.data.MapValues;
import com.tcdng.unify.core.data.PackableDoc;
import com.tcdng.unify.core.data.PackableDocConfig;
import com.tcdng.unify.web.Author;
import com.tcdng.unify.web.annotation.Action;
import com.tcdng.unify.web.annotation.ResultMapping;
import com.tcdng.unify.web.annotation.ResultMappings;
import com.tcdng.unify.web.ui.AbstractPageController;
import com.tcdng.unify.web.ui.AuthorPageBean;
import java.util.HashMap;
import java.util.Map;

@Component(value="/testauthor")
@UplBinding(value="web/test/upl/testauthor.upl")
@ResultMappings(value={@ResultMapping(name="resultMappingA", response={"!postresponse"}), @ResultMapping(name="resultMappingB", response={"!hidepopupresponse"})})
public class AuthorPageController
extends AbstractPageController<AuthorPageBean> {
    private Map<String, Author> authorDatabase;

    public AuthorPageController() {
        super(AuthorPageBean.class);
    }

    @Action
    public String createAuthor() throws UnifyException {
        AuthorPageBean authorPageBean = (AuthorPageBean)this.getPageBean();
        this.authorDatabase.put(authorPageBean.getFullName(), new Author(authorPageBean.getFullName(), authorPageBean.getBirthDt(), authorPageBean.getHeight()));
        return this.noResult();
    }

    @Action
    public String viewAuthor() throws UnifyException {
        AuthorPageBean authorPageBean = (AuthorPageBean)this.getPageBean();
        Author author = this.authorDatabase.get(authorPageBean.getFullName());
        authorPageBean.setBirthDt(author.getBirthDt());
        authorPageBean.setHeight(author.getHeight());
        return this.noResult();
    }

    @Action
    public String newAuthor() throws UnifyException {
        this.reset();
        return this.noResult();
    }

    protected void onInitPage() throws UnifyException {
        AuthorPageBean authorPageBean = (AuthorPageBean)this.getPageBean();
        this.authorDatabase = new HashMap<String, Author>();
        MapValues bio = new MapValues();
        bio.addValue("color", String.class);
        bio.addValue("age", Integer.class);
        bio.addValue("gender", Gender.class);
        PackableDocConfig docConfig = PackableDocConfig.newBuilder((String)"ledgerConfig").addFieldConfig("marker", DataType.STRING).addFieldConfig("height", DataType.DOUBLE).build();
        PackableDoc pDoc = new PackableDoc(docConfig, false);
        bio.addValue("metric", PackableDoc.class, (Object)pDoc);
        authorPageBean.setBio(bio);
    }
}

