/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui;

import com.tcdng.unify.web.AbstractUnifyWebTest;
import com.tcdng.unify.web.ClientRequest;
import com.tcdng.unify.web.ClientResponse;
import com.tcdng.unify.web.ControllerFinder;
import com.tcdng.unify.web.PathInfoRepository;
import com.tcdng.unify.web.RequestPathParts;
import com.tcdng.unify.web.TestClientRequest;
import com.tcdng.unify.web.TestClientResponse;
import com.tcdng.unify.web.ui.AuthorPageBean;
import com.tcdng.unify.web.ui.AuthorPageController;
import com.tcdng.unify.web.ui.UIControllerUtil;
import com.tcdng.unify.web.ui.widget.Widget;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class PageControllerTest
extends AbstractUnifyWebTest {
    @Test
    public void testPopulateControllerProperty() throws Exception {
        ControllerFinder controllerFinder = (ControllerFinder)this.getComponent("application-controllerfinder");
        UIControllerUtil uicu = (UIControllerUtil)this.getComponent("application-uicontrollerutil");
        PathInfoRepository pathInfoRepository = (PathInfoRepository)this.getComponent("application-pathinforepository");
        AuthorPageController controller = (AuthorPageController)controllerFinder.findController(pathInfoRepository.getControllerPathParts("/testauthor"));
        Date birthDt = new Date();
        uicu.populatePageBean("/testauthor", "fullName", (Object)"Adrian Skim");
        uicu.populatePageBean("/testauthor", "birthDt", (Object)birthDt);
        uicu.populatePageBean("/testauthor", "height", (Object)25.34);
        AuthorPageBean authorPageBean = (AuthorPageBean)controller.getPage().getPageBean();
        Assert.assertEquals((Object)"Adrian Skim", (Object)authorPageBean.getFullName());
        Assert.assertEquals((Object)birthDt, (Object)authorPageBean.getBirthDt());
        Assert.assertEquals((Object)25.34, (Object)authorPageBean.getHeight());
    }

    @Test
    public void testExecutePageController() throws Exception {
        ControllerFinder controllerFinder = (ControllerFinder)this.getComponent("application-controllerfinder");
        PathInfoRepository pir = (PathInfoRepository)this.getComponent("application-pathinforepository");
        TestClientResponse response = new TestClientResponse();
        TestClientRequest request = new TestClientRequest(new RequestPathParts(pir.getControllerPathParts("/testauthor/createAuthor")));
        Date birthDt = new Date();
        AuthorPageController controller = (AuthorPageController)controllerFinder.findController(pir.getControllerPathParts("/testauthor"));
        Widget uic1 = (Widget)controller.getPageWidgetByLongName(Widget.class, "/testauthor.fullName");
        Widget uic2 = (Widget)controller.getPageWidgetByLongName(Widget.class, "/testauthor.birthDt");
        Widget uic3 = (Widget)controller.getPageWidgetByLongName(Widget.class, "/testauthor.height");
        request.setParameter(uic1.getId(), (Object)"Tom Jones");
        request.setParameter(uic2.getId(), (Object)birthDt);
        request.setParameter(uic3.getId(), (Object)"24.22");
        controller.process((ClientRequest)request, (ClientResponse)response);
        AuthorPageBean authorPageBean = (AuthorPageBean)controller.getPage().getPageBean();
        Assert.assertEquals((Object)"Tom Jones", (Object)authorPageBean.getFullName());
        Assert.assertEquals((Object)birthDt, (Object)authorPageBean.getBirthDt());
        Assert.assertEquals((Object)24.22, (Object)authorPageBean.getHeight());
        Assert.assertEquals((Object)"{\"jsonResp\":[{\"handler\":\"hintUserHdl\"},{\"handler\":\"refreshMenuHdl\"}],\"scrollReset\":false}", (Object)response.toString());
    }

    protected void onSetup() throws Exception {
    }

    protected void onTearDown() throws Exception {
    }
}

