/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui;

import com.tcdng.unify.web.AbstractUnifyWebTest;
import com.tcdng.unify.web.ui.widget.Container;
import com.tcdng.unify.web.ui.widget.DocumentLayout;
import com.tcdng.unify.web.ui.widget.Page;
import com.tcdng.unify.web.ui.widget.PageManager;
import com.tcdng.unify.web.ui.widget.Panel;
import com.tcdng.unify.web.ui.widget.Widget;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class PageManagerTest
extends AbstractUnifyWebTest {
    @Test
    public void testCreatePage() throws Exception {
        PageManager pageManager = (PageManager)this.getComponent("application-pagemanager");
        Page page = pageManager.createPage(Locale.getDefault(), "/testauthor");
        Assert.assertNotNull((Object)page);
    }

    @Test
    public void testPageAttributes() throws Exception {
        PageManager pageManager = (PageManager)this.getComponent("application-pagemanager");
        Page page = pageManager.createPage(Locale.getDefault(), "/testauthor");
        DocumentLayout documentLayout = (DocumentLayout)page.getUplAttribute(DocumentLayout.class, "layout");
        Assert.assertNotNull((Object)documentLayout);
        Assert.assertEquals((Object)"ui-desktoptype0", (Object)documentLayout.getName());
    }

    @Test
    public void testPageReferencesByLongName() throws Exception {
        PageManager pageManager = (PageManager)this.getComponent("application-pagemanager");
        Page page = pageManager.createPage(Locale.getDefault(), "/testauthor");
        Assert.assertEquals((long)11L, (long)page.getWidgetLongNames().size());
        Widget uici = page.getWidgetByLongName("/testauthor.mainPanel");
        Assert.assertEquals((Object)"/testauthor.mainPanel", (Object)uici.getLongName());
        Assert.assertEquals((Object)page.getLongName(), (Object)uici.getParentLongName());
        Assert.assertTrue((boolean)uici.isConforming());
        Assert.assertTrue((boolean)uici.isValueConforming((Container)page));
        Assert.assertFalse((boolean)uici.isFixedConforming());
        uici = page.getWidgetByLongName("/testauthor.fullName");
        Assert.assertEquals((Object)"/testauthor.fullName", (Object)uici.getLongName());
        Assert.assertEquals((Object)page.getLongName(), (Object)uici.getParentLongName());
        Assert.assertTrue((boolean)uici.isConforming());
        Assert.assertFalse((boolean)uici.isValueConforming((Container)page));
        Assert.assertFalse((boolean)uici.isFixedConforming());
        uici = page.getWidgetByLongName("/testauthor.birthDt");
        Assert.assertNotNull((Object)uici);
        Assert.assertEquals((Object)"/testauthor.birthDt", (Object)uici.getLongName());
        Assert.assertEquals((Object)page.getLongName(), (Object)uici.getParentLongName());
        Assert.assertTrue((boolean)uici.isConforming());
        Assert.assertFalse((boolean)uici.isValueConforming((Container)page));
        Assert.assertFalse((boolean)uici.isFixedConforming());
        uici = page.getWidgetByLongName("/testauthor.height");
        Assert.assertNotNull((Object)uici);
        Assert.assertEquals((Object)"/testauthor.height", (Object)uici.getLongName());
        Assert.assertEquals((Object)page.getLongName(), (Object)uici.getParentLongName());
        Assert.assertTrue((boolean)uici.isConforming());
        Assert.assertFalse((boolean)uici.isValueConforming((Container)page));
        Assert.assertFalse((boolean)uici.isFixedConforming());
        Panel panel = (Panel)page.getWidgetByLongName("/testauthor.mainPanel");
        Assert.assertEquals((long)3L, (long)panel.getWidgetLongNames().size());
        uici = panel.getWidgetByLongName("/testauthor.fullName");
        Assert.assertNotNull((Object)uici);
        Assert.assertEquals((Object)"/testauthor.fullName", (Object)uici.getLongName());
        Assert.assertEquals((Object)page.getLongName(), (Object)uici.getParentLongName());
        Assert.assertTrue((boolean)uici.isConforming());
        Assert.assertTrue((boolean)uici.isValueConforming((Container)panel));
        Assert.assertFalse((boolean)uici.isFixedConforming());
        uici = panel.getWidgetByLongName("/testauthor.birthDt");
        Assert.assertNotNull((Object)uici);
        Assert.assertEquals((Object)"/testauthor.birthDt", (Object)uici.getLongName());
        Assert.assertEquals((Object)page.getLongName(), (Object)uici.getParentLongName());
        Assert.assertTrue((boolean)uici.isConforming());
        Assert.assertTrue((boolean)uici.isValueConforming((Container)panel));
        Assert.assertFalse((boolean)uici.isFixedConforming());
        uici = panel.getWidgetByLongName("/testauthor.height");
        Assert.assertNotNull((Object)uici);
        Assert.assertEquals((Object)"/testauthor.height", (Object)uici.getLongName());
        Assert.assertEquals((Object)page.getLongName(), (Object)uici.getParentLongName());
        Assert.assertTrue((boolean)uici.isConforming());
        Assert.assertTrue((boolean)uici.isValueConforming((Container)panel));
        Assert.assertFalse((boolean)uici.isFixedConforming());
    }

    @Test
    public void testPageReferencesByShortName() throws Exception {
        PageManager pageManager = (PageManager)this.getComponent("application-pagemanager");
        Page page = pageManager.createPage(Locale.getDefault(), "/testauthor");
        Widget uic = page.getWidgetByShortName("mainPanel");
        Assert.assertNotNull((Object)uic);
        Assert.assertEquals((Object)"/testauthor.mainPanel", (Object)uic.getLongName());
        uic = page.getWidgetByShortName("fullName");
        Assert.assertNotNull((Object)uic);
        Assert.assertEquals((Object)"/testauthor.fullName", (Object)uic.getLongName());
        uic = page.getWidgetByShortName("birthDt");
        Assert.assertNotNull((Object)uic);
        Assert.assertEquals((Object)"/testauthor.birthDt", (Object)uic.getLongName());
        uic = page.getWidgetByShortName("height");
        Assert.assertNotNull((Object)uic);
        Assert.assertEquals((Object)"/testauthor.height", (Object)uic.getLongName());
        Panel panel = (Panel)page.getWidgetByShortName("mainPanel");
        uic = panel.getWidgetByShortName("fullName");
        Assert.assertNotNull((Object)uic);
        Assert.assertEquals((Object)"/testauthor.fullName", (Object)uic.getLongName());
        uic = panel.getWidgetByShortName("birthDt");
        Assert.assertNotNull((Object)uic);
        Assert.assertEquals((Object)"/testauthor.birthDt", (Object)uic.getLongName());
        uic = panel.getWidgetByShortName("height");
        Assert.assertNotNull((Object)uic);
        Assert.assertEquals((Object)"/testauthor.height", (Object)uic.getLongName());
    }

    @Test
    public void testPageGetPanel() throws Exception {
        PageManager pageManager = (PageManager)this.getComponent("application-pagemanager");
        Page page = pageManager.createPage(Locale.getDefault(), "/testauthor");
        Panel panel1 = page.getPanelByLongName("/testauthor.mainPanel");
        Assert.assertEquals((Object)"/testauthor.mainPanel", (Object)panel1.getLongName());
        Panel panel2 = page.getPanelByShortName("mainPanel");
        Assert.assertEquals((Object)"/testauthor.mainPanel", (Object)panel2.getLongName());
        Assert.assertEquals((Object)panel1, (Object)panel2);
    }

    protected void onSetup() throws Exception {
    }

    protected void onTearDown() throws Exception {
    }
}

