/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.web.AbstractUnifyWebTest;
import com.tcdng.unify.web.Action;
import com.tcdng.unify.web.ui.AuthorPageController;
import com.tcdng.unify.web.ui.PageControllerInfo;
import com.tcdng.unify.web.ui.ResourceControllerInfo;
import com.tcdng.unify.web.ui.TechnicalAuthorPageController;
import com.tcdng.unify.web.ui.UIControllerUtil;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class UIControllerUtilTest
extends AbstractUnifyWebTest {
    @Test
    public void testGetPageControllerInfo() throws Exception {
        UIControllerUtil uicu = (UIControllerUtil)this.getComponent("application-uicontrollerutil");
        PageControllerInfo pbbi = uicu.getPageControllerInfo("/testauthor");
        Assert.assertNotNull((Object)pbbi);
    }

    @Test
    public void testPageControllerInfoActions() throws Exception {
        UIControllerUtil uicu = (UIControllerUtil)this.getComponent("application-uicontrollerutil");
        PageControllerInfo pbbi = uicu.getPageControllerInfo("/testauthor");
        Set actionNames = pbbi.getActionNames();
        Assert.assertTrue((boolean)actionNames.contains("/createAuthor"));
        Assert.assertTrue((boolean)actionNames.contains("/viewAuthor"));
        Assert.assertTrue((boolean)actionNames.contains("/newAuthor"));
        Action action = pbbi.getAction("/createAuthor");
        Assert.assertNotNull((Object)action);
        Assert.assertNotNull((Object)action.getMethod());
        Assert.assertEquals(AuthorPageController.class, action.getMethod().getDeclaringClass());
        Assert.assertEquals((Object)"createAuthor", (Object)action.getMethod().getName());
        action = pbbi.getAction("/viewAuthor");
        Assert.assertNotNull((Object)action);
        Assert.assertNotNull((Object)action.getMethod());
        Assert.assertEquals(AuthorPageController.class, action.getMethod().getDeclaringClass());
        Assert.assertEquals((Object)"viewAuthor", (Object)action.getMethod().getName());
        action = pbbi.getAction("/newAuthor");
        Assert.assertNotNull((Object)action);
        Assert.assertNotNull((Object)action.getMethod());
        Assert.assertEquals(AuthorPageController.class, action.getMethod().getDeclaringClass());
        Assert.assertEquals((Object)"newAuthor", (Object)action.getMethod().getName());
    }

    @Test
    public void testPageControllerInfoActionsInheritance() throws Exception {
        UIControllerUtil uicu = (UIControllerUtil)this.getComponent("application-uicontrollerutil");
        PageControllerInfo pbbi = uicu.getPageControllerInfo("/testtechnicalauthor");
        Set actionNames = pbbi.getActionNames();
        Assert.assertTrue((boolean)actionNames.contains("/createAuthor"));
        Assert.assertTrue((boolean)actionNames.contains("/viewAuthor"));
        Assert.assertTrue((boolean)actionNames.contains("/newAuthor"));
        Assert.assertTrue((boolean)actionNames.contains("/printTechnicalSpec"));
        Assert.assertFalse((boolean)actionNames.contains("/drawTechnicalSpec"));
        Action action = pbbi.getAction("/createAuthor");
        Assert.assertNotNull((Object)action);
        Assert.assertNotNull((Object)action.getMethod());
        Assert.assertEquals(AuthorPageController.class, action.getMethod().getDeclaringClass());
        Assert.assertEquals((Object)"createAuthor", (Object)action.getMethod().getName());
        action = pbbi.getAction("/viewAuthor");
        Assert.assertNotNull((Object)action);
        Assert.assertNotNull((Object)action.getMethod());
        Assert.assertEquals(TechnicalAuthorPageController.class, action.getMethod().getDeclaringClass());
        Assert.assertEquals((Object)"viewAuthor", (Object)action.getMethod().getName());
        action = pbbi.getAction("/newAuthor");
        Assert.assertNotNull((Object)action);
        Assert.assertNotNull((Object)action.getMethod());
        Assert.assertEquals(TechnicalAuthorPageController.class, action.getMethod().getDeclaringClass());
        Assert.assertEquals((Object)"newAuthor", (Object)action.getMethod().getName());
        action = pbbi.getAction("/printTechnicalSpec");
        Assert.assertNotNull((Object)action);
        Assert.assertNotNull((Object)action.getMethod());
        Assert.assertEquals(TechnicalAuthorPageController.class, action.getMethod().getDeclaringClass());
        Assert.assertEquals((Object)"printTechnicalSpec", (Object)action.getMethod().getName());
    }

    @Test(expected=UnifyException.class)
    public void testGetPageControllerInfoInvalid() throws Exception {
        UIControllerUtil uicu = (UIControllerUtil)this.getComponent("application-uicontrollerutil");
        uicu.getPageControllerInfo("/resource/mock");
    }

    @Test
    public void testGetResourceControllerInfo() throws Exception {
        UIControllerUtil uicu = (UIControllerUtil)this.getComponent("application-uicontrollerutil");
        ResourceControllerInfo rbbi = uicu.getResourceControllerInfo("/resource/mock");
        Assert.assertNotNull((Object)rbbi);
    }

    @Test
    public void testResourceControllerInfoActions() throws Exception {
        UIControllerUtil uicu = (UIControllerUtil)this.getComponent("application-uicontrollerutil");
        ResourceControllerInfo rbbi = uicu.getResourceControllerInfo("/resource/mock");
        Set pageNames = rbbi.getPropertyIds();
        Assert.assertNotNull((Object)pageNames);
        Assert.assertEquals((long)6L, (long)pageNames.size());
        HashSet<String> properties = new HashSet<String>();
        for (String pageName : pageNames) {
            properties.add(rbbi.getPropertyInfo(pageName).getProperty());
        }
        Assert.assertEquals((long)6L, (long)properties.size());
        Assert.assertTrue((boolean)properties.contains("resourceName"));
        Assert.assertTrue((boolean)properties.contains("contentType"));
        Assert.assertTrue((boolean)properties.contains("attachment"));
        Assert.assertTrue((boolean)properties.contains("morsic"));
        Assert.assertTrue((boolean)properties.contains("accountNo"));
        Assert.assertTrue((boolean)properties.contains("balance"));
    }

    @Test(expected=UnifyException.class)
    public void testGetResourceControllerInfoInvalid() throws Exception {
        UIControllerUtil uicu = (UIControllerUtil)this.getComponent("application-uicontrollerutil");
        uicu.getResourceControllerInfo("/testauthor");
    }

    protected void onSetup() throws Exception {
    }

    protected void onTearDown() throws Exception {
    }
}

