/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.ui.AbstractPageControllerResponse;
import com.tcdng.unify.web.ui.PageRequestContextUtil;
import com.tcdng.unify.web.ui.widget.Page;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import java.util.Collection;
import java.util.List;

public abstract class AbstractJsonPageControllerResponse
extends AbstractPageControllerResponse {
    private String handlerName;
    private boolean processSaveList;

    public AbstractJsonPageControllerResponse(String handlerName, boolean processSaveList) {
        this.handlerName = handlerName;
        this.processSaveList = processSaveList;
    }

    @Override
    public void generate(ResponseWriter writer, Page page) throws UnifyException {
        List<String> saveList;
        writer.write("{\"handler\":\"").write(this.handlerName).write("\"");
        PageRequestContextUtil reqUtils = this.getRequestContextUtil();
        this.doGenerate(writer, page);
        if (reqUtils.isFocusOnWidgetOrDefault()) {
            writer.write(",\"focusOnWidget\":\"").write(reqUtils.getFocusOnWidgetIdOrDefault()).write("\"");
            reqUtils.clearFocusOnWidget();
        }
        if (this.processSaveList && DataUtils.isNotBlank(saveList = reqUtils.getOnSaveContentWidgets())) {
            writer.write(",\"pSaveList\":").writeJsonArray(saveList);
            reqUtils.clearOnSaveContentWidgets();
        }
        writer.write("}");
    }

    protected void appendRegisteredDebounceWidgets(ResponseWriter writer, boolean clear) throws UnifyException {
        Collection<String> widgetIds = this.getRequestContextUtil().getAndClearRegisteredDebounceWidgetIds();
        if (!DataUtils.isBlank(widgetIds)) {
            writer.write(",\"debounceClear\":").write(clear);
            writer.write(",\"debounceList\":").writeJsonArray(widgetIds);
        }
    }

    protected String getTimestampedResourceName(String resourceName) throws UnifyException {
        int index = resourceName.indexOf(46);
        if (index > 0) {
            return StringUtils.underscore((String)resourceName.substring(0, index)) + "_" + this.getFormatHelper().formatNow("yyyyMMdd_HHmmss") + resourceName.substring(index);
        }
        return StringUtils.underscore((String)resourceName) + "_" + this.getFormatHelper().formatNow("yyyyMMdd_HHmmss");
    }

    protected abstract void doGenerate(ResponseWriter var1, Page var2) throws UnifyException;
}

