/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.web.data.WebStringWriter;
import com.tcdng.unify.web.ui.AbstractJsonPageControllerResponse;
import com.tcdng.unify.web.ui.widget.Page;
import com.tcdng.unify.web.ui.widget.ResponseWriter;

public abstract class AbstractOpenWindowPageControllerResponse
extends AbstractJsonPageControllerResponse {
    public AbstractOpenWindowPageControllerResponse() {
        super("openWindowHdl", false);
    }

    @Override
    protected void doGenerate(ResponseWriter writer, Page page) throws UnifyException {
        WindowResourceInfo windowResourceInfo = this.prepareWindowResource();
        this.setSessionAttribute(windowResourceInfo.getResourceName(), windowResourceInfo.getResourceObject());
        writer.write(",\"openWindow\":");
        writer.useSecondary(128);
        writer.writeContextResourceURL(windowResourceInfo.resourcePath, windowResourceInfo.getContentType(), windowResourceInfo.getResourceName(), null, windowResourceInfo.isDownload(), false);
        WebStringWriter urlLsw = writer.discardSecondary();
        writer.writeJsonQuote(urlLsw);
        writer.write(",\"attachment\":").write(windowResourceInfo.isDownload());
    }

    protected abstract WindowResourceInfo prepareWindowResource() throws UnifyException;

    protected class WindowResourceInfo {
        private Object resourceObject;
        private String resourcePath;
        private String resourceName;
        private String contentType;
        private boolean download;

        public WindowResourceInfo(Object resourceObject, String resourcePath, String resourceName, String contentType, boolean download) {
            this.resourceObject = resourceObject;
            this.resourcePath = resourcePath;
            this.resourceName = resourceName;
            this.contentType = contentType;
            this.download = download;
        }

        public Object getResourceObject() {
            return this.resourceObject;
        }

        public String getResourcePath() {
            return this.resourcePath;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public String getContentType() {
            return this.contentType;
        }

        public boolean isDownload() {
            return this.download;
        }
    }
}

