/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui;

import com.tcdng.unify.core.SessionContext;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Configurable;
import com.tcdng.unify.core.annotation.Singleton;
import com.tcdng.unify.core.data.DownloadFile;
import com.tcdng.unify.core.task.TaskLauncher;
import com.tcdng.unify.core.task.TaskMonitor;
import com.tcdng.unify.core.task.TaskSetup;
import com.tcdng.unify.core.upl.UplElementReferences;
import com.tcdng.unify.core.util.ReflectUtils;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.ClientRequest;
import com.tcdng.unify.web.ClientResponse;
import com.tcdng.unify.web.ControllerPathParts;
import com.tcdng.unify.web.annotation.Action;
import com.tcdng.unify.web.constant.ClosePageMode;
import com.tcdng.unify.web.constant.ReadOnly;
import com.tcdng.unify.web.constant.ResetOnWrite;
import com.tcdng.unify.web.constant.Secured;
import com.tcdng.unify.web.ui.AbstractUIController;
import com.tcdng.unify.web.ui.DataTransfer;
import com.tcdng.unify.web.ui.DataTransferBlock;
import com.tcdng.unify.web.ui.PageBean;
import com.tcdng.unify.web.ui.PageController;
import com.tcdng.unify.web.ui.PageControllerInfo;
import com.tcdng.unify.web.ui.PagePathInfo;
import com.tcdng.unify.web.ui.PagePathInfoRepository;
import com.tcdng.unify.web.ui.PageRequestContextUtil;
import com.tcdng.unify.web.ui.RequestCommand;
import com.tcdng.unify.web.ui.Result;
import com.tcdng.unify.web.ui.UIControllerUtil;
import com.tcdng.unify.web.ui.VoidPageBean;
import com.tcdng.unify.web.ui.widget.ContentPanel;
import com.tcdng.unify.web.ui.widget.DataTransferWidget;
import com.tcdng.unify.web.ui.widget.Document;
import com.tcdng.unify.web.ui.widget.Page;
import com.tcdng.unify.web.ui.widget.PageAction;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.WidgetCommandManager;
import com.tcdng.unify.web.ui.widget.WidgetContainer;
import com.tcdng.unify.web.ui.widget.data.Hint;
import com.tcdng.unify.web.ui.widget.data.MessageBox;
import com.tcdng.unify.web.ui.widget.data.MessageIcon;
import com.tcdng.unify.web.ui.widget.data.MessageMode;
import com.tcdng.unify.web.ui.widget.data.MessageResult;
import com.tcdng.unify.web.ui.widget.data.TaskMonitorInfo;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;

@Singleton
public abstract class AbstractPageController<T extends PageBean>
extends AbstractUIController
implements PageController<T> {
    @Configurable
    private TaskLauncher taskLauncher;
    @Configurable
    private PagePathInfoRepository pagePathInfoRepository;
    @Configurable
    private WidgetCommandManager uiCommandManager;
    private Class<T> pageBeanClass;

    public AbstractPageController(Class<T> pageBeanClass) {
        this(pageBeanClass, Secured.FALSE, ReadOnly.FALSE, ResetOnWrite.FALSE);
    }

    public AbstractPageController(Class<T> pageBeanClass, Secured secured, ReadOnly readOnly, ResetOnWrite resetOnWrite) {
        super(secured, readOnly, resetOnWrite);
        this.pageBeanClass = pageBeanClass;
    }

    public void setTaskLauncher(TaskLauncher taskLauncher) {
        this.taskLauncher = taskLauncher;
    }

    public void setPagePathInfoRepository(PagePathInfoRepository pagePathInfoRepository) {
        this.pagePathInfoRepository = pagePathInfoRepository;
    }

    public void setUiCommandManager(WidgetCommandManager uiCommandManager) {
        this.uiCommandManager = uiCommandManager;
    }

    public void ensureContextResources(ControllerPathParts controllerPathParts) throws UnifyException {
        SessionContext sessionContext = this.getSessionContext();
        if (sessionContext.getAttribute(controllerPathParts.getControllerPathId()) == null) {
            Page page = this.getPageManager().createPage(sessionContext.getLocale(), controllerPathParts.getControllerName());
            page.setPathParts(controllerPathParts);
            Class<T> pageBeanClass = this.getPageBeanClass();
            if (VoidPageBean.class.equals(pageBeanClass)) {
                page.setPageBean(VoidPageBean.INSTANCE);
            } else {
                page.setPageBean((PageBean)ReflectUtils.newInstance(pageBeanClass));
            }
            this.getPageRequestContextUtil().setRequestPage(page);
            this.initPage();
            sessionContext.setAttribute(controllerPathParts.getControllerPathId(), (Object)page);
        }
    }

    @Override
    public void reset() throws UnifyException {
        this.getPageBean().reset();
    }

    @Override
    public final Class<T> getPageBeanClass() {
        return this.pageBeanClass;
    }

    @Override
    public final Page getPage() throws UnifyException {
        return this.getPageRequestContextUtil().getRequestPage();
    }

    @Override
    public final void initPage() throws UnifyException {
        this.onInitPage();
    }

    @Override
    @Action
    public final String indexPage() throws UnifyException {
        this.onIndexPage();
        return "resrv.index";
    }

    @Override
    @Action
    public final String openPage() throws UnifyException {
        this.onOpenPage();
        if (this.getPageRequestContextUtil().isRemoteViewer()) {
            return "resrv.remoteview";
        }
        return "resrv.open";
    }

    @Override
    @Action
    public final String savePage() throws UnifyException {
        this.onSavePage();
        return "resrv.save";
    }

    @Override
    @Action
    public final String closePage() throws UnifyException {
        this.onClosePage();
        return "resrv.close";
    }

    @Action
    public String noResult() throws UnifyException {
        return "resrv.none";
    }

    @Action
    public String hidePopup() throws UnifyException {
        return "resrv.hidepopup";
    }

    @Action
    public String hidePopupFireConfirm() throws UnifyException {
        return "resrv.hidepopupfireconfirm";
    }

    @Action
    public String command() throws UnifyException {
        RequestCommand requestCommand = this.getPageRequestContextUtil().getRequestCommand();
        if (requestCommand != null) {
            Widget widget = this.getPageRequestContextUtil().getRequestPage().getWidgetByLongName(Widget.class, requestCommand.getParentLongName());
            for (DataTransferBlock childBlock = requestCommand.getTransferBlock().getChildBlock(); childBlock != null; childBlock = childBlock.getChildBlock()) {
                widget = ((WidgetContainer)((Object)widget)).getChildWidget(childBlock.getId());
            }
            if (widget.isRelayCommand()) {
                widget = widget.getRelayWidget();
            }
            this.uiCommandManager.executeCommand(widget, requestCommand.getCommand());
            String commandResultMapping = this.getPageRequestContextUtil().getCommandResultMapping();
            if (StringUtils.isNotBlank((String)commandResultMapping)) {
                return commandResultMapping;
            }
        }
        return "resrv.command";
    }

    @Action
    public String confirm() throws UnifyException {
        PageRequestContextUtil pageRequestContextUtil = this.getPageRequestContextUtil();
        String msg = pageRequestContextUtil.getRequestConfirmMessage();
        String param = pageRequestContextUtil.getRequestConfirmParam();
        if (StringUtils.isNotBlank((String)param)) {
            msg = MessageFormat.format(msg, param);
        }
        return this.showMessageBox(pageRequestContextUtil.getRequestConfirmMessageIcon(), MessageMode.YES_NO, this.getSessionMessage("messagebox.confirmation", new Object[0]), msg, "/confirmResult");
    }

    @Action
    public String confirmResult() throws UnifyException {
        if (MessageResult.YES.equals((Object)this.getMessageResult())) {
            return this.hidePopupFireConfirm();
        }
        return this.hidePopup();
    }

    @Override
    public String executePageCall(String actionName) throws UnifyException {
        try {
            if ("/openPage".equals(actionName)) {
                String resultName = this.openPage();
                if (!this.getPageRequestContextUtil().isRemoteViewer()) {
                    ContentPanel contentPanel = this.getPageRequestContextUtil().getRequestDocument().getContentPanel();
                    contentPanel.addContent(this.getPageRequestContextUtil().getRequestPage());
                }
                return resultName;
            }
            if ("/replacePage".equals(actionName)) {
                Page currentPage;
                ContentPanel contentPanel;
                String pathToReplaceId;
                String resultName = this.openPage();
                PageRequestContextUtil pageRequestContextUtil = this.getPageRequestContextUtil();
                if (!this.getPageRequestContextUtil().isRemoteViewer() && !StringUtils.isBlank((String)(pathToReplaceId = (contentPanel = pageRequestContextUtil.getRequestDocument().getContentPanel()).insertContent(currentPage = this.getPageRequestContextUtil().getRequestPage())))) {
                    this.performClosePages(contentPanel, Arrays.asList(pathToReplaceId), true);
                }
                return resultName;
            }
            if ("/closePage".equals(actionName)) {
                ClosePageMode closePageMode = this.getPageRequestContextUtil().getRequestTargetValue(ClosePageMode.class);
                this.performClosePage(closePageMode, true);
                return "resrv.close";
            }
            String resultName = (String)this.getUIControllerUtil().getPageControllerInfo(this.getName()).getAction(actionName).getMethod().invoke((Object)this, new Object[0]);
            if ("resrv.close".equals(resultName)) {
                this.performClosePage(ClosePageMode.CLOSE, false);
            }
            return resultName;
        }
        catch (UnifyException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwOperationErrorException(e);
            return null;
        }
    }

    @Override
    public void populate(DataTransferBlock transferBlock) throws UnifyException {
        DataTransferWidget dataTransferWidget = (DataTransferWidget)this.getPageRequestContextUtil().getRequestPage().getWidgetByLongName(transferBlock.getLongName());
        dataTransferWidget.populate(transferBlock);
    }

    @Override
    protected AbstractUIController.DataTransferParam getDataTransferParam() throws UnifyException {
        Page page = this.getPageRequestContextUtil().getRequestPage();
        return new AbstractUIController.DataTransferParam(this, this.getUIControllerUtil().getPageControllerInfo(this.getName()), (Class)page.getAttribute("validationClass"), (Class)page.getAttribute("validationIdClass"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doProcess(ClientRequest request, ClientResponse response, PageController<?> docPageController, ControllerPathParts docPathParts) throws UnifyException {
        ResponseWriter writer = this.getResponseWriterPool().getResponseWriter(request);
        UIControllerUtil uiControllerUtil = this.getUIControllerUtil();
        try {
            ControllerPathParts reqPathParts;
            ControllerPathParts respPathParts = reqPathParts = request.getRequestPathParts().getControllerPathParts();
            PageControllerInfo pbbInfo = uiControllerUtil.getPageControllerInfo(this.getName());
            Page page = uiControllerUtil.loadRequestPage(reqPathParts);
            String resultName = "resrv.validationerror";
            DataTransfer dataTransfer = this.prepareDataTransfer(request);
            if (this.validate(page, dataTransfer)) {
                Page page2 = page;
                synchronized (page2) {
                    this.populate(dataTransfer);
                    resultName = reqPathParts.isActionPath() ? this.executePageCall(reqPathParts.getActionName()) : this.executePageCall("/indexPage");
                }
                PageController<Object> respPageController = this;
                this.logDebug("Processing result with name [{0}]...", new Object[]{resultName});
                if (!pbbInfo.hasResultWithName(resultName) && !page.isDocument() && docPageController != null) {
                    this.logDebug("Result with name [{0}] not found for controller [{1}]...", new Object[]{resultName, respPageController.getName()});
                    respPathParts = docPathParts;
                    respPageController = docPageController;
                    page = uiControllerUtil.loadRequestPage(respPathParts);
                    pbbInfo = uiControllerUtil.getPageControllerInfo(respPageController.getName());
                    this.logDebug("Result with name [{0}] routed to controller [{1}]...", new Object[]{resultName, respPageController.getName()});
                }
                if (!pbbInfo.hasResultWithName(resultName)) {
                    this.logDebug("Result with name [{0}] not found for controller [{1}]...", new Object[]{resultName, respPageController.getName()});
                    respPathParts = this.pagePathInfoRepository.getControllerPathParts(uiControllerUtil.getCommonUtilitiesControllerName());
                    respPageController = (PageController)this.getControllerFinder().findController(respPathParts);
                    page = uiControllerUtil.loadRequestPage(respPathParts);
                    pbbInfo = uiControllerUtil.getPageControllerInfo(respPageController.getName());
                    this.logDebug("Result with name [{0}] routed to controller [{1}]...", new Object[]{resultName, respPageController.getName()});
                }
            }
            this.getPageRequestContextUtil().setResponsePathParts(respPathParts);
            Result result = pbbInfo.getResult(resultName);
            this.writeResponse(writer, page, result);
            response.setContentType(result.getMimeType().template());
            if (request.getCharset() != null) {
                response.setCharacterEncoding(request.getCharset().name());
            }
            writer.writeTo(response.getWriter());
        }
        finally {
            this.getSessionContext().removeAttributes(this.getPageRequestContextUtil().getClosedPagePaths());
            this.getResponseWriterPool().restore(writer);
        }
    }

    protected T getPageBean() throws UnifyException {
        return (T)this.getPageRequestContextUtil().getRequestPage().getPageBean();
    }

    protected String getPathVariable() throws UnifyException {
        return this.getPageRequestContextUtil().getRequestPage().getPathVariable();
    }

    protected String fileDownloadResult(DownloadFile downloadFile, boolean hidePopup) throws UnifyException {
        this.setRequestAttribute("WR.downloadFile", downloadFile);
        if (hidePopup) {
            return "resrv.downloadfilehidepopup";
        }
        return "resrv.downloadfile";
    }

    protected String showMessageBox(String message) throws UnifyException {
        return this.showMessageBox(MessageIcon.INFO, MessageMode.OK, "$m{messagebox.message}", message, "/hidePopup");
    }

    protected String showMessageBox(MessageIcon messageIcon, MessageMode messageMode, String message) throws UnifyException {
        return this.showMessageBox(messageIcon, messageMode, "$m{messagebox.message}", message, "/hidePopup");
    }

    protected String showMessageBox(String message, String actionPath) throws UnifyException {
        return this.showMessageBox(MessageIcon.INFO, MessageMode.OK, "$m{messagebox.message}", message, actionPath);
    }

    protected String showMessageBox(String caption, String message, String actionPath) throws UnifyException {
        return this.showMessageBox(MessageIcon.INFO, MessageMode.OK, caption, message, actionPath);
    }

    protected String showMessageBox(MessageIcon messageIcon, MessageMode messageMode, String caption, String message, String actionPath) throws UnifyException {
        if (StringUtils.isBlank((String)actionPath)) {
            actionPath = "/hidePopup";
        }
        caption = this.resolveSessionMessage(caption, new Object[0]);
        message = this.resolveSessionMessage(message, new Object[0]);
        this.setSessionAttribute("UNIFYWEB.MESSAGEBOX", new MessageBox(messageIcon, messageMode, caption, message, this.getName() + actionPath));
        return "showapplicationmessage";
    }

    protected String launchTaskWithMonitorBox(TaskSetup taskSetup, String caption) throws UnifyException {
        return this.launchTaskWithMonitorBox(taskSetup, caption, null, null);
    }

    protected String launchTaskWithMonitorBox(TaskSetup taskSetup, String caption, String onSuccessPath, String onFailurePath) throws UnifyException {
        TaskMonitor taskMonitor = this.launchTask(taskSetup);
        TaskMonitorInfo taskMonitorInfo = new TaskMonitorInfo(taskMonitor, this.resolveSessionMessage(caption, new Object[0]), onSuccessPath, onFailurePath);
        this.setSessionAttribute("UNIFYWEB.TASKMONITORINFO", taskMonitorInfo);
        return "showapplicationtaskmonitor";
    }

    protected String fireOtherControllerAction(String fullActionPath) throws UnifyException {
        return this.getUIControllerUtil().executePageController(fullActionPath);
    }

    protected void writeOtherControllerProperty(String controllerName, String propertyName, Object value) throws UnifyException {
        this.getUIControllerUtil().populatePageBean(controllerName, propertyName, value);
    }

    protected void setDocumentAttribute(String name, Object value) throws UnifyException {
        Document document = this.getPageRequestContextUtil().getRequestDocument();
        if (document != null) {
            document.setAttribute(name, value);
        }
    }

    protected Object clearDocumentAttribute(String name) throws UnifyException {
        Document document = this.getPageRequestContextUtil().getRequestDocument();
        if (document != null) {
            return document.clearAttribute(name);
        }
        return null;
    }

    protected Object getDocumentAttribute(String name) throws UnifyException {
        Document document = this.getPageRequestContextUtil().getRequestDocument();
        if (document != null) {
            return document.getAttribute(name);
        }
        return null;
    }

    protected <U> U getDocumentAttribute(Class<U> clazz, String name) throws UnifyException {
        Document document = this.getPageRequestContextUtil().getRequestDocument();
        if (document != null) {
            return (U)document.getAttribute(name);
        }
        return null;
    }

    protected void setPageAttribute(String name, Object value) throws UnifyException {
        this.getPageRequestContextUtil().getRequestPage().setAttribute(name, value);
    }

    protected Object clearPageAttribute(String name) throws UnifyException {
        return this.getPageRequestContextUtil().getRequestPage().clearAttribute(name);
    }

    protected Object getPageAttribute(String name) throws UnifyException {
        return this.getPageRequestContextUtil().getRequestPage().getAttribute(name);
    }

    protected <U> U getPageAttribute(Class<U> clazz, String name) throws UnifyException {
        return (U)this.getPageRequestContextUtil().getRequestPage().getAttribute(name);
    }

    protected boolean isPageValidationEnabled() throws UnifyException {
        return this.getPageRequestContextUtil().getRequestPage().isValidationEnabled();
    }

    protected void setPageTitle(String title) throws UnifyException {
        this.setPageAttribute("pageTitle", title);
    }

    protected void setPageValidationEnabled(boolean validationEnabled) throws UnifyException {
        this.getPageRequestContextUtil().getRequestPage().setValidationEnabled(validationEnabled);
    }

    protected <U> U getPageWidgetByLongName(Class<U> clazz, String longName) throws UnifyException {
        return this.getPageRequestContextUtil().getRequestPage().getWidgetByLongName(clazz, longName);
    }

    protected <U> U getPageWidgetByShortName(Class<U> clazz, String shortName) throws UnifyException {
        return this.getPageRequestContextUtil().getRequestPage().getWidgetByShortName(clazz, shortName);
    }

    protected void setPageWidgetDisabled(String shortName, boolean disabled) throws UnifyException {
        this.getPageRequestContextUtil().getRequestPage().setWidgetDisabled(shortName, disabled);
    }

    protected boolean isPageWidgetDisabled(String shortName) throws UnifyException {
        return this.getPageRequestContextUtil().getRequestPage().isWidgetDisabled(shortName);
    }

    protected void setPageWidgetVisible(String shortName, boolean visible) throws UnifyException {
        this.getPageRequestContextUtil().getRequestPage().setWidgetVisible(shortName, visible);
    }

    protected boolean isPageWidgetVisible(String shortName) throws UnifyException {
        return this.getPageRequestContextUtil().getRequestPage().isWidgetVisible(shortName);
    }

    protected void setPageWidgetEditable(String shortName, boolean editable) throws UnifyException {
        this.getPageRequestContextUtil().getRequestPage().setWidgetEditable(shortName, editable);
    }

    protected boolean isPageWidgetEditable(String shortName) throws UnifyException {
        return this.getPageRequestContextUtil().getRequestPage().isWidgetEditable(shortName);
    }

    protected TaskMonitor launchTask(TaskSetup taskSetup) throws UnifyException {
        return this.taskLauncher.launchTask(taskSetup);
    }

    protected void hintUser(String messageKey, Object ... params) throws UnifyException {
        this.getPageRequestContextUtil().hintUser(Hint.MODE.INFO, messageKey, params);
    }

    protected void hintUser(Hint.MODE mode, String messageKey, Object ... params) throws UnifyException {
        this.getPageRequestContextUtil().hintUser(mode, messageKey, params);
    }

    protected void clearHintUser() throws UnifyException {
        this.getPageRequestContextUtil().clearHintUser();
    }

    protected <U> U getRequestTarget(Class<U> clazz) throws UnifyException {
        return this.getPageRequestContextUtil().getRequestTargetValue(clazz);
    }

    protected void onInitPage() throws UnifyException {
    }

    protected void onIndexPage() throws UnifyException {
    }

    protected void onOpenPage() throws UnifyException {
        this.getPageRequestContextUtil().setContentScrollReset();
    }

    protected void onSavePage() throws UnifyException {
    }

    protected void onClosePage() throws UnifyException {
    }

    protected void changePathInfo(String colorScheme, String savePagePath, boolean remoteSave) throws UnifyException {
        PagePathInfo pathInfo = this.pagePathInfoRepository.getPagePathInfo(this.getPage());
        pathInfo.setColorScheme(colorScheme);
        pathInfo.setSavePagePath(savePagePath);
        pathInfo.setRemoteSave(remoteSave);
    }

    private MessageResult getMessageResult() throws UnifyException {
        return this.getRequestTarget(MessageResult.class);
    }

    private void performClosePage(ClosePageMode closePageMode, boolean isFireClose) throws UnifyException {
        PageRequestContextUtil pageRequestContextUtil = this.getPageRequestContextUtil();
        Page currentPage = pageRequestContextUtil.getRequestPage();
        if (pageRequestContextUtil.isRemoteViewer()) {
            ControllerPathParts controllerPathParts = this.getPathInfoRepository().getControllerPathParts(currentPage.getPathId());
            this.getUIControllerUtil().loadRequestPage(controllerPathParts);
            ((PageController)this.getComponent(controllerPathParts.getControllerName())).closePage();
            pageRequestContextUtil.setClosedPagePaths(Arrays.asList(currentPage.getPathId()));
            return;
        }
        ContentPanel contentPanel = pageRequestContextUtil.getRequestDocument().getContentPanel();
        List<String> toClosePathIdList = contentPanel.evaluateRemoveContent(currentPage, closePageMode);
        this.performClosePages(contentPanel, toClosePathIdList, isFireClose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performClosePages(ContentPanel contentPanel, List<String> toClosePathIdList, boolean isFireClose) throws UnifyException {
        if (!toClosePathIdList.isEmpty()) {
            PageRequestContextUtil pageRequestContextUtil = this.getPageRequestContextUtil();
            Page currentPage = pageRequestContextUtil.getRequestPage();
            try {
                if (isFireClose) {
                    for (String closePathId : toClosePathIdList) {
                        ControllerPathParts controllerPathParts = this.getPathInfoRepository().getControllerPathParts(closePathId);
                        this.getUIControllerUtil().loadRequestPage(controllerPathParts);
                        ((PageController)this.getComponent(controllerPathParts.getControllerName())).closePage();
                    }
                }
                contentPanel.removeContent(toClosePathIdList);
                pageRequestContextUtil.setClosedPagePaths(toClosePathIdList);
            }
            finally {
                pageRequestContextUtil.setRequestPage(currentPage);
            }
        }
    }

    private boolean validate(Page page, DataTransfer dataTransfer) throws UnifyException {
        boolean successful = true;
        if (page.isValidationEnabled()) {
            String actionId = dataTransfer.getActionId();
            this.logDebug("Page validation is enabled. actionId = [{0}]", new Object[]{actionId});
            if (StringUtils.isNotBlank((String)actionId)) {
                this.logDebug("Performing request parameter validation. path ID [{0}]", new Object[]{page.getPathId()});
                PageAction pageAction = page.getPageAction(this.getPageManager().getLongName(actionId));
                UplElementReferences uer = (UplElementReferences)pageAction.getUplAttribute(UplElementReferences.class, "validations");
                for (String validationLongName : uer.getLongNames()) {
                    this.logDebug("Applying validation [{0}]...", new Object[]{validationLongName});
                    successful &= page.getPageWidgetValidator(this.getPageManager(), validationLongName).validate(dataTransfer);
                }
                this.logDebug("Request parameter validation completed. path ID [{0}]", new Object[]{page.getPathId()});
            }
        }
        return successful;
    }
}

