/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Singleton;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.web.ClientRequest;
import com.tcdng.unify.web.ClientResponse;
import com.tcdng.unify.web.ControllerPathParts;
import com.tcdng.unify.web.annotation.RequestParameter;
import com.tcdng.unify.web.constant.ReadOnly;
import com.tcdng.unify.web.constant.ResetOnWrite;
import com.tcdng.unify.web.constant.Secured;
import com.tcdng.unify.web.ui.AbstractUIController;
import com.tcdng.unify.web.ui.DataTransfer;
import com.tcdng.unify.web.ui.DataTransferBlock;
import com.tcdng.unify.web.ui.PageController;
import com.tcdng.unify.web.ui.PageResourceController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@Singleton(value=false)
public abstract class AbstractPageResourceController
extends AbstractUIController
implements PageResourceController {
    @RequestParameter
    private String resourceName;
    @RequestParameter
    private String contentType;
    @RequestParameter
    private boolean attachment;
    @RequestParameter
    private String morsic;
    private Map<String, String> metaDataMap;

    public AbstractPageResourceController(Secured secured) {
        super(secured, ReadOnly.FALSE, ResetOnWrite.FALSE);
    }

    public void ensureContextResources(ControllerPathParts controllerPathParts) throws UnifyException {
    }

    @Override
    public void populate(DataTransferBlock transferBlock) throws UnifyException {
        if (!this.isReadOnly()) {
            DataUtils.setNestedBeanProperty((Object)this, (String)transferBlock.getLongProperty(), (Object)transferBlock.getValue(), null);
        }
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public void setAttachment(boolean attachment) {
        this.attachment = attachment;
    }

    @Override
    public void reset() throws UnifyException {
    }

    public String getMorsic() {
        return this.morsic;
    }

    public void setMorsic(String morsic) {
        this.morsic = morsic;
    }

    @Override
    public Set<String> getMetaDataKeys() {
        if (this.metaDataMap != null) {
            return this.metaDataMap.keySet();
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public String getMetaData(String name) {
        if (this.metaDataMap != null) {
            return this.metaDataMap.get(name);
        }
        return null;
    }

    @Override
    protected AbstractUIController.DataTransferParam getDataTransferParam() throws UnifyException {
        return new AbstractUIController.DataTransferParam(this, this.getUIControllerUtil().getResourceControllerInfo(this.getName()));
    }

    @Override
    protected void doProcess(ClientRequest request, ClientResponse response, PageController<?> docPageController, ControllerPathParts docPathParts) throws UnifyException {
        if (!this.isReadOnly()) {
            DataTransfer dataTransfer = this.prepareDataTransfer(request);
            this.populate(dataTransfer);
        }
        this.prepareExecution();
        for (String key : this.getMetaDataKeys()) {
            response.setMetaData(key, this.getMetaData(key));
        }
        if (this.getContentType() != null) {
            response.setContentType(this.getContentType());
        }
        this.execute(response.getOutputStream());
    }

    protected void setMetaData(String name, String value) {
        if (this.metaDataMap == null) {
            this.metaDataMap = new HashMap<String, String>();
        }
        this.metaDataMap.put(name, value);
    }

    protected void setContentLength(long contentLength) {
        this.setMetaData("Content-Length", String.valueOf(contentLength));
    }

    protected void setContentDisposition(String fileName) {
        String disposition = "inline;filename=";
        if (this.isAttachment()) {
            disposition = "attachment;filename=";
        }
        disposition = disposition + "\"" + fileName + "\"";
        this.setMetaData("Content-Disposition", disposition);
    }

    protected String getResourceName() {
        return this.resourceName;
    }

    protected boolean isAttachment() {
        return this.attachment;
    }
}

