/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.UnifyOperationException;
import com.tcdng.unify.core.annotation.Configurable;
import com.tcdng.unify.core.constant.LocaleType;
import com.tcdng.unify.core.constant.MimeType;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.core.util.SystemUtils;
import com.tcdng.unify.web.AbstractController;
import com.tcdng.unify.web.ClientRequest;
import com.tcdng.unify.web.ClientResponse;
import com.tcdng.unify.web.ControllerPathParts;
import com.tcdng.unify.web.PathInfoRepository;
import com.tcdng.unify.web.constant.ReadOnly;
import com.tcdng.unify.web.constant.ResetOnWrite;
import com.tcdng.unify.web.constant.Secured;
import com.tcdng.unify.web.ui.DataTransfer;
import com.tcdng.unify.web.ui.DataTransferBlock;
import com.tcdng.unify.web.ui.DataTransferHeader;
import com.tcdng.unify.web.ui.PageController;
import com.tcdng.unify.web.ui.PageControllerResponse;
import com.tcdng.unify.web.ui.PageRequestContextUtil;
import com.tcdng.unify.web.ui.RequestCommand;
import com.tcdng.unify.web.ui.Result;
import com.tcdng.unify.web.ui.UIController;
import com.tcdng.unify.web.ui.UIControllerInfo;
import com.tcdng.unify.web.ui.UIControllerUtil;
import com.tcdng.unify.web.ui.util.DataTransferUtils;
import com.tcdng.unify.web.ui.widget.Document;
import com.tcdng.unify.web.ui.widget.Page;
import com.tcdng.unify.web.ui.widget.PageManager;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.ResponseWriterPool;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractUIController
extends AbstractController
implements UIController {
    private static final Set<String> skipOnPopulateSet = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("req_doc", "req_trg", "req_win", "req_va", "req_cmsg", "req_cmsgicon", "req_cprm", "req_rv", "req_rcd", "req_rsi", "req_uid", "req_unm", "req_bcd", "req_zcd", "req_gac", "req_csm", "req_tnc")));
    @Configurable
    private UIControllerUtil uiControllerUtil;
    @Configurable
    private PageRequestContextUtil pageRequestContextUtil;
    @Configurable
    private PageManager pageManager;
    @Configurable
    private PathInfoRepository pathInfoRepository;
    @Configurable
    private ResponseWriterPool responseWriterPool;
    private boolean readOnly;
    private boolean resetOnWrite;

    public AbstractUIController(Secured secured, ReadOnly readOnly, ResetOnWrite resetOnWrite) {
        super(secured);
        this.readOnly = readOnly.isTrue();
        this.resetOnWrite = resetOnWrite.isTrue();
    }

    public void setUiControllerUtil(UIControllerUtil uiControllerUtil) {
        this.uiControllerUtil = uiControllerUtil;
    }

    public void setPageRequestContextUtil(PageRequestContextUtil pageRequestContextUtil) {
        this.pageRequestContextUtil = pageRequestContextUtil;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setPathInfoRepository(PathInfoRepository pathInfoRepository) {
        this.pathInfoRepository = pathInfoRepository;
    }

    public void setResponseWriterPool(ResponseWriterPool responseWriterPool) {
        this.responseWriterPool = responseWriterPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(ClientRequest request, ClientResponse response) throws UnifyException {
        try {
            ControllerPathParts reqPathParts = request.getRequestPathParts().getControllerPathParts();
            PageController docPageController = null;
            ControllerPathParts docPathParts = null;
            String documentPath = (String)request.getParameter("req_doc");
            if (documentPath != null) {
                docPathParts = this.pathInfoRepository.getControllerPathParts(documentPath);
                docPageController = (PageController)this.getControllerFinder().findController(docPathParts);
                this.pageRequestContextUtil.setRequestDocument((Document)this.uiControllerUtil.loadRequestPage(docPathParts));
            }
            this.pageRequestContextUtil.extractRequestParameters(request);
            this.ensureSecureAccess(reqPathParts, this.pageRequestContextUtil.isRemoteViewer());
            this.doProcess(request, response, docPageController, docPathParts);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeExceptionResponse(request, response, e);
        }
        finally {
            response.close();
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isResetOnWrite() {
        return this.resetOnWrite;
    }

    protected PageRequestContextUtil getPageRequestContextUtil() throws UnifyException {
        return this.pageRequestContextUtil;
    }

    protected PageManager getPageManager() {
        return this.pageManager;
    }

    protected PathInfoRepository getPathInfoRepository() {
        return this.pathInfoRepository;
    }

    protected ResponseWriterPool getResponseWriterPool() {
        return this.responseWriterPool;
    }

    protected UIControllerUtil getUIControllerUtil() {
        return this.uiControllerUtil;
    }

    protected abstract DataTransferParam getDataTransferParam() throws UnifyException;

    protected abstract void doProcess(ClientRequest var1, ClientResponse var2, PageController<?> var3, ControllerPathParts var4) throws UnifyException;

    protected DataTransfer prepareDataTransfer(ClientRequest request) throws UnifyException {
        String actionId = (String)request.getParameter("req_va");
        HashMap<String, DataTransferBlock> transferBlocks = null;
        DataTransferParam dataTransferParam = this.getDataTransferParam();
        for (String transferId : request.getParameterNames()) {
            if (skipOnPopulateSet.contains(transferId)) continue;
            Object values = request.getParameter(transferId);
            if ("req_rsh".equals(transferId)) {
                String[] strings = null;
                strings = values instanceof String[] ? (String[])values : new String[]{(String)values};
                for (int i = 0; i < strings.length; ++i) {
                    strings[i] = this.pageManager.getLongName(strings[i]);
                }
                this.pageRequestContextUtil.setResponseRefreshPanels(strings);
                continue;
            }
            if ("req_cmd".equals(transferId)) {
                if (!(values instanceof String)) {
                    throw new UnifyException("UWI_0009", new Object[0]);
                }
                String[] commandElements = ((String)values).split("->");
                DataTransferBlock transferBlock = DataTransferUtils.createTransferBlock(commandElements[0]);
                String parentLongName = this.pageManager.getLongName(transferBlock.getId());
                RequestCommand requestCommand = new RequestCommand(transferBlock, parentLongName, commandElements[1]);
                this.pageRequestContextUtil.setRequestCommand(requestCommand);
                continue;
            }
            if ("req_cmdtag".equals(transferId)) {
                if (!(values instanceof String)) {
                    throw new UnifyException("UWI_0009", new Object[0]);
                }
                this.pageRequestContextUtil.setRequestCommandTag((String)values);
                continue;
            }
            if ("req_wid".equals(transferId)) {
                if (!(values instanceof String)) {
                    throw new UnifyException("UWI_0009", new Object[0]);
                }
                this.pageRequestContextUtil.setTriggerWidgetId((String)values);
                continue;
            }
            if (transferBlocks == null) {
                transferBlocks = new HashMap<String, DataTransferBlock>();
            }
            DataTransferHeader header = new DataTransferHeader(values);
            DataTransferBlock transferBlock = DataTransferUtils.createTransferBlock(transferId, header);
            String id = transferBlock.getId();
            header.setLongName(this.pageManager.getLongName(id));
            header.setBindingInfo(dataTransferParam.getUIControllerInfo().getPropertyInfo(id));
            DataTransferBlock eldestBlock = (DataTransferBlock)transferBlocks.get(id);
            if (eldestBlock == null) {
                transferBlocks.put(id, transferBlock);
                continue;
            }
            transferBlock.setSiblingBlock(eldestBlock.getSiblingBlock());
            eldestBlock.setSiblingBlock(transferBlock);
        }
        return new DataTransfer(dataTransferParam.getValidationClass(), dataTransferParam.getValidationIdClass(), actionId, transferBlocks);
    }

    protected void populate(DataTransfer dataTransfer) throws UnifyException {
        if (!this.isReadOnly()) {
            this.logDebug("Populating controller [{0}]", new Object[]{this.getName()});
            if (this.isResetOnWrite()) {
                this.reset();
            }
            for (DataTransferBlock dataTransferBlock : dataTransfer.getDataTransferBlocks()) {
                do {
                    this.logDebug("Populating widget [{0}] with value [{1}] using transfer block [{2}]...", new Object[]{dataTransferBlock.getLongName(), dataTransferBlock.getDebugValue(), dataTransferBlock});
                    this.populate(dataTransferBlock);
                } while ((dataTransferBlock = dataTransferBlock.getSiblingBlock()) != null);
            }
            this.logDebug("Controller population completed [{0}]", new Object[]{this.getName()});
        }
    }

    protected void writeResponse(ResponseWriter writer, Page page, Result result) throws UnifyException {
        if (MimeType.APPLICATION_JSON.equals((Object)result.getMimeType())) {
            writer.write("{\"jsonResp\":[");
            boolean appendSym = false;
            for (PageControllerResponse pageControllerResponse : result.getResponses()) {
                if (appendSym) {
                    writer.write(Character.valueOf(','));
                } else {
                    appendSym = true;
                }
                pageControllerResponse.generate(writer, page);
            }
            writer.write("]");
            if (this.pageRequestContextUtil.isRemoteViewer()) {
                writer.write(",\"remoteView\":{");
                writer.write("\"view\":\"").write(this.pageRequestContextUtil.getRemoteViewer()).write("\"}");
            }
            writer.write(",\"scrollReset\":").write(this.pageRequestContextUtil.isContentScrollReset());
            writer.write("}");
        } else {
            for (PageControllerResponse pageControllerResponse : result.getResponses()) {
                pageControllerResponse.generate(writer, page);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeExceptionResponse(ClientRequest request, ClientResponse response, Exception e) throws UnifyException {
        this.logError(e);
        if (response.isOutUsed()) {
            if (e instanceof UnifyException) {
                throw (UnifyException)((Object)e);
            }
            throw new UnifyOperationException((Throwable)e, new Object[0]);
        }
        Boolean loginRequired = Boolean.FALSE;
        if (e instanceof UnifyException) {
            String errorCode = ((UnifyException)((Object)e)).getUnifyError().getErrorCode();
            loginRequired = "UW_0010".equals(errorCode) || SystemUtils.isForceLogoutErrorCode((String)errorCode);
        }
        String message = this.getExceptionMessage(LocaleType.SESSION, e);
        this.setSessionAttribute("reserved.systeminfo.loginrequired.flag", loginRequired);
        this.setSessionAttribute("reserved.systeminfo.message", message);
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        sw.flush();
        this.setSessionAttribute("reserved.systeminfo.stacktrace", sw.toString());
        ResponseWriter writer = this.responseWriterPool.getResponseWriter(request);
        try {
            PageController pageController = null;
            ControllerPathParts respPathParts = null;
            Page page = null;
            Result result = null;
            if (StringUtils.isBlank((String)((String)request.getParameter("req_doc"))) && !this.pageRequestContextUtil.isRemoteViewer()) {
                respPathParts = this.pathInfoRepository.getControllerPathParts("/unauthorized");
                pageController = (PageController)this.getControllerFinder().findController(respPathParts);
                page = this.uiControllerUtil.loadRequestPage(respPathParts);
                page.setWidgetVisible("stackTrace", loginRequired == false);
                result = this.uiControllerUtil.getPageControllerInfo(pageController.getName()).getResult("resrv.index");
            } else {
                respPathParts = this.pathInfoRepository.getControllerPathParts("/reserved/systeminfo");
                pageController = (PageController)this.getControllerFinder().findController(respPathParts);
                page = this.uiControllerUtil.loadRequestPage(respPathParts);
                page.setWidgetVisible("stackTrace", loginRequired == false);
                result = this.uiControllerUtil.getPageControllerInfo(pageController.getName()).getResult("showsystemexception");
            }
            this.pageRequestContextUtil.setResponsePathParts(respPathParts);
            this.writeResponse(writer, page, result);
            response.setContentType(result.getMimeType().template());
            writer.writeTo(response.getWriter());
        }
        catch (UnifyException e1) {
            throw e1;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            this.throwOperationErrorException(e1);
        }
        finally {
            this.responseWriterPool.restore(writer);
        }
    }

    protected class DataTransferParam {
        private UIControllerInfo uiControllerInfo;
        private Class<?> validationClass;
        private Class<?> validationIdClass;

        public DataTransferParam(UIControllerInfo uiControllerInfo, Class<?> validationClass, Class<?> validationIdClass) {
            this.uiControllerInfo = uiControllerInfo;
            this.validationClass = validationClass;
            this.validationIdClass = validationIdClass;
        }

        public DataTransferParam(UIControllerInfo uiControllerInfo) {
            this.uiControllerInfo = uiControllerInfo;
        }

        public UIControllerInfo getUIControllerInfo() {
            return this.uiControllerInfo;
        }

        public Class<?> getValidationClass() {
            return this.validationClass;
        }

        public Class<?> getValidationIdClass() {
            return this.validationIdClass;
        }
    }
}

