/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui;

import com.tcdng.unify.core.AbstractUnifyComponent;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.ClientRequest;
import com.tcdng.unify.web.ControllerPathParts;
import com.tcdng.unify.web.TargetPath;
import com.tcdng.unify.web.ui.PageRequestContextUtil;
import com.tcdng.unify.web.ui.RequestCommand;
import com.tcdng.unify.web.ui.widget.Document;
import com.tcdng.unify.web.ui.widget.Page;
import com.tcdng.unify.web.ui.widget.Panel;
import com.tcdng.unify.web.ui.widget.data.Hint;
import com.tcdng.unify.web.ui.widget.data.MessageIcon;
import com.tcdng.unify.web.ui.widget.data.ValidationInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Component(value="application-pagerequestcontextutil")
public class PageRequestContextUtilImpl
extends AbstractUnifyComponent
implements PageRequestContextUtil {
    private static final String COMMAND = "COMMAND";
    public static final String COMMAND_TAG = "COMMAND_TAG";
    private static final String COMMAND_RESULT_MAPPING = "COMMAND_RESULT_MAPPING";
    private static final String COMMAND_POSTRESPONSE_PATH = "COMMAND_POSTRESPONSE_PATH";
    private static final String TRIGGER_WIDGETID = "TRIGGER_WIDGETID";
    private static final String PAGENAME_ALIASES = "PAGENAME_ALIASES";
    private static final String REFRESH_PANEL_LONGNAMES = "REFRESH_PANEL_LONGNAMES";
    private static final String SWITCHED_PANELS = "SWITCHED_PANELS";
    private static final String REQUEST_DOCUMENT = "REQUEST_DOCUMENT";
    private static final String REQUEST_PAGE = "REQUEST_PAGE";
    private static final String REQUEST_POPUP_NAME = "REQUEST_POPUP_NAME";
    private static final String RESPONSE_PATHPARTS = "RESPONSE_PATHPARTS";
    private static final String CLOSED_PAGEPATHS = "CLOSED_PAGEPATHS";
    private static final String DYNAMICPANEL_PAGENAME = "DYNAMICPANEL_PAGENAME";
    private static final String USER_HINT_LIST = "USER_HINT_LIST";
    private static final String VALIDATION_INFO_LIST = "VALIDATION_INFO_LIST";
    private static final String ON_SAVE_LIST = "ON_SAVE_LIST";
    private static final String FOCUS_ON_WIDGET = "FOCUS_ON_WIDGET";
    private static final String CONSIDER_DEFAULT_FOCUS = "CONSIDER_DEFAULT_FOCUS";
    private static final String DEFAULT_FOCUS_ON_WIDGET = "PAGEREQUEST.DEFAULT_FOCUS_ON_WIDGET";
    private static final String CONTENT_SCROLL_RESET = "CONTENT_SCROLL_RESET";
    private static final String DEBOUNCE_WIDGET = "DEBOUNCE_WIDGET";

    @Override
    public void setRequestPage(Page page) throws UnifyException {
        this.setRequestAttribute(REQUEST_PAGE, page);
    }

    @Override
    public Page getRequestPage() throws UnifyException {
        return (Page)this.getRequestAttribute(REQUEST_PAGE);
    }

    @Override
    public void setRequestPopupName(String longName) throws UnifyException {
        this.setRequestAttribute(REQUEST_POPUP_NAME, longName);
    }

    @Override
    public String getRequestPopupName() throws UnifyException {
        return (String)this.getRequestAttribute(REQUEST_POPUP_NAME);
    }

    @Override
    public void setRequestDocument(Document document) throws UnifyException {
        this.setRequestAttribute(REQUEST_DOCUMENT, document);
    }

    @Override
    public Document getRequestDocument() throws UnifyException {
        return (Document)this.getRequestAttribute(REQUEST_DOCUMENT);
    }

    @Override
    public void setRequestCommand(RequestCommand requestCommand) throws UnifyException {
        this.setRequestAttribute(COMMAND, requestCommand);
    }

    @Override
    public RequestCommand getRequestCommand() throws UnifyException {
        return (RequestCommand)this.getRequestAttribute(COMMAND);
    }

    @Override
    public void setRequestCommandTag(String cmdTag) throws UnifyException {
        this.setRequestAttribute(COMMAND_TAG, cmdTag);
    }

    @Override
    public String getRequestCommandTag() throws UnifyException {
        return (String)this.getRequestAttribute(COMMAND_TAG);
    }

    @Override
    public void setTriggerWidgetId(String widgetId) throws UnifyException {
        this.setRequestAttribute(TRIGGER_WIDGETID, widgetId);
    }

    @Override
    public String getTriggerWidgetId() throws UnifyException {
        return (String)this.getRequestAttribute(TRIGGER_WIDGETID);
    }

    @Override
    public void setCommandResultMapping(String resultMapping) throws UnifyException {
        this.setRequestAttribute(COMMAND_RESULT_MAPPING, resultMapping);
    }

    @Override
    public String getCommandResultMapping() throws UnifyException {
        return (String)this.getRequestAttribute(COMMAND_RESULT_MAPPING);
    }

    @Override
    public void setCommandResponsePath(TargetPath targetPath) throws UnifyException {
        this.setRequestAttribute(COMMAND_POSTRESPONSE_PATH, targetPath);
    }

    @Override
    public TargetPath getCommandResponsePath() throws UnifyException {
        return (TargetPath)this.getRequestAttribute(COMMAND_POSTRESPONSE_PATH);
    }

    @Override
    public <T> T getRequestTargetValue(Class<T> targetClazz) throws UnifyException {
        return (T)DataUtils.convert(targetClazz, (Object)this.getRequestAttribute("req_trg"));
    }

    @Override
    public String getRequestConfirmMessage() throws UnifyException {
        return (String)DataUtils.convert(String.class, (Object)this.getRequestAttribute("req_cmsg"));
    }

    @Override
    public MessageIcon getRequestConfirmMessageIcon() throws UnifyException {
        return MessageIcon.getIconByInt((Integer)DataUtils.convert(Integer.TYPE, (Object)this.getRequestAttribute("req_cmsgicon")));
    }

    @Override
    public String getRequestConfirmParam() throws UnifyException {
        return (String)DataUtils.convert(String.class, (Object)this.getRequestAttribute("req_cprm"));
    }

    @Override
    public String getRemoteViewer() throws UnifyException {
        return (String)DataUtils.convert(String.class, (Object)this.getRequestAttribute("req_rv"));
    }

    @Override
    public boolean isRemoteViewer() throws UnifyException {
        return StringUtils.isNotBlank((String)this.getRemoteViewer());
    }

    @Override
    public void setResponsePathParts(ControllerPathParts respPathParts) throws UnifyException {
        this.setRequestAttribute(RESPONSE_PATHPARTS, respPathParts);
    }

    @Override
    public ControllerPathParts getResponsePathParts() throws UnifyException {
        return (ControllerPathParts)this.getRequestAttribute(RESPONSE_PATHPARTS);
    }

    @Override
    public void setClosedPagePaths(List<String> pathIdList) throws UnifyException {
        this.setRequestAttribute(CLOSED_PAGEPATHS, pathIdList);
    }

    @Override
    public List<String> getClosedPagePaths() throws UnifyException {
        List pathIdList = (List)this.getRequestAttribute(CLOSED_PAGEPATHS);
        if (pathIdList != null) {
            return pathIdList;
        }
        return Collections.emptyList();
    }

    @Override
    public void setDynamicPanelPageName(String pageName, String parentPageName) throws UnifyException {
        ArrayList<DynamicPanelNames> dynamicPanelNameList = (ArrayList<DynamicPanelNames>)this.getRequestAttribute(DYNAMICPANEL_PAGENAME);
        if (dynamicPanelNameList == null) {
            dynamicPanelNameList = new ArrayList<DynamicPanelNames>();
            this.setRequestAttribute(DYNAMICPANEL_PAGENAME, dynamicPanelNameList);
        }
        dynamicPanelNameList.add(0, new DynamicPanelNames(pageName, parentPageName));
    }

    @Override
    public String getDynamicPanelPageName() throws UnifyException {
        List dynamicPanelNameList = (List)this.getRequestAttribute(DYNAMICPANEL_PAGENAME);
        if (DataUtils.isNotBlank((Collection)dynamicPanelNameList)) {
            return ((DynamicPanelNames)((List)this.getRequestAttribute(DYNAMICPANEL_PAGENAME)).get(0)).getPageName();
        }
        return null;
    }

    @Override
    public String getDynamicPanelParentPageName() throws UnifyException {
        List dynamicPanelNameList = (List)this.getRequestAttribute(DYNAMICPANEL_PAGENAME);
        if (DataUtils.isNotBlank((Collection)dynamicPanelNameList)) {
            return ((DynamicPanelNames)((List)this.getRequestAttribute(DYNAMICPANEL_PAGENAME)).get(0)).getParentPageName();
        }
        return null;
    }

    @Override
    public void clearDynamicPanelPageName() throws UnifyException {
        List dynamicPanelNameList = (List)this.getRequestAttribute(DYNAMICPANEL_PAGENAME);
        if (DataUtils.isNotBlank((Collection)dynamicPanelNameList)) {
            dynamicPanelNameList.remove(0);
        }
    }

    @Override
    public void setResponseRefreshPanels(String ... longNames) throws UnifyException {
        this.setRequestAttribute(REFRESH_PANEL_LONGNAMES, longNames);
    }

    @Override
    public String[] getResponseRefreshPanels() throws UnifyException {
        return (String[])this.getRequestAttribute(REFRESH_PANEL_LONGNAMES);
    }

    @Override
    public void setPanelSwitchStateFlag(Panel panel) throws UnifyException {
        HashSet<Panel> switchedPanels = (HashSet<Panel>)this.getRequestAttribute(SWITCHED_PANELS);
        if (switchedPanels == null) {
            switchedPanels = new HashSet<Panel>();
            this.setRequestAttribute(SWITCHED_PANELS, switchedPanels);
        }
        switchedPanels.add(panel);
    }

    @Override
    public boolean isPanelSwitched(Panel panel) throws UnifyException {
        Set switchedPanels = (Set)this.getRequestAttribute(SWITCHED_PANELS);
        return switchedPanels != null && switchedPanels.contains(panel);
    }

    @Override
    public void addPageAlias(String id, String ... aliases) throws UnifyException {
        HashSet<String> set;
        HashMap aliasMap = (HashMap)this.getRequestAttribute(PAGENAME_ALIASES);
        if (aliasMap == null) {
            aliasMap = new HashMap();
            this.setRequestAttribute(PAGENAME_ALIASES, aliasMap);
        }
        if ((set = (HashSet<String>)aliasMap.get(id)) == null) {
            set = new HashSet<String>();
            aliasMap.put(id, set);
        }
        for (String alias : aliases) {
            set.add(alias);
        }
    }

    @Override
    public Set<String> getRequestPageNameAliases(String pageName) throws UnifyException {
        Map childAliasMap = (Map)this.getRequestAttribute(PAGENAME_ALIASES);
        if (childAliasMap != null && childAliasMap.containsKey(pageName)) {
            return (Set)childAliasMap.get(pageName);
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public Map<String, Set<String>> getRequestPageNameAliases() throws UnifyException {
        return (Map)this.getRequestAttribute(PAGENAME_ALIASES);
    }

    @Override
    public void addRequestValidationInfo(String pageName, ValidationInfo validationInfo) throws UnifyException {
        ValidationInfo oldValidationInfo;
        LinkedHashMap<String, ValidationInfo> validationInfos = (LinkedHashMap<String, ValidationInfo>)this.getRequestAttribute(VALIDATION_INFO_LIST);
        if (validationInfos == null) {
            validationInfos = new LinkedHashMap<String, ValidationInfo>();
            this.setRequestAttribute(VALIDATION_INFO_LIST, validationInfos);
        }
        if ((oldValidationInfo = (ValidationInfo)validationInfos.get(pageName)) != null) {
            if (oldValidationInfo.isPass() && !validationInfo.isPass()) {
                validationInfos.put(pageName, validationInfo);
            }
        } else {
            validationInfos.put(pageName, validationInfo);
        }
    }

    @Override
    public Collection<ValidationInfo> getRequestValidationInfoList() throws UnifyException {
        Map map = (Map)this.getRequestAttribute(VALIDATION_INFO_LIST);
        if (map != null) {
            return map.values();
        }
        return Collections.emptyList();
    }

    @Override
    public void addOnSaveContentWidget(String widgetId) throws UnifyException {
        ArrayList<String> widgetList = (ArrayList<String>)this.getRequestAttribute(ON_SAVE_LIST);
        if (widgetList == null) {
            widgetList = new ArrayList<String>();
            this.setRequestAttribute(ON_SAVE_LIST, widgetList);
        }
        widgetList.add(widgetId);
    }

    @Override
    public List<String> getOnSaveContentWidgets() throws UnifyException {
        List widgetList = (List)this.getRequestAttribute(ON_SAVE_LIST);
        if (widgetList != null) {
            return widgetList;
        }
        return Collections.emptyList();
    }

    @Override
    public void clearOnSaveContentWidgets() throws UnifyException {
        this.removeRequestAttribute(ON_SAVE_LIST);
    }

    @Override
    public void hintUser(String message, Object ... params) throws UnifyException {
        this.hintUser(Hint.MODE.INFO, message, params);
    }

    @Override
    public void hintUser(Hint.MODE mode, String message, Object ... params) throws UnifyException {
        ArrayList<Hint> hintList = (ArrayList<Hint>)this.getRequestAttribute(USER_HINT_LIST);
        if (hintList == null) {
            hintList = new ArrayList<Hint>();
            this.setRequestAttribute(USER_HINT_LIST, hintList);
        }
        hintList.add(new Hint(mode, this.resolveSessionMessage(message, params)));
    }

    @Override
    public List<Hint> getUserHints() throws UnifyException {
        return (List)this.getRequestAttribute(USER_HINT_LIST);
    }

    @Override
    public void clearHintUser() throws UnifyException {
        this.removeRequestAttribute(USER_HINT_LIST);
    }

    @Override
    public boolean setFocusOnWidgetId(String id) throws UnifyException {
        if (!this.isRequestAttribute(FOCUS_ON_WIDGET)) {
            this.setRequestAttribute(FOCUS_ON_WIDGET, id);
            return true;
        }
        return false;
    }

    @Override
    public boolean isFocusOnWidget() throws UnifyException {
        return this.isRequestAttribute(FOCUS_ON_WIDGET);
    }

    @Override
    public String getFocusOnWidgetId() throws UnifyException {
        return (String)this.getRequestAttribute(FOCUS_ON_WIDGET);
    }

    @Override
    public void considerDefaultFocusOnWidget() throws UnifyException {
        this.setRequestAttribute(CONSIDER_DEFAULT_FOCUS, Boolean.TRUE);
    }

    @Override
    public void setDefaultFocusOnWidgetId(String id) throws UnifyException {
        this.setSessionAttribute(DEFAULT_FOCUS_ON_WIDGET, id);
    }

    @Override
    public boolean isFocusOnWidgetOrDefault() throws UnifyException {
        return this.isFocusOnWidget() || this.isRequestAttribute(CONSIDER_DEFAULT_FOCUS) && this.isSessionAttribute(DEFAULT_FOCUS_ON_WIDGET);
    }

    @Override
    public String getFocusOnWidgetIdOrDefault() throws UnifyException {
        if (this.isFocusOnWidget()) {
            return this.getFocusOnWidgetId();
        }
        return (String)this.getSessionAttribute(DEFAULT_FOCUS_ON_WIDGET);
    }

    @Override
    public void clearFocusOnWidget() throws UnifyException {
        this.removeRequestAttribute(FOCUS_ON_WIDGET);
    }

    @Override
    public void registerWidgetDebounce(String widgetId) throws UnifyException {
        ArrayList<String> widgetIds = (ArrayList<String>)this.getRequestAttribute(DEBOUNCE_WIDGET);
        if (widgetIds == null) {
            widgetIds = new ArrayList<String>();
            this.setRequestAttribute(DEBOUNCE_WIDGET, widgetIds);
        }
        widgetIds.add(widgetId);
    }

    @Override
    public Collection<String> getAndClearRegisteredDebounceWidgetIds() throws UnifyException {
        return (Collection)this.removeRequestAttribute(DEBOUNCE_WIDGET);
    }

    @Override
    public boolean isRegisteredDebounceWidgets() throws UnifyException {
        return this.getRequestAttribute(DEBOUNCE_WIDGET) != null;
    }

    @Override
    public void setContentScrollReset() throws UnifyException {
        this.setRequestAttribute(CONTENT_SCROLL_RESET, Boolean.TRUE);
    }

    @Override
    public boolean isContentScrollReset() throws UnifyException {
        return Boolean.TRUE.equals(this.getRequestAttribute(CONTENT_SCROLL_RESET));
    }

    @Override
    public void clearRequestContext() throws UnifyException {
        this.setRequestAttribute("req_trg", null);
        this.setRequestAttribute("req_win", null);
        this.setRequestAttribute("req_cmsg", null);
        this.setRequestAttribute("req_cmsgicon", null);
        this.setRequestAttribute("req_cprm", null);
        this.setRequestAttribute(COMMAND, null);
        this.setRequestAttribute(COMMAND_POSTRESPONSE_PATH, null);
        this.setRequestAttribute(PAGENAME_ALIASES, null);
        this.setRequestAttribute(REFRESH_PANEL_LONGNAMES, null);
        this.setRequestAttribute(REQUEST_DOCUMENT, null);
        this.setRequestAttribute(REQUEST_PAGE, null);
        this.setRequestAttribute(RESPONSE_PATHPARTS, null);
        this.setRequestAttribute(USER_HINT_LIST, null);
        this.setRequestAttribute(VALIDATION_INFO_LIST, null);
    }

    @Override
    public void extractRequestParameters(ClientRequest request) throws UnifyException {
        this.setRequestAttribute("req_trg", request.getParameter("req_trg"));
        this.setRequestAttribute("req_win", request.getParameter("req_win"));
        this.setRequestAttribute("req_cmsg", request.getParameter("req_cmsg"));
        this.setRequestAttribute("req_cmsgicon", request.getParameter("req_cmsgicon"));
        this.setRequestAttribute("req_cprm", request.getParameter("req_cprm"));
        this.setRequestAttribute("req_rv", request.getParameter("req_rv"));
        this.setRequestAttribute("req_rsi", request.getParameter("req_rsi"));
    }

    protected void onInitialize() throws UnifyException {
    }

    protected void onTerminate() throws UnifyException {
    }

    private class DynamicPanelNames {
        String pageName;
        String parentPageName;

        public DynamicPanelNames(String pageName, String parentPageName) {
            this.pageName = pageName;
            this.parentPageName = parentPageName;
        }

        public String getPageName() {
            return this.pageName;
        }

        public String getParentPageName() {
            return this.parentPageName;
        }
    }
}

