/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui;

import com.tcdng.unify.core.AbstractUnifyComponent;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Configurable;
import com.tcdng.unify.core.constant.MimeType;
import com.tcdng.unify.core.data.FactoryMap;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.core.util.ReflectUtils;
import com.tcdng.unify.core.util.UnifyConfigUtils;
import com.tcdng.unify.web.Action;
import com.tcdng.unify.web.Controller;
import com.tcdng.unify.web.ControllerFinder;
import com.tcdng.unify.web.ControllerPathParts;
import com.tcdng.unify.web.PathInfoRepository;
import com.tcdng.unify.web.annotation.RequestParameter;
import com.tcdng.unify.web.annotation.ResultMapping;
import com.tcdng.unify.web.annotation.ResultMappings;
import com.tcdng.unify.web.ui.PageController;
import com.tcdng.unify.web.ui.PageControllerInfo;
import com.tcdng.unify.web.ui.PageControllerResponse;
import com.tcdng.unify.web.ui.PageRequestContextUtil;
import com.tcdng.unify.web.ui.PageResourceController;
import com.tcdng.unify.web.ui.ResourceControllerInfo;
import com.tcdng.unify.web.ui.Result;
import com.tcdng.unify.web.ui.UIControllerUtil;
import com.tcdng.unify.web.ui.widget.Page;
import com.tcdng.unify.web.ui.widget.PageManager;
import com.tcdng.unify.web.ui.widget.PropertyInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Component(value="application-uicontrollerutil")
public class UIControllerUtilImpl
extends AbstractUnifyComponent
implements UIControllerUtil {
    @Configurable
    private PageManager pageManager;
    @Configurable
    private PageRequestContextUtil pageRequestContextUtil;
    @Configurable
    private PathInfoRepository pathInfoRepository;
    @Configurable
    private ControllerFinder controllerFinder;
    private Map<String, Result> defaultResultMap;
    private FactoryMap<Class<? extends PageController>, PageControllerActionInfo> pageControllerActionInfoMap;
    private FactoryMap<String, PageControllerInfo> pageControllerInfoMap;
    private FactoryMap<String, ResourceControllerInfo> resourceControllerInfoMap;
    private PageControllerResponse hintUserResponse;
    private PageControllerResponse refreshMenuResponse;
    private Set<String> skipOnPopulateSet = new HashSet<String>();
    private String commonUtilitiesControllerName;

    public UIControllerUtilImpl() {
        this.pageControllerActionInfoMap = new FactoryMap<Class<? extends PageController>, PageControllerActionInfo>(){

            protected PageControllerActionInfo create(Class<? extends PageController> clazz, Object ... params) throws Exception {
                Method[] methods;
                PageControllerActionInfo pageControllerActionInfo = new PageControllerActionInfo();
                for (Method method : methods = clazz.getMethods()) {
                    com.tcdng.unify.web.annotation.Action aa = method.getAnnotation(com.tcdng.unify.web.annotation.Action.class);
                    if (aa != null) {
                        if (UIControllerUtilImpl.this.isActionHandlerSignature(method)) {
                            pageControllerActionInfo.addActionMethod(method);
                            continue;
                        }
                        throw new UnifyException("UWI_0005", new Object[]{clazz.getName(), method.getName()});
                    }
                    if (!UIControllerUtilImpl.this.isActionHandlerSignature(method) || !UIControllerUtilImpl.this.isSuperCommandMethod(clazz, method.getName())) continue;
                    pageControllerActionInfo.addActionMethod(method);
                }
                return pageControllerActionInfo;
            }
        };
        this.pageControllerInfoMap = new FactoryMap<String, PageControllerInfo>(){

            protected PageControllerInfo create(String controllerName, Object ... params) throws Exception {
                return UIControllerUtilImpl.this.createPageControllerInfo(controllerName);
            }
        };
        this.resourceControllerInfoMap = new FactoryMap<String, ResourceControllerInfo>(){

            protected ResourceControllerInfo create(String controllerName, Object ... params) throws Exception {
                return UIControllerUtilImpl.this.createResourceControllerInfo(controllerName);
            }
        };
        this.skipOnPopulateSet.add("req_doc");
        this.skipOnPopulateSet.add("req_trg");
        this.skipOnPopulateSet.add("req_win");
        this.skipOnPopulateSet.add("req_va");
        this.skipOnPopulateSet.add("req_cmsg");
        this.skipOnPopulateSet.add("req_cmsgicon");
        this.skipOnPopulateSet.add("req_cprm");
        this.skipOnPopulateSet.add("req_rv");
        this.skipOnPopulateSet.add("req_rcd");
        this.skipOnPopulateSet.add("req_rsi");
        this.skipOnPopulateSet.add("req_uid");
        this.skipOnPopulateSet.add("req_unm");
        this.skipOnPopulateSet.add("req_bcd");
        this.skipOnPopulateSet.add("req_zcd");
        this.skipOnPopulateSet.add("req_gac");
        this.skipOnPopulateSet.add("req_csm");
        this.skipOnPopulateSet.add("req_tnc");
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setPageRequestContextUtil(PageRequestContextUtil pageRequestContextUtil) {
        this.pageRequestContextUtil = pageRequestContextUtil;
    }

    public void setPathInfoRepository(PathInfoRepository pathInfoRepository) {
        this.pathInfoRepository = pathInfoRepository;
    }

    public void setControllerFinder(ControllerFinder controllerFinder) {
        this.controllerFinder = controllerFinder;
    }

    @Override
    public PageControllerInfo getPageControllerInfo(String controllerName) throws UnifyException {
        return (PageControllerInfo)((Object)this.pageControllerInfoMap.get((Object)controllerName));
    }

    @Override
    public void updatePageControllerInfo(String controllerName, String standalonePanelName) throws UnifyException {
        PageControllerInfo pbbi = this.getPageControllerInfo(controllerName);
        Map<String, PropertyInfo> bindings = this.pageManager.getStandalonePanelPropertyBindings(standalonePanelName);
        pbbi.addBindings(standalonePanelName, bindings);
    }

    @Override
    public ResourceControllerInfo getResourceControllerInfo(String controllerName) throws UnifyException {
        return (ResourceControllerInfo)((Object)this.resourceControllerInfoMap.get((Object)controllerName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String executePageController(String fullActionPath) throws UnifyException {
        Page currentPage = this.pageRequestContextUtil.getRequestPage();
        try {
            ControllerPathParts targetPathParts = this.pathInfoRepository.getControllerPathParts(fullActionPath);
            PageController targetPageController = (PageController)this.controllerFinder.findController(targetPathParts);
            this.loadRequestPage(targetPathParts);
            String string = targetPageController.executePageCall(targetPathParts.getActionName());
            return string;
        }
        finally {
            this.pageRequestContextUtil.setRequestPage(currentPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populatePageBean(String controllerName, String property, Object value) throws UnifyException {
        Page currentPage = this.pageRequestContextUtil.getRequestPage();
        try {
            ControllerPathParts targetPathParts = this.pathInfoRepository.getControllerPathParts(controllerName);
            this.controllerFinder.findController(targetPathParts);
            Page targetPage = this.loadRequestPage(targetPathParts);
            DataUtils.setNestedBeanProperty((Object)targetPage.getPageBean(), (String)property, (Object)value);
        }
        finally {
            this.pageRequestContextUtil.setRequestPage(currentPage);
        }
    }

    @Override
    public String getCommonUtilitiesControllerName() {
        return this.commonUtilitiesControllerName;
    }

    @Override
    public Page loadRequestPage(ControllerPathParts controllerPathParts) throws UnifyException {
        Page page = (Page)this.getSessionContext().getAttribute(controllerPathParts.getControllerPathId());
        this.pageRequestContextUtil.setRequestPage(page);
        return page;
    }

    protected void onInitialize() throws UnifyException {
        this.commonUtilitiesControllerName = (String)this.getContainerSetting(String.class, "application.web.common", "/commonutilities");
        this.defaultResultMap = new HashMap<String, Result>();
        Locale defaultLocale = Locale.getDefault();
        this.hintUserResponse = (PageControllerResponse)this.getUplComponent(defaultLocale, "!hintuserresponse", false);
        this.refreshMenuResponse = (PageControllerResponse)this.getUplComponent(defaultLocale, "!refreshmenuresponse", false);
        this.defaultResultMap.put("resrv.none", new Result(new PageControllerResponse[]{this.hintUserResponse, this.refreshMenuResponse}));
        this.defaultResultMap.put("resrv.index", new Result(MimeType.TEXT_HTML, new PageControllerResponse[]{(PageControllerResponse)this.getUplComponent(defaultLocale, "!loaddocumentresponse", false)}));
        this.defaultResultMap.put("resrv.open", new Result(new PageControllerResponse[]{(PageControllerResponse)this.getUplComponent(defaultLocale, "!hidepopupresponse", false), (PageControllerResponse)this.getUplComponent(defaultLocale, "!loadcontentresponse", false), (PageControllerResponse)this.getUplComponent(defaultLocale, "!showpopupresponse", false), this.hintUserResponse, this.refreshMenuResponse}));
        this.defaultResultMap.put("resrv.save", new Result(new PageControllerResponse[]{(PageControllerResponse)this.getUplComponent(defaultLocale, "!postresponse", false), this.hintUserResponse, this.refreshMenuResponse}));
        this.defaultResultMap.put("resrv.close", new Result(new PageControllerResponse[]{(PageControllerResponse)this.getUplComponent(defaultLocale, "!hidepopupresponse", false), (PageControllerResponse)this.getUplComponent(defaultLocale, "!unloadcontentresponse", false), this.hintUserResponse, this.refreshMenuResponse}));
        this.defaultResultMap.put("resrv.remoteview", new Result(new PageControllerResponse[]{(PageControllerResponse)this.getUplComponent(defaultLocale, "!docviewresponse", false)}));
        this.defaultResultMap.put("resrv.postresponse", new Result(new PageControllerResponse[]{(PageControllerResponse)this.getUplComponent(defaultLocale, "!hidepopupresponse", false), (PageControllerResponse)this.getUplComponent(defaultLocale, "!postresponse pathRequestAttribute:$s{WR.commandPostPath}", false), this.hintUserResponse, this.refreshMenuResponse}));
        this.defaultResultMap.put("resrv.hintuser", new Result(new PageControllerResponse[]{this.hintUserResponse}));
        this.defaultResultMap.put("resrv.showpopup", new Result(new PageControllerResponse[]{(PageControllerResponse)this.getUplComponent(defaultLocale, "!showpopupresponse", false)}));
        this.defaultResultMap.put("resrv.hidepopup", new Result(new PageControllerResponse[]{(PageControllerResponse)this.getUplComponent(defaultLocale, "!hidepopupresponse", false), (PageControllerResponse)this.getUplComponent(defaultLocale, "!refreshpanelresponse", false), this.hintUserResponse, this.refreshMenuResponse}));
        this.defaultResultMap.put("resrv.hidepopupfireconfirm", new Result(new PageControllerResponse[]{(PageControllerResponse)this.getUplComponent(defaultLocale, "!hidepopupresponse", false), (PageControllerResponse)this.getUplComponent(defaultLocale, "!refreshpanelresponse", false), this.hintUserResponse, this.refreshMenuResponse, (PageControllerResponse)this.getUplComponent(defaultLocale, "!firepreconfirmresponse", false)}));
        this.defaultResultMap.put("resrv.command", new Result(new PageControllerResponse[]{(PageControllerResponse)this.getUplComponent(defaultLocale, "!refreshpanelresponse", false), (PageControllerResponse)this.getUplComponent(defaultLocale, "!commandpostresponse", false), this.hintUserResponse}));
        this.defaultResultMap.put("resrv.showattachment", new Result(new PageControllerResponse[]{(PageControllerResponse)this.getUplComponent(defaultLocale, "!fileattachmentresponse", false)}));
        this.defaultResultMap.put("resrv.downloadfile", new Result(new PageControllerResponse[]{(PageControllerResponse)this.getUplComponent(defaultLocale, "!filedownloadresponse", false)}));
        this.defaultResultMap.put("resrv.downloadfilehidepopup", new Result(new PageControllerResponse[]{(PageControllerResponse)this.getUplComponent(defaultLocale, "!hidepopupresponse", false), (PageControllerResponse)this.getUplComponent(defaultLocale, "!filedownloadresponse", false)}));
        this.defaultResultMap.put("resrv.refreshshowpopup", new Result(new PageControllerResponse[]{(PageControllerResponse)this.getUplComponent(defaultLocale, "!refreshpanelresponse", false), (PageControllerResponse)this.getUplComponent(defaultLocale, "!showpopupresponse", false)}));
        this.defaultResultMap.put("resrv.refreshhidepopup", new Result(new PageControllerResponse[]{(PageControllerResponse)this.getUplComponent(defaultLocale, "!refreshpanelresponse", false), (PageControllerResponse)this.getUplComponent(defaultLocale, "!hidepopupresponse", false)}));
        this.defaultResultMap.put("resrv.refreshpanels", new Result(new PageControllerResponse[]{(PageControllerResponse)this.getUplComponent(defaultLocale, "!refreshpanelresponse", false)}));
        this.defaultResultMap.put("resrv.refreshsection", new Result(new PageControllerResponse[]{(PageControllerResponse)this.getUplComponent(defaultLocale, "!refreshsectionresponse", false)}));
        this.defaultResultMap.put("resrv.validationerror", new Result(new PageControllerResponse[]{(PageControllerResponse)this.getUplComponent(defaultLocale, "!validationerrorresponse", false)}));
        this.defaultResultMap = Collections.unmodifiableMap(this.defaultResultMap);
    }

    protected void onTerminate() throws UnifyException {
    }

    private boolean isActionHandlerSignature(Method method) throws UnifyException {
        return String.class.equals(method.getReturnType()) && method.getParameterTypes().length == 0 && method.getExceptionTypes().length == 1 && UnifyException.class.isAssignableFrom(method.getExceptionTypes()[0]);
    }

    private boolean isSuperCommandMethod(Class<? extends PageController> pageControllerClass, String methodName) throws UnifyException {
        Class<? extends PageController> clazz = pageControllerClass;
        while ((clazz = clazz.getSuperclass()) != null && PageController.class.isAssignableFrom(clazz)) {
            if (!((PageControllerActionInfo)this.pageControllerActionInfoMap.get(clazz)).isActionMethod(methodName)) continue;
            return true;
        }
        return false;
    }

    private PageControllerInfo createPageControllerInfo(String controllerName) throws UnifyException {
        HashMap<String, Action> actionByNameMap = new HashMap<String, Action>();
        Class typeClass = this.getComponentType(PageController.class, controllerName);
        for (Method method : ((PageControllerActionInfo)this.pageControllerActionInfoMap.get((Object)typeClass)).getActionMethods()) {
            actionByNameMap.put("/" + method.getName(), new Action(method));
        }
        ConcurrentHashMap<String, Result> resultByNameMap = new ConcurrentHashMap<String, Result>();
        List classList = ReflectUtils.getClassHierachyList((Class)typeClass);
        for (Class clazz : classList) {
            ResultMappings rsa = clazz.getAnnotation(ResultMappings.class);
            if (rsa == null) continue;
            for (ResultMapping ra : rsa.value()) {
                String[] descriptors = ra.response();
                ArrayList<PageControllerResponse> responses = new ArrayList<PageControllerResponse>();
                Locale locale = Locale.getDefault();
                for (String descriptor : descriptors) {
                    if ("!hintuserresponse".equals(descriptor) || "!refreshmenuresponse".equals(descriptor)) continue;
                    responses.add((PageControllerResponse)this.getUplComponent(locale, descriptor, false));
                }
                responses.add(this.hintUserResponse);
                responses.add(this.refreshMenuResponse);
                resultByNameMap.put(ra.name(), new Result((PageControllerResponse[])DataUtils.toArray(PageControllerResponse.class, responses)));
            }
        }
        List categoryList = (List)DataUtils.convert(ArrayList.class, String.class, (Object)this.getContainerSetting(Object.class, "application.layout"));
        UnifyConfigUtils.resolveConfigurationOverrides(resultByNameMap, (List)categoryList);
        resultByNameMap.putAll(this.defaultResultMap);
        HashMap<String, PropertyInfo> pageNamePropertyBindingMap = new HashMap<String, PropertyInfo>();
        pageNamePropertyBindingMap.putAll(this.pageManager.getStandalonePanelPropertyBindings(controllerName));
        this.setIdRequestParameterBindings(typeClass, pageNamePropertyBindingMap);
        return new PageControllerInfo(controllerName, actionByNameMap, resultByNameMap, pageNamePropertyBindingMap);
    }

    private ResourceControllerInfo createResourceControllerInfo(String controllerName) throws UnifyException {
        Class resourceControllerClass = this.getComponentType(PageResourceController.class, controllerName);
        HashMap<String, PropertyInfo> propertyBindingMap = new HashMap<String, PropertyInfo>();
        this.setIdRequestParameterBindings(resourceControllerClass, propertyBindingMap);
        return new ResourceControllerInfo(controllerName, propertyBindingMap);
    }

    private void setIdRequestParameterBindings(Class<? extends Controller> controllerClass, Map<String, PropertyInfo> propertyBindingMap) throws UnifyException {
        List classHeirachyList = ReflectUtils.getClassHierachyList(controllerClass);
        for (Class clazz : classHeirachyList) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(RequestParameter.class)) continue;
                String fieldName = field.getName();
                propertyBindingMap.put(this.pageManager.getPageName(field.getName()), new PropertyInfo(fieldName, fieldName, fieldName, false));
            }
        }
    }

    private class PageControllerActionInfo {
        private Map<String, Method> actionMethods = new HashMap<String, Method>();

        public void addActionMethod(Method method) {
            this.actionMethods.put(method.getName(), method);
        }

        public boolean isActionMethod(String name) {
            return this.actionMethods.containsKey(name);
        }

        public Collection<Method> getActionMethods() {
            return this.actionMethods.values();
        }
    }
}

