/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.constant;

import com.tcdng.unify.convert.constants.EnumConst;
import com.tcdng.unify.core.annotation.StaticList;
import com.tcdng.unify.core.util.EnumUtils;

@StaticList(name="messagetypelist", description="$m{staticlist.messagetypelist}")
public enum MessageType implements EnumConst
{
    INFO("INF", "$t{images/info.png}", "info", 0),
    WARNING("WRN", "$t{images/warning.png}", "warning", 1),
    ERROR("ERR", "$t{images/error.png}", "error", 2);

    private final String code;
    private final String image;
    private final String styleClass;
    private final int severity;

    private MessageType(String code, String image, String styleClass, int severity) {
        this.code = code;
        this.image = image;
        this.styleClass = styleClass;
        this.severity = severity;
    }

    public String code() {
        return this.code;
    }

    public String defaultCode() {
        return MessageType.INFO.code;
    }

    public String image() {
        return this.image;
    }

    public String styleClass() {
        return this.styleClass;
    }

    public int severity() {
        return this.severity;
    }

    public int compareSeverity(MessageType type) {
        return this.severity - type.severity;
    }

    public static MessageType fromCode(String code) {
        return (MessageType)EnumUtils.fromCode(MessageType.class, (String)code);
    }

    public static MessageType fromName(String name) {
        return (MessageType)EnumUtils.fromName(MessageType.class, (String)name);
    }
}

