/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.controller;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.util.IOUtils;
import com.tcdng.unify.web.constant.Secured;
import com.tcdng.unify.web.ui.AbstractPageResourceController;
import com.tcdng.unify.web.ui.widget.control.FileAttachmentHandler;
import com.tcdng.unify.web.ui.widget.data.FileAttachmentInfo;
import com.tcdng.unify.web.ui.widget.data.FileAttachmentsInfo;
import java.io.OutputStream;

@Component(value="/resource/fileattachment")
public class FileAttachmentResourceController
extends AbstractPageResourceController {
    public FileAttachmentResourceController() {
        super(Secured.FALSE);
    }

    @Override
    public void prepareExecution() throws UnifyException {
        this.setContentDisposition(this.getResourceName());
    }

    @Override
    public void execute(OutputStream outputStream) throws UnifyException {
        byte[] data = null;
        Object resource = this.removeSessionAttribute(this.getResourceName());
        if (resource instanceof FileAttachmentsInfo) {
            String handler;
            FileAttachmentsInfo fileAttachmentsInfo = (FileAttachmentsInfo)resource;
            FileAttachmentInfo fileAttachmentInfo = fileAttachmentsInfo.getSelectedAttachmentInfo();
            data = fileAttachmentInfo.getAttachment();
            if (data == null && (handler = fileAttachmentsInfo.getHandlerName()) != null) {
                FileAttachmentHandler fileAttachmentHandler = (FileAttachmentHandler)this.getComponent(handler);
                FileAttachmentInfo viewFileAttachmentInfo = fileAttachmentHandler.handleView(fileAttachmentsInfo.getParentId(), fileAttachmentInfo);
                data = viewFileAttachmentInfo.getAttachment();
            }
        } else {
            data = ((FileAttachmentInfo)resource).getAttachment();
        }
        IOUtils.writeAll((OutputStream)outputStream, (byte[])data);
    }
}

