/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.controller;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Configurable;
import com.tcdng.unify.core.file.FileResourceProvider;
import com.tcdng.unify.core.util.IOUtils;
import com.tcdng.unify.web.constant.Secured;
import com.tcdng.unify.web.ui.AbstractPageResourceController;
import java.io.InputStream;
import java.io.OutputStream;

@Component(value="/resource/file")
public class FileResourceController
extends AbstractPageResourceController {
    @Configurable
    private FileResourceProvider fileResourceProvider;

    public FileResourceController() {
        super(Secured.FALSE);
    }

    public FileResourceController(Secured secured) {
        super(secured);
    }

    public void setFileResourceProvider(FileResourceProvider fileResourceProvider) {
        this.fileResourceProvider = fileResourceProvider;
    }

    @Override
    public void prepareExecution() throws UnifyException {
        this.setContentDisposition(this.getResourceName());
    }

    @Override
    public void execute(OutputStream out) throws UnifyException {
        InputStream in = null;
        try {
            in = this.getInputStream();
            IOUtils.writeAll((OutputStream)out, (InputStream)in);
        }
        finally {
            IOUtils.close((InputStream)in);
        }
    }

    protected InputStream getInputStream() throws UnifyException {
        InputStream in = null;
        if (this.fileResourceProvider != null) {
            in = this.fileResourceProvider.openFileResourceInputStream("/resource/file", this.getResourceName());
        }
        if (in == null) {
            return IOUtils.openFileResourceInputStream((String)this.getResourceName(), (String)this.getUnifyComponentContext().getWorkingPath());
        }
        return in;
    }
}

