/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.controller;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.util.IOUtils;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.constant.Secured;
import com.tcdng.unify.web.ui.controller.FileResourceController;
import com.tcdng.unify.web.util.RealPathUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

@Component(value="/resource/realpath")
public class RealPathResourceController
extends FileResourceController {
    protected File file;
    private String subfolder;

    public RealPathResourceController() {
        this((String)null);
    }

    public RealPathResourceController(String subfolder) {
        super(Secured.FALSE);
        this.subfolder = subfolder;
    }

    @Override
    public void prepareExecution() throws UnifyException {
        String resourceName = this.getResourceName();
        if (!StringUtils.isBlank((String)this.subfolder)) {
            resourceName = this.subfolder + resourceName;
        } else {
            RealPathUtils.checkAccessibleRealPath((String)resourceName);
        }
        super.prepareExecution();
        this.file = new File(IOUtils.buildFilename((String)this.getUnifyComponentContext().getWorkingPath(), (String)resourceName));
        if (this.file.exists()) {
            this.setContentLength(this.file.length());
        }
    }

    @Override
    protected InputStream getInputStream() throws UnifyException {
        if (this.file != null && this.file.exists()) {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                this.throwOperationErrorException(e);
            }
        }
        return null;
    }
}

