/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.controller;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.constant.Scope;
import com.tcdng.unify.core.resource.ResourceGenerator;
import com.tcdng.unify.core.util.IOUtils;
import com.tcdng.unify.web.annotation.RequestParameter;
import com.tcdng.unify.web.constant.Secured;
import com.tcdng.unify.web.ui.AbstractPageResourceController;
import java.io.InputStream;
import java.io.OutputStream;

@Component(value="/resource/scope")
public class ScopeResourceController
extends AbstractPageResourceController {
    @RequestParameter
    private String scope;
    @RequestParameter
    private boolean clearOnRead;
    private boolean isApplicationScope;
    private Object resource;

    public ScopeResourceController() {
        super(Secured.FALSE);
    }

    @Override
    public void prepareExecution() throws UnifyException {
        this.setContentDisposition(this.getResourceName());
        this.isApplicationScope = Scope.APPLICATION.equals((Object)Scope.fromCode((String)this.scope));
        this.resource = this.isApplicationScope ? this.getApplicationAttribute(this.getResourceName()) : this.getSessionContext().getAttribute(this.getResourceName());
        if (this.resource != null && this.resource instanceof byte[]) {
            this.setContentLength(((byte[])this.resource).length);
        }
    }

    @Override
    public void execute(OutputStream outputStream) throws UnifyException {
        InputStream inputStream = null;
        if (this.resource != null) {
            if (this.resource instanceof byte[]) {
                IOUtils.writeAll((OutputStream)outputStream, (byte[])((byte[])this.resource));
            } else if (this.resource instanceof InputStream) {
                inputStream = (InputStream)this.resource;
                IOUtils.writeAll((OutputStream)outputStream, (InputStream)inputStream);
                this.clearOnRead = true;
            } else if (this.resource instanceof ResourceGenerator) {
                ((ResourceGenerator)this.resource).generate(outputStream);
                this.clearOnRead = true;
            }
            if (this.clearOnRead) {
                if (this.isApplicationScope) {
                    this.removeApplicationAttribute(this.getResourceName());
                } else {
                    this.getSessionContext().removeAttribute(this.getResourceName());
                }
            }
        }
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean isClearOnRead() {
        return this.clearOnRead;
    }

    public void setClearOnRead(boolean clearOnRead) {
        this.clearOnRead = clearOnRead;
    }
}

