/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.response;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.web.ui.AbstractJsonPageControllerResponse;
import com.tcdng.unify.web.ui.widget.Page;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.data.Hint;
import java.util.List;

@Component(value="hintuserresponse")
public class HintUserResponse
extends AbstractJsonPageControllerResponse {
    public HintUserResponse() {
        super("hintUserHdl", false);
    }

    @Override
    protected void doGenerate(ResponseWriter writer, Page page) throws UnifyException {
        this.logDebug("Preparing hint user response: path ID = [{0}]", new Object[]{page.getPathId()});
        List<Hint> hintList = this.getRequestContextUtil().getUserHints();
        if (hintList != null && !hintList.isEmpty()) {
            writer.write(",\"hintUserHtml\":");
            StringBuilder hsb = new StringBuilder();
            hsb.append("<div class=\"ui-user-hint\">");
            for (Hint hint : hintList) {
                hsb.append("<span class=\"");
                switch (hint.getMode()) {
                    case ERROR: {
                        hsb.append("ui-user-hint-error");
                        break;
                    }
                    case INFO: {
                        hsb.append("ui-user-hint-info");
                        break;
                    }
                    default: {
                        hsb.append("ui-user-hint-warning");
                    }
                }
                hsb.append("\">");
                hsb.append(hint.getMessage());
                hsb.append("</span>");
            }
            hsb.append("</div>");
            writer.writeJsonQuote(hsb.toString());
        }
    }
}

