/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.response;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.web.ui.AbstractJsonPageControllerResponse;
import com.tcdng.unify.web.ui.widget.Page;
import com.tcdng.unify.web.ui.widget.ResponseWriter;

@Component(value="refreshpanelresponse")
@UplAttributes(value={@UplAttribute(name="panels", type=String[].class)})
public class RefreshPanelResponse
extends AbstractJsonPageControllerResponse {
    public RefreshPanelResponse() {
        super("refreshPanelHdl", true);
    }

    @Override
    protected void doGenerate(ResponseWriter writer, Page page) throws UnifyException {
        boolean useLongNames = false;
        String[] refreshList = this.getPanels();
        if (refreshList == null || refreshList.length == 0) {
            refreshList = this.getRequestContextUtil().getResponseRefreshPanels();
            useLongNames = true;
        }
        this.appendRefreshPanelsJson(writer, page, refreshList, useLongNames);
        writer.write(",");
        this.appendRefreshAttributesJson(writer, false);
        this.appendRegisteredDebounceWidgets(writer, false);
    }

    protected String[] getPanels() throws UnifyException {
        return (String[])this.getUplAttribute(String[].class, "panels");
    }

    private void appendRefreshPanelsJson(ResponseWriter writer, Page page, String[] panelIds, boolean useLongNames) throws UnifyException {
        this.logDebug("Preparing refresh panel response: path ID = [{0}], useLongNames = [{1}]", new Object[]{page.getPathId(), useLongNames});
        writer.write(",\"refreshPanels\":[");
        if (panelIds != null) {
            boolean appendSym = false;
            for (int i = 0; i < panelIds.length; ++i) {
                if (appendSym) {
                    writer.write(Character.valueOf(','));
                } else {
                    appendSym = true;
                }
                if (useLongNames) {
                    writer.writeJsonPanel(page.getPanelByLongName(panelIds[i]), true);
                    continue;
                }
                writer.writeJsonPanel(page.getPanelByShortName(panelIds[i]), true);
            }
        }
        writer.write("]");
    }
}

